/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.proxy.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.portals.applications.webcontent2.proxy.ProxyContext;
import org.apache.portals.applications.webcontent2.proxy.ProxyMapping;
import org.apache.portals.applications.webcontent2.proxy.ProxyMappingRegistry;
import org.apache.portals.applications.webcontent2.proxy.ReverseProxyException;
import org.apache.portals.applications.webcontent2.proxy.impl.AbstractProxyCommand;
import org.apache.portals.applications.webcontent2.proxy.impl.GzippedSource;
import org.apache.portals.applications.webcontent2.proxy.impl.HttpEntitySource;
import org.apache.portals.applications.webcontent2.proxy.util.RequestUtils;
import org.apache.portals.applications.webcontent2.rewriter.ContentRewriter;
import org.apache.portals.applications.webcontent2.rewriter.ContentRewritingContext;
import org.apache.portals.applications.webcontent2.rewriter.Sink;
import org.apache.portals.applications.webcontent2.rewriter.Source;
import org.apache.portals.applications.webcontent2.rewriter.impl.SimpleContentRewritingContext;

public class SerializeHttpEntityContentCommand
extends AbstractProxyCommand {
    private String defaultCharacterEncoding = "UTF-8";

    @Override
    protected boolean executeInternal(ProxyContext context) throws ReverseProxyException, IOException {
        HttpResponse httpResponse = context.getHttpResponse();
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null) {
            if (RequestUtils.isDispatched(context.getRequestContext())) {
                this.writeHttpEntityToDispatcher(context, httpEntity);
            } else {
                this.writeHttpEntityToResponse(context, httpEntity);
            }
        }
        return false;
    }

    public String getDefaultCharacterEncoding() {
        return this.defaultCharacterEncoding;
    }

    public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
        this.defaultCharacterEncoding = defaultCharacterEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeHttpEntityToResponse(ProxyContext context, HttpEntity httpEntity) throws ReverseProxyException, IOException {
        HttpEntitySource source = new HttpEntitySource(httpEntity);
        Sink sink = context.getRequestContext().getSink();
        ContentType contentType = ContentType.getOrDefault((HttpEntity)httpEntity);
        Charset charset = contentType.getCharset();
        String charsetName = StringUtils.defaultIfEmpty((String)(charset != null ? charset.name() : null), (String)this.getDefaultCharacterEncoding());
        boolean gzipEncoded = this.isGzipEncodedContent(httpEntity);
        ContentRewriter contentRewriter = context.getContentRewriter();
        if (contentRewriter == null) {
            InputStream in = null;
            OutputStream out = null;
            try {
                in = source.getInputStream();
                if (in == null) return;
                out = sink.getOutputStream();
                IOUtils.copy((InputStream)in, (OutputStream)out);
                out.flush();
                return;
            }
            finally {
                if (in != null) {
                    IOUtils.closeQuietly((InputStream)in);
                }
                if (out != null) {
                    IOUtils.closeQuietly((OutputStream)out);
                }
            }
        } else {
            ContentRewritingContext rewritingContext = this.createContentRewritingContext(context);
            if (gzipEncoded) {
                contentRewriter.rewrite((Source)new GzippedSource(source, charsetName), sink, rewritingContext);
                return;
            } else {
                contentRewriter.rewrite((Source)source, sink, rewritingContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeHttpEntityToDispatcher(ProxyContext context, HttpEntity httpEntity) throws ReverseProxyException, IOException {
        block12: {
            HttpEntitySource source = new HttpEntitySource(httpEntity);
            Sink sink = context.getRequestContext().getSink();
            ContentType contentType = ContentType.getOrDefault((HttpEntity)httpEntity);
            Charset charset = contentType.getCharset();
            String charsetName = StringUtils.defaultIfEmpty((String)(charset != null ? charset.name() : null), (String)this.getDefaultCharacterEncoding());
            boolean gzipEncoded = this.isGzipEncodedContent(httpEntity);
            ContentRewriter contentRewriter = context.getContentRewriter();
            InputStream in = null;
            InputStreamReader reader = null;
            OutputStream out = null;
            Writer writer = null;
            try {
                if (contentRewriter != null) {
                    ContentRewritingContext rewritingContext = this.createContentRewritingContext(context);
                    if (gzipEncoded) {
                        contentRewriter.rewrite((Source)new GzippedSource(source, charsetName), sink, rewritingContext);
                    } else {
                        contentRewriter.rewrite((Source)source, sink, rewritingContext);
                    }
                    break block12;
                }
                in = source.getInputStream();
                if (in == null) break block12;
                try {
                    out = sink.getOutputStream();
                }
                catch (IllegalStateException e) {
                    writer = sink.getWriter();
                }
                if (out != null) {
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    out.flush();
                } else {
                    reader = charsetName != null ? new InputStreamReader(gzipEncoded ? new GZIPInputStream(in) : in, charsetName) : new InputStreamReader(gzipEncoded ? new GZIPInputStream(in) : in);
                    IOUtils.copy((Reader)reader, (Writer)writer);
                    writer.flush();
                }
            }
            finally {
                if (reader != null) {
                    IOUtils.closeQuietly(reader);
                }
                if (in != null) {
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
        }
    }

    protected ContentRewritingContext createContentRewritingContext(ProxyContext proxyContext) {
        SimpleContentRewritingContext contentRewritingContext = new SimpleContentRewritingContext();
        contentRewritingContext.setAttribute(ProxyContext.class.getName(), (Object)proxyContext);
        contentRewritingContext.setAttribute(ProxyMapping.class.getName(), (Object)proxyContext.getResolvedMapping());
        contentRewritingContext.setAttribute(ProxyMappingRegistry.class.getName(), (Object)proxyContext.getProxyMappingRegistry());
        return contentRewritingContext;
    }

    private boolean isGzipEncodedContent(HttpEntity httpEntity) {
        boolean gzipEncoded = false;
        Header contentEncodingHeader = httpEntity.getContentEncoding();
        if (contentEncodingHeader != null) {
            gzipEncoded = StringUtils.equalsIgnoreCase((String)"gzip", (String)contentEncodingHeader.getValue());
        }
        return gzipEncoded;
    }
}

