/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.proxy.command;

import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.List;
import org.apache.http.client.CookieStore;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.cookie.Cookie;
import org.apache.portals.applications.webcontent2.proxy.ProxyContext;
import org.apache.portals.applications.webcontent2.proxy.ReverseProxyException;
import org.apache.portals.applications.webcontent2.proxy.impl.AbstractProxyCommand;

public class AddCookiesToResponseCommand
extends AbstractProxyCommand {
    @Override
    protected boolean executeInternal(ProxyContext context) throws ReverseProxyException, IOException {
        List responseCookies = null;
        CookieStore cookieStore = context.getCookieStore();
        if (cookieStore != null) {
            responseCookies = cookieStore.getCookies();
        }
        if (responseCookies != null && !responseCookies.isEmpty()) {
            boolean isSecureRequest = context.getRequestContext().isSecure();
            String reverseCookiePath = null;
            for (Cookie cookie : responseCookies) {
                String cookieName = cookie.getName();
                javax.servlet.http.Cookie responseCookie = new javax.servlet.http.Cookie(cookieName, cookie.getValue());
                responseCookie.setSecure(isSecureRequest && cookie.isSecure());
                responseCookie.setVersion(cookie.getVersion());
                responseCookie.setComment(cookie.getComment());
                Date expireDate = cookie.getExpiryDate();
                if (expireDate != null) {
                    int maxAgeSeconds = (int)((expireDate.getTime() - System.currentTimeMillis()) / 1000L);
                    responseCookie.setMaxAge(maxAgeSeconds);
                }
                if ((reverseCookiePath = this.getReverseCookiePath(context, cookie)) != null) {
                    responseCookie.setPath(reverseCookiePath);
                }
                context.getRequestContext().addCookie(responseCookie);
            }
        }
        return false;
    }

    protected String getReverseCookiePath(ProxyContext context, Cookie responseCookie) {
        String cookiePath = responseCookie.getPath();
        if (cookiePath != null) {
            URI remoteURI = context.getRemoteURI();
            URI cookieRemoteURI = URIUtils.resolve((URI)remoteURI, (String)cookiePath);
            cookiePath = context.getResolvedMapping().resolveLocalFromRemote(cookieRemoteURI);
        }
        return cookiePath;
    }
}

