/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.portlet.proxy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.portals.applications.webcontent2.portlet.proxy.DefaultPortletProxyTagNodeVisitor;
import org.apache.portals.applications.webcontent2.portlet.proxy.GenericReverseProxyPortlet;
import org.apache.portals.applications.webcontent2.portlet.proxy.PortletAnyProxyMapping;
import org.apache.portals.applications.webcontent2.proxy.HttpClientContextBuilder;
import org.apache.portals.applications.webcontent2.proxy.ProxyMapping;
import org.apache.portals.applications.webcontent2.proxy.ProxyMappingRegistry;
import org.apache.portals.applications.webcontent2.proxy.ReverseProxyService;
import org.apache.portals.applications.webcontent2.proxy.builder.ProxyServices;
import org.apache.portals.applications.webcontent2.proxy.impl.DefaultProxyMappingRegistry;
import org.apache.portals.applications.webcontent2.proxy.impl.DefaultReverseProxyService;
import org.apache.portals.applications.webcontent2.proxy.impl.ProxyProcessingChain;
import org.apache.portals.applications.webcontent2.proxy.util.ProxyCommandUtils;
import org.apache.portals.applications.webcontent2.rewriter.ContentRewriter;
import org.apache.portals.applications.webcontent2.rewriter.htmlcleaner.DefaultSerializerFactory;
import org.apache.portals.applications.webcontent2.rewriter.htmlcleaner.HtmlCleanerContentRewriter;
import org.apache.portals.applications.webcontent2.rewriter.htmlcleaner.SerializerFactory;
import org.htmlcleaner.SimpleHtmlSerializer;
import org.htmlcleaner.TagNodeVisitor;

public class SimpleReverseProxyPortlet
extends GenericReverseProxyPortlet {
    private static final String XPATH_EXPRESSION_PARAM_NAME = "xpath.expression";
    private static final String INNER_ELEMENTS_ONLY_PARAM_NAME = "inner.elements.only";
    private static final boolean DEFAULT_INNER_ELEMENTS_ONLY_VALUE = true;
    private static final String HTML_CLEANER_TRANSFORMATION_PARAM_NAME = "html.cleaner.transformation";
    private ProxyMappingRegistry proxyMappingRegistry;
    private HttpClientBuilder httpClientBuilder;
    private HttpClientContextBuilder httpClientContextBuilder;
    private LayeredConnectionSocketFactory sslSocketFactory;
    private X509HostnameVerifier hostnameVerifier = SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
    private ProxyProcessingChain proxyServiceCommand;

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        this.initHostnameVerifier(portletConfig);
        this.proxyServiceCommand = this.createProxyServiceCommand();
        ProxyCommandUtils.initializeAllCommands((ProxyProcessingChain)this.proxyServiceCommand);
        DefaultReverseProxyService proxyService = new DefaultReverseProxyService(this.proxyServiceCommand);
        this.setProxyService((ReverseProxyService)proxyService);
    }

    protected void initHostnameVerifier(PortletConfig portletConfig) {
        String param = StringUtils.trim((String)portletConfig.getInitParameter("ssl-hostname-verifier"));
        if (StringUtils.isNotEmpty((String)param)) {
            if (StringUtils.equalsIgnoreCase((String)"ALLOW_ALL_HOSTNAME_VERIFIER", (String)param)) {
                this.setHostnameVerifier(SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            } else if (StringUtils.equalsIgnoreCase((String)"BROWSER_COMPATIBLE_HOSTNAME_VERIFIER", (String)param)) {
                this.setHostnameVerifier(SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            } else if (StringUtils.equalsIgnoreCase((String)"STRICT_HOSTNAME_VERIFIER", (String)param)) {
                this.setHostnameVerifier(SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER);
            }
        }
    }

    public ProxyMappingRegistry getProxyMappingRegistry() {
        if (this.proxyMappingRegistry == null) {
            this.proxyMappingRegistry = new DefaultProxyMappingRegistry();
            this.proxyMappingRegistry.addProxyMapping(this.getProxyMapping());
        }
        return this.proxyMappingRegistry;
    }

    public void setProxyMappingRegistry(ProxyMappingRegistry proxyMappingRegistry) {
        this.proxyMappingRegistry = proxyMappingRegistry;
    }

    public HttpClientBuilder getHttpClientBuilder() {
        if (this.httpClientBuilder == null) {
            this.httpClientBuilder = this.createHttpClientBuilder();
        }
        return this.httpClientBuilder;
    }

    public void setHttpClientBuilder(HttpClientBuilder httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
    }

    public HttpClientContextBuilder getHttpClientContextBuilder() {
        return this.httpClientContextBuilder;
    }

    public void setHttpClientContextBuilder(HttpClientContextBuilder httpClientContextBuilder) {
        this.httpClientContextBuilder = httpClientContextBuilder;
    }

    public LayeredConnectionSocketFactory getSslSocketFactory() {
        if (this.sslSocketFactory == null) {
            this.sslSocketFactory = this.createSslSocketFactory();
        }
        return this.sslSocketFactory;
    }

    public void setSslSocketFactory(LayeredConnectionSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public X509HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(X509HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void destroy() {
        ProxyCommandUtils.destroyAllCommands((ProxyProcessingChain)this.proxyServiceCommand);
        super.destroy();
    }

    protected ProxyProcessingChain createProxyServiceCommand() {
        return ProxyServices.createDefault().build(this.getProxyMappingRegistry(), this.getHttpClientBuilder(), this.getHttpClientContextBuilder());
    }

    protected ProxyMapping getProxyMapping() {
        PortletAnyProxyMapping portletAnyProxyMapping = new PortletAnyProxyMapping(this.getPortletConfig());
        portletAnyProxyMapping.setContentRewriters(this.getContentRewriters());
        return portletAnyProxyMapping;
    }

    protected Map<String, ContentRewriter> getContentRewriters() {
        List<TagNodeVisitor> tagNodeVisitors;
        HashMap<String, ContentRewriter> contentRewriters = new HashMap<String, ContentRewriter>();
        DefaultSerializerFactory serializerFactory = new DefaultSerializerFactory();
        serializerFactory.setSerializerClass(SimpleHtmlSerializer.class);
        HtmlCleanerContentRewriter contentRewriter = new HtmlCleanerContentRewriter();
        contentRewriter.setSerializerFactory((SerializerFactory)serializerFactory);
        contentRewriter.setXpathExpression(this.getXpathExpression());
        contentRewriter.setInnerHtmlOnly(this.isInnerElementsOnly());
        Object[] cleanerTransformations = this.getCleanerTransformationStringArray();
        if (!ArrayUtils.isEmpty((Object[])cleanerTransformations)) {
            contentRewriter.setCleanerTransformationStringArray((String[])cleanerTransformations);
        }
        if (!(tagNodeVisitors = this.getTagNodeVisitors()).isEmpty()) {
            for (TagNodeVisitor visitor : tagNodeVisitors) {
                contentRewriter.addTagNodeVisitor(visitor);
            }
        }
        contentRewriters.put("text/html", (ContentRewriter)contentRewriter);
        return contentRewriters;
    }

    protected String getXpathExpression() {
        String expression = this.getPortletConfig().getInitParameter(XPATH_EXPRESSION_PARAM_NAME);
        if (expression == null || StringUtils.isBlank((String)expression)) {
            return "//body";
        }
        return expression;
    }

    protected boolean isInnerElementsOnly() {
        String param = this.getPortletConfig().getInitParameter(INNER_ELEMENTS_ONLY_PARAM_NAME);
        if (StringUtils.isBlank((String)param)) {
            return true;
        }
        return BooleanUtils.toBoolean((String)param);
    }

    protected String[] getCleanerTransformationStringArray() {
        String param = this.getPortletConfig().getInitParameter(HTML_CLEANER_TRANSFORMATION_PARAM_NAME);
        if (param == null || StringUtils.isBlank((String)param)) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        String[] tokens = StringUtils.split((String)param, (String)"|");
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = StringUtils.trim((String)tokens[i]);
        }
        return tokens;
    }

    protected List<TagNodeVisitor> getTagNodeVisitors() {
        ArrayList<TagNodeVisitor> visitors = new ArrayList<TagNodeVisitor>();
        visitors.add((TagNodeVisitor)new DefaultPortletProxyTagNodeVisitor());
        return visitors;
    }

    protected HttpClientBuilder createHttpClientBuilder() {
        HttpClientBuilder builder = HttpClients.custom().useSystemProperties();
        LayeredConnectionSocketFactory sslSocketFactory = this.getSslSocketFactory();
        if (sslSocketFactory != null) {
            builder.setSSLSocketFactory(sslSocketFactory);
        }
        return builder;
    }

    protected LayeredConnectionSocketFactory createSslSocketFactory() {
        return new SSLConnectionSocketFactory(SSLContexts.createDefault(), this.getHostnameVerifier());
    }
}

