/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.portlet.proxy;

import java.net.URI;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.portals.applications.webcontent2.portlet.proxy.PortletRequestContext;
import org.apache.portals.applications.webcontent2.proxy.ProxyContext;
import org.apache.portals.applications.webcontent2.proxy.impl.AbstractProxyMapping;

public class PortletAnyProxyMapping
extends AbstractProxyMapping {
    private PortletConfig portletConfig;

    public PortletAnyProxyMapping(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public boolean matchesLocal(String localPath) {
        return true;
    }

    public String resolveRemoteFromLocal(String localPath) {
        return this.getCurrentRemoteURI();
    }

    public boolean matchesRemote(URI remoteURI) {
        return true;
    }

    public String resolveLocalFromRemote(URI remoteURI) {
        return "/";
    }

    protected PortletConfig getPortletConfig() {
        return this.portletConfig;
    }

    protected String getCurrentRemoteURI() {
        ProxyContext proxyContext = ProxyContext.getCurrentProxyContext();
        PortletRequestContext prc = (PortletRequestContext)proxyContext.getRequestContext();
        PortletRequest request = prc.getPortletRequest();
        String remoteURI = request.getParameter("remote.uri");
        if (StringUtils.isBlank((String)remoteURI)) {
            remoteURI = request.getPreferences().getValue("remote.uri", null);
        }
        if (StringUtils.isBlank((String)remoteURI)) {
            remoteURI = this.getPortletConfig().getInitParameter("remote.uri");
        }
        return remoteURI;
    }
}

