/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.portlet.proxy;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.MimeResponse;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import org.apache.http.client.utils.URIUtils;
import org.apache.portals.applications.webcontent2.portlet.proxy.PortletRequestContext;
import org.apache.portals.applications.webcontent2.proxy.ProxyContext;
import org.apache.portals.applications.webcontent2.proxy.util.RewriterUtils;
import org.apache.portals.applications.webcontent2.rewriter.htmlcleaner.AbstractProxyTagNodeVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPortletProxyTagNodeVisitor
extends AbstractProxyTagNodeVisitor {
    private static Logger log = LoggerFactory.getLogger(DefaultPortletProxyTagNodeVisitor.class);
    private static final Map<String, String[]> DEFAULT_TAG_NAME_AND_LINK_ATTRS = new HashMap<String, String[]>();

    public DefaultPortletProxyTagNodeVisitor() {
        this(DEFAULT_TAG_NAME_AND_LINK_ATTRS);
    }

    public DefaultPortletProxyTagNodeVisitor(Map<String, String[]> tagNameAndLinkAttrs) {
        super(tagNameAndLinkAttrs);
    }

    protected String rewriteURI(String tagName, String attrName, String uri) {
        if (!this.isRewritableURI(uri)) {
            return uri;
        }
        ProxyContext proxyContext = ProxyContext.getCurrentProxyContext();
        PortletRequestContext prc = (PortletRequestContext)proxyContext.getRequestContext();
        PortletResponse response = prc.getPortletResponse();
        if (!(response instanceof MimeResponse)) {
            log.error("Cannot rewrite url because response is not a MimeResponse.");
            return uri;
        }
        URI remoteURI = proxyContext.getRemoteURI();
        URI uriObj = null;
        try {
            uriObj = URI.create(uri);
        }
        catch (Exception e) {
            log.warn("Invalid uri: '{}'.", (Object)uri);
            return uri;
        }
        URI rewrittenURI = URIUtils.resolve((URI)remoteURI, (URI)uriObj);
        if ("src".equals(attrName)) {
            return rewrittenURI.toString();
        }
        PortletURL actionUrl = ((MimeResponse)response).createActionURL();
        actionUrl.setParameter("remote.uri", rewrittenURI.toString());
        return actionUrl.toString();
    }

    protected boolean isRewritableURI(String uri) {
        return RewriterUtils.isRewritableURI((String)uri);
    }

    static {
        DEFAULT_TAG_NAME_AND_LINK_ATTRS.put("a", new String[]{"href"});
        DEFAULT_TAG_NAME_AND_LINK_ATTRS.put("img", new String[]{"src"});
        DEFAULT_TAG_NAME_AND_LINK_ATTRS.put("form", new String[]{"action"});
    }
}

