/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.portlet.history;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class WebContentPage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String method;
    private String url;
    private Map<String, String[]> params;

    public WebContentPage(String url) {
        this(url, null);
    }

    public WebContentPage(String url, String method) {
        this(url, method, null);
    }

    public WebContentPage(String url, String method, Map<String, String[]> params) {
        if (url == null) {
            throw new IllegalArgumentException("url must not be null.");
        }
        this.url = url;
        this.method = method;
        this.params = new LinkedHashMap<String, String[]>();
        if (params != null) {
            this.params.putAll(params);
        }
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String[]> getParams() {
        return Collections.unmodifiableMap(this.params);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof WebContentPage)) {
            return false;
        }
        WebContentPage other = (WebContentPage)o;
        return StringUtils.equals((String)other.url, (String)this.url) && StringUtils.equals((String)other.method, (String)this.method) && other.params.equals(this.params);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString()).append(' ');
        sb.append("[").append(this.method).append(": ").append(this.url).append(", params: ").append(this.params).append("]");
        return sb.toString();
    }
}

