/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.portlet;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.portals.bridges.velocity.GenericVelocityPortlet;
import org.apache.portals.messaging.PortletMessaging;
import org.w3c.dom.Element;

public class IFrameGenericPortlet
extends GenericVelocityPortlet {
    public static final String IFRAME_AUTORESIZE_SCRIPT_ID = "org.apache.portals.applications.webcontent2.portlet.iframe.autoresize";
    public static final String IFRAME_SRC_URL = "org.apache.portals.applications.webcontent2.portlet.iframe.src";
    public static final String[] SRC_REPLACE_KEYS = new String[]{"${serverName}", "${serverPort}", "${contextPath}"};
    private Map<String, String> attributes = new HashMap<String, String>();
    private Map<String, String> maxAttributes = new HashMap<String, String>();
    private boolean isPortlet10Container;
    private String recordVisitResourcePage = "/WEB-INF/view/iframe-record-visit.jsp";

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.attributes.put("TITLE", "");
        this.attributes.put("SRC", "http://www.apache.org");
        this.attributes.put("PROXYREMOTEURL", "");
        this.attributes.put("PROXYLOCALPATH", "");
        this.attributes.put("ALIGN", "BOTTOM");
        this.attributes.put("CLASS", "");
        this.attributes.put("FRAMEBORDER", "0");
        this.attributes.put("ID", "");
        this.attributes.put("MARGINHEIGHT", "0");
        this.attributes.put("MARGINWIDTH", "0");
        this.attributes.put("NAME", "");
        this.attributes.put("AUTORESIZE", "false");
        this.attributes.put("VISITLASTPAGE", "false");
        this.attributes.put("HANDLERSCRIPT", "");
        this.attributes.put("HEIGHT", "");
        this.attributes.put("WIDTH", "100%");
        this.attributes.put("SCROLLING", "NO");
        this.attributes.put("STYLE", "");
        this.maxAttributes.put("HEIGHT", "800");
        this.maxAttributes.put("WIDTH", "100%");
        this.maxAttributes.put("SCROLLING", "AUTO");
        this.maxAttributes.put("STYLE", "");
        String param = config.getInitParameter("recordVisitResourcePage");
        if (param != null) {
            this.recordVisitResourcePage = param;
        }
        try {
            ClassUtils.getPublicMethod(PortletConfig.class, (String)"getDefaultNamespace", (Class[])new Class[0]);
        }
        catch (Throwable ignorable) {
            this.isPortlet10Container = true;
        }
    }

    private String getAttributePreference(PortletPreferences prefs, String attribute) {
        return this.getMappedAttributePreference(prefs, attribute, this.attributes);
    }

    private String getMaxAttributePreference(PortletPreferences prefs, String attribute) {
        return this.getMappedAttributePreference(prefs, "MAX-" + attribute, this.maxAttributes);
    }

    private String getMappedAttributePreference(PortletPreferences prefs, String attribute, Map<String, String> map) {
        return prefs.getValue(attribute, map.get(attribute));
    }

    private void appendAttribute(PortletPreferences prefs, StringWriter content, String attribute, Map<String, String> map) {
        String value = map == this.maxAttributes ? this.getMaxAttributePreference(prefs, attribute) : this.getAttributePreference(prefs, attribute);
        if (value == null || value.length() == 0) {
            return;
        }
        content.append(" ").append(attribute).append("=\"").append(value).append("\"");
    }

    private void appendAttribute(PortletPreferences prefs, StringWriter content, String attribute) {
        this.appendAttribute(prefs, content, attribute, this.attributes);
    }

    private void appendMaxAttribute(PortletPreferences prefs, StringWriter content, String attribute) {
        this.appendAttribute(prefs, content, attribute, this.maxAttributes);
    }

    protected void doHeaders(RenderRequest request, RenderResponse response) {
        PortletPreferences prefs = request.getPreferences();
        boolean autoResize = BooleanUtils.toBoolean((String)this.getAttributePreference(prefs, "AUTORESIZE"));
        boolean visitLastPage = BooleanUtils.toBoolean((String)this.getAttributePreference(prefs, "VISITLASTPAGE"));
        if (autoResize || visitLastPage) {
            String handlerScript = this.getAttributePreference(prefs, "HANDLERSCRIPT");
            if (StringUtils.isBlank((String)handlerScript)) {
                handlerScript = request.getContextPath() + "/javascript/iframe_handler.js";
            }
            try {
                Element headElem = (Element)MethodUtils.invokeMethod((Object)response, (String)"createElement", (Object[])new Object[]{"script"});
                headElem.setAttribute("id", IFRAME_AUTORESIZE_SCRIPT_ID);
                headElem.setAttribute("language", "JavaScript");
                headElem.setAttribute("type", "text/javascript");
                headElem.setAttribute("src", handlerScript);
                MethodUtils.invokeMethod((Object)response, (String)"addProperty", (Object[])new Object[]{"javax.portlet.markup.head.element", headElem});
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke portlet 2.0 api.", e);
            }
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String viewPage = (String)request.getAttribute("ViewPage");
        if (viewPage != null) {
            super.doView(request, response);
        } else {
            this.doIFrame(request, response);
        }
    }

    public void setupPreferencesEdit(RenderRequest request, RenderResponse response) {
        PortletPreferences prefs = request.getPreferences();
        String editablePrefNames = this.getAttributePreference(prefs, "EDITABLEPREFS");
        if (StringUtils.isBlank((String)editablePrefNames)) {
            super.setupPreferencesEdit(request, response);
        } else {
            ArrayList<DefaultMapEntry> prefEntryList = new ArrayList<DefaultMapEntry>();
            HashMap<String, String> prefsMap = new HashMap<String, String>();
            String[] prefNames = StringUtils.split((String)editablePrefNames, (String)",");
            String[] emptyValues = new String[]{};
            for (String prefName : prefNames) {
                String[] prefValues = prefs.getValues(prefName = prefName.trim(), emptyValues);
                prefsMap.put(prefName, prefValues.length == 0 ? "" : prefValues[0]);
                prefEntryList.add(new DefaultMapEntry((Object)prefName, (Object)prefValues));
            }
            this.getContext(request, response).put("prefs", prefEntryList.iterator());
            this.getContext(request, response).put("prefsMap", prefsMap);
        }
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        this.doPreferencesEdit(request, response);
    }

    public void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        super.doHelp(request, response);
    }

    public void doCustom(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        super.doCustom(request, response);
    }

    protected void doIFrame(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletPreferences prefs = request.getPreferences();
        String source = this.getURLSource(request, response, prefs);
        StringWriter content = new StringWriter(4096);
        content.append("<TABLE CLASS='iframePortletTableContainer' WIDTH='100%'><TBODY CLASS='iframePortletTbodyContainer'><TR><TD>");
        content.append("<IFRAME");
        content.append(" ").append("SRC").append("=\"").append(source).append("\"");
        this.appendAttribute(prefs, content, "ALIGN");
        this.appendAttribute(prefs, content, "CLASS");
        this.appendAttribute(prefs, content, "FRAMEBORDER");
        this.appendAttribute(prefs, content, "ID");
        this.appendAttribute(prefs, content, "MARGINHEIGHT");
        this.appendAttribute(prefs, content, "MARGINWIDTH");
        this.appendAttribute(prefs, content, "NAME");
        if (BooleanUtils.toBoolean((String)this.getAttributePreference(prefs, "AUTORESIZE"))) {
            this.appendAttribute(prefs, content, "AUTORESIZE");
        }
        if (BooleanUtils.toBoolean((String)this.getAttributePreference(prefs, "VISITLASTPAGE"))) {
            this.appendAttribute(prefs, content, "VISITLASTPAGE");
            if (!this.isPortlet10Container) {
                try {
                    Object visitPageResourceURL = MethodUtils.invokeMethod((Object)response, (String)"createResourceURL", null);
                    MethodUtils.invokeMethod((Object)visitPageResourceURL, (String)"setResourceID", (Object[])new Object[]{this.recordVisitResourcePage});
                    content.append(" ").append("visitresourceurl").append("=\"");
                    MethodUtils.invokeMethod((Object)visitPageResourceURL, (String)"write", (Object[])new Object[]{content, Boolean.TRUE});
                    content.append("\"");
                }
                catch (Exception e) {
                    throw new PortletException("Failed to invoke portlet 2.0 api.", (Throwable)e);
                }
            } else {
                PortletURL visitPageActionURL = response.createActionURL();
                visitPageActionURL.setParameter("action", "visit");
                content.append(" ").append("visitresourceurl").append("=\"");
                content.append(visitPageActionURL.toString());
                content.append("\"");
            }
        }
        if (request.getWindowState().equals((Object)WindowState.MAXIMIZED)) {
            this.appendMaxAttribute(prefs, content, "HEIGHT");
            this.appendMaxAttribute(prefs, content, "WIDTH");
            this.appendMaxAttribute(prefs, content, "SCROLLING");
            this.appendMaxAttribute(prefs, content, "STYLE");
        } else {
            this.appendAttribute(prefs, content, "HEIGHT");
            this.appendAttribute(prefs, content, "WIDTH");
            this.appendAttribute(prefs, content, "SCROLLING");
            this.appendAttribute(prefs, content, "STYLE");
        }
        content.append(">");
        content.append("<P STYLE=\"textAlign:center\"><A HREF=\"").append(source).append("\">").append(source).append("</A></P>");
        content.append("</IFRAME>");
        content.append("</TD></TR></TBODY></TABLE>");
        if (this.isPortlet10Container) {
            boolean autoResize = BooleanUtils.toBoolean((String)this.getAttributePreference(prefs, "AUTORESIZE"));
            boolean visitLastPage = BooleanUtils.toBoolean((String)this.getAttributePreference(prefs, "VISITLASTPAGE"));
            if (autoResize || visitLastPage) {
                String handlerScript = this.getAttributePreference(prefs, "HANDLERSCRIPT");
                if (StringUtils.isBlank((String)handlerScript)) {
                    handlerScript = request.getContextPath() + "/javascript/iframe_handler.js";
                }
                content.append("\n<script id=\"").append(IFRAME_AUTORESIZE_SCRIPT_ID).append("\" ");
                content.append("language=\"JavaScript\" type=\"text/javascript\" ");
                content.append("src=\"").append(handlerScript).append("\">");
                content.append("</script>\n");
            }
        }
        response.setContentType("text/html");
        response.getWriter().print(content.toString());
    }

    public String getURLSource(RenderRequest request, RenderResponse response, PortletPreferences prefs) {
        String[] srcReplaceValues = new String[]{request.getServerName(), Integer.toString(request.getServerPort()), request.getContextPath()};
        String source = (String)PortletMessaging.receive((PortletRequest)request, (String)IFRAME_SRC_URL);
        if (source == null) {
            source = StringUtils.replaceEach((String)this.getAttributePreference(prefs, "SRC"), (String[])SRC_REPLACE_KEYS, (String[])srcReplaceValues);
        }
        String proxyRemoteURL = StringUtils.replaceEach((String)this.getAttributePreference(prefs, "PROXYREMOTEURL"), (String[])SRC_REPLACE_KEYS, (String[])srcReplaceValues);
        String proxyLocalPath = StringUtils.replaceEach((String)this.getAttributePreference(prefs, "PROXYLOCALPATH"), (String[])SRC_REPLACE_KEYS, (String[])srcReplaceValues);
        if (StringUtils.isNotEmpty((String)proxyRemoteURL) && StringUtils.isNotEmpty((String)proxyLocalPath) && StringUtils.startsWith((String)source, (String)proxyRemoteURL)) {
            source = proxyLocalPath + source.substring(proxyRemoteURL.length());
        }
        return source;
    }

    public void processAction(ActionRequest request, ActionResponse actionResponse) throws PortletException, IOException {
        if ("visit".equals(request.getParameter("action"))) {
            String url = request.getParameter("URL");
            if (!StringUtils.isBlank((String)url)) {
                PortletMessaging.publish((PortletRequest)request, (String)IFRAME_SRC_URL, (Object)url.trim());
            }
        } else {
            this.processPreferencesAction(request, actionResponse);
        }
    }

    protected String getTitle(RenderRequest request) {
        String title = this.getAttributePreference(request.getPreferences(), "TITLE");
        if (!StringUtils.isEmpty((String)title)) {
            return title;
        }
        return super.getTitle(request);
    }
}

