# Getting Started Guide

By now you should understand the fundamental concepts of how a Projection works by reading about its @ref:[use cases](../use-cases.md).
This guide will briefly describe the basic components of a Projection and instruct you step-by-step on how to build a functioning application.

@@toc { depth=2 }

@@@ index

* [Setup your application](setup-your-app.md)
* [Choosing a Source Provider](source-provider.md)
* [Build a Stateful Projection handler](projection-handler.md)
* [Writing tests for a Projection](testing.md)
* [Running the Projection](running.md)
* [Running the Projection in Apache Pekko Cluster](running-cluster.md)

@@@

## Video Introduction

This video on YouTube gives a short introduction to Akka Projections for processing a stream of events or records from a source to a projected model or external system.

[![Akka Projections introduction](../assets/intro-video.png)](https://www.youtube.com/watch?v=0toyKxomdwo "Watch video on YouTube")
