/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.init;

import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.flowanalysis.FlowAnalysisRule;
import org.apache.nifi.flowanalysis.FlowAnalysisRuleInitializationContext;
import org.apache.nifi.init.ConfigurableComponentInitializer;
import org.apache.nifi.init.ReflectionUtils;
import org.apache.nifi.mock.MockComponentLogger;
import org.apache.nifi.mock.MockConfigurationContext;
import org.apache.nifi.mock.MockFlowAnalysisRuleInitializationContext;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.reporting.InitializationException;

public class FlowAnalysisRuleInitializer
implements ConfigurableComponentInitializer {
    private final ExtensionManager extensionManager;

    public FlowAnalysisRuleInitializer(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    @Override
    public void initialize(ConfigurableComponent component) throws InitializationException {
        FlowAnalysisRule flowAnalysisRule = (FlowAnalysisRule)component;
        MockFlowAnalysisRuleInitializationContext context = new MockFlowAnalysisRuleInitializationContext();
        try (NarCloseable ignored = NarCloseable.withComponentNarLoader(this.extensionManager, component.getClass(), context.getIdentifier());){
            flowAnalysisRule.initialize((FlowAnalysisRuleInitializationContext)context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void teardown(ConfigurableComponent component) {
        FlowAnalysisRule flowAnalysisRule = (FlowAnalysisRule)component;
        try (NarCloseable ignored = NarCloseable.withComponentNarLoader(this.extensionManager, component.getClass(), component.getIdentifier());){
            MockConfigurationContext context = new MockConfigurationContext();
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnShutdown.class, flowAnalysisRule, new MockComponentLogger(), context);
        }
        finally {
            this.extensionManager.removeInstanceClassLoader(component.getIdentifier());
        }
    }
}

