/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import org.aopalliance.intercept.MethodInvocation;
import org.springframework.security.authorization.AuthorizationDeniedException;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.method.MethodAuthorizationDeniedHandler;
import org.springframework.security.authorization.method.MethodInvocationResult;

public final class ThrowingMethodAuthorizationDeniedHandler
implements MethodAuthorizationDeniedHandler {
    @Override
    public Object handleDeniedInvocation(MethodInvocation methodInvocation, AuthorizationResult authorizationResult) {
        if (authorizationResult instanceof AuthorizationDeniedException) {
            AuthorizationDeniedException denied = (AuthorizationDeniedException)authorizationResult;
            throw denied;
        }
        throw new AuthorizationDeniedException("Access Denied", authorizationResult);
    }

    @Override
    public Object handleDeniedInvocationResult(MethodInvocationResult methodInvocationResult, AuthorizationResult authorizationResult) {
        if (authorizationResult instanceof AuthorizationDeniedException) {
            AuthorizationDeniedException denied = (AuthorizationDeniedException)authorizationResult;
            throw denied;
        }
        throw new AuthorizationDeniedException("Access Denied", authorizationResult);
    }
}

