/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.util.ClassUtils;

class ServletRegistrationsSupport {
    private final Collection<RegistrationMapping> registrations;

    ServletRegistrationsSupport(ServletContext servletContext) {
        Map registrations = servletContext.getServletRegistrations();
        ArrayList<RegistrationMapping> mappings = new ArrayList<RegistrationMapping>();
        for (Map.Entry entry : registrations.entrySet()) {
            if (((ServletRegistration)entry.getValue()).getMappings().isEmpty()) continue;
            for (String mapping : ((ServletRegistration)entry.getValue()).getMappings()) {
                mappings.add(new RegistrationMapping((ServletRegistration)entry.getValue(), mapping));
            }
        }
        this.registrations = mappings;
    }

    Collection<RegistrationMapping> dispatcherServletMappings() {
        ArrayList<RegistrationMapping> mappings = new ArrayList<RegistrationMapping>();
        for (RegistrationMapping registration : this.registrations) {
            if (!registration.isDispatcherServlet()) continue;
            mappings.add(registration);
        }
        return mappings;
    }

    Collection<RegistrationMapping> mappings() {
        return this.registrations;
    }

    record RegistrationMapping(ServletRegistration registration, String mapping) {
        boolean isDispatcherServlet() {
            Class dispatcherServlet = ClassUtils.resolveClassName((String)"org.springframework.web.servlet.DispatcherServlet", null);
            try {
                Class<?> clazz = Class.forName(this.registration.getClassName());
                return dispatcherServlet.isAssignableFrom(clazz);
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
        }

        boolean isDefault() {
            return "/".equals(this.mapping);
        }
    }
}

