/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.persistence;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.nifi.controller.serialization.FlowSerializationException;
import org.apache.nifi.web.api.dto.TemplateDTO;

public final class TemplateSerializer {
    private static final JAXBContext jaxbContext;

    public static byte[] serialize(TemplateDTO dto) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(baos);
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)dto, (OutputStream)bos);
            bos.flush();
            return baos.toByteArray();
        }
        catch (IOException | JAXBException e) {
            throw new FlowSerializationException(e);
        }
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TemplateDTO.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException("Cannot create JAXBContext for serializing templates", e);
        }
    }
}

