/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.patricia;

import jetbrains.exodus.tree.INode;
import jetbrains.exodus.tree.patricia.NodeBase;
import jetbrains.exodus.tree.patricia.PatriciaTraverser;
import jetbrains.exodus.tree.patricia.PatriciaTreeBase;
import org.jetbrains.annotations.NotNull;

final class PatriciaReclaimSourceTraverser
extends PatriciaTraverser {
    private final long minAddress;

    PatriciaReclaimSourceTraverser(@NotNull PatriciaTreeBase tree, @NotNull NodeBase currentNode, long minAddress) {
        super(tree, currentNode);
        this.minAddress = minAddress;
        this.init(true);
    }

    @Override
    @NotNull
    public INode moveRight() {
        INode result;
        do {
            result = super.moveRight();
        } while (this.isValidPos() && !this.isAddressReclaimable(this.currentChild.suffixAddress));
        return result;
    }

    void moveToNextReclaimable() {
        while (this.isValidPos() && !this.isAddressReclaimable(this.currentChild.suffixAddress)) {
            super.moveRight();
        }
    }

    boolean isAddressReclaimable(long address) {
        return this.minAddress <= address;
    }
}

