/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.model.SelectItem;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIFormBase;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectOneBase;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectOneRadio;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectReference;
import org.apache.myfaces.tobago.internal.renderkit.renderer.SelectOneRendererBase;
import org.apache.myfaces.tobago.internal.util.ArrayUtils;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.ObjectUtils;
import org.apache.myfaces.tobago.internal.util.SelectItemUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectOneRadioRenderer<T extends AbstractUISelectOneRadio>
extends SelectOneRendererBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void decodeInternal(FacesContext facesContext, T component) {
        if (this.isOutputOnly(component)) {
            return;
        }
        String group = ((AbstractUISelectOneRadio)component).getGroup();
        if (StringUtils.isBlank(group)) {
            super.decodeInternal(facesContext, component);
        } else {
            String decodingId = this.getDecodingId(facesContext, component);
            Object newValue = facesContext.getExternalContext().getRequestParameterMap().get(decodingId);
            LOG.debug("decode: key='{}' value='{}'", (Object)decodingId, newValue);
            if (component.getValueExpression(Attributes.value.name()) != null) {
                LOG.debug("setSubmittedValue");
                component.setSubmittedValue(newValue);
            } else {
                LOG.debug("resetValue");
                component.resetValue();
            }
            this.decodeClientBehaviors(facesContext, component);
        }
    }

    @Override
    public HtmlElements getComponentTag() {
        return HtmlElements.TOBAGO_SELECT_ONE_RADIO;
    }

    @Override
    protected String getDecodingId(FacesContext facesContext, T component) {
        Object name;
        String group = ((AbstractUISelectOneRadio)component).getGroup();
        if (StringUtils.isNotBlank(group)) {
            AbstractUIFormBase form = ComponentUtils.findForm(component);
            if (form != null) {
                name = form.getClientId(facesContext) + facesContext.getNamingContainerSeparatorChar() + group;
            } else {
                LOG.warn("Can't find form for grouping id.");
                name = group;
            }
        } else {
            name = component.getClientId(facesContext);
        }
        return name;
    }

    @Override
    protected void encodeBeginField(FacesContext facesContext, T component) throws IOException {
        AbstractUISelectReference reference = ((AbstractUISelectOneRadio)component).getRenderRangeReference();
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String id = component.getClientId(facesContext);
        Iterable<SelectItem> items = SelectItemUtils.getItemIterator(facesContext, component);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, component);
        boolean disabled = ((AbstractUISelectOneBase)component).isDisabled();
        boolean readonly = ((AbstractUISelectOneBase)component).isReadonly();
        boolean required = component.isRequired();
        boolean inline = ((AbstractUISelectOneRadio)component).isInline();
        Markup markup = component.getMarkup();
        boolean isInsideCommand = this.isInside(facesContext, HtmlElements.COMMAND);
        String name = this.getDecodingId(facesContext, component);
        writer.startElement(this.getTag(facesContext));
        writer.writeClassAttribute(inline ? BootstrapClass.FORM_CHECK_INLINE : null, component.getCustomClass());
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        boolean first = true;
        Object value = component.getValue();
        String submittedValue = (String)component.getSubmittedValue();
        int i = 0;
        int[] renderRange = this.getRenderRangeList((AbstractUISelectOneRadio)component, reference);
        for (SelectItem item : items) {
            if (renderRange == null || ArrayUtils.contains(renderRange, i)) {
                String label;
                org.apache.myfaces.tobago.model.SelectItem tobagoItem;
                String image;
                String formattedValue = this.getFormattedValue(facesContext, component, item.getValue());
                boolean checked = submittedValue == null ? ObjectUtils.equals(item.getValue(), value) : ObjectUtils.equals(formattedValue, submittedValue);
                if (item.isNoSelectionOption() && component.isRequired() && value != null && !checked) continue;
                boolean itemDisabled = item.isDisabled() || disabled;
                String itemId = id + "::" + i;
                writer.startElement(HtmlElements.DIV);
                writer.writeClassAttribute(BootstrapClass.FORM_CHECK, inline ? BootstrapClass.FORM_CHECK_INLINE : null, isInsideCommand ? BootstrapClass.DROPDOWN_ITEM : null);
                writer.startElement(HtmlElements.INPUT);
                writer.writeClassAttribute(BootstrapClass.FORM_CHECK_INPUT, BootstrapClass.validationColor(ComponentUtils.getMaximumSeverity(component)));
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.RADIO);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.CHECKED, checked);
                writer.writeNameAttribute(name);
                writer.writeIdAttribute(itemId);
                writer.writeAttribute(HtmlAttributes.VALUE, formattedValue, true);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, itemDisabled);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, required);
                if (first) {
                    SelectOneRadioRenderer.renderFocus(id, ((AbstractUISelectOneBase)component).isFocus(), ((AbstractUISelectOneBase)component).isError(), facesContext, writer);
                    first = false;
                }
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, ((AbstractUISelectOneBase)component).getTabIndex());
                writer.endElement(HtmlElements.INPUT);
                writer.startElement(HtmlElements.LABEL);
                writer.writeClassAttribute(BootstrapClass.FORM_CHECK_LABEL);
                writer.writeAttribute(HtmlAttributes.FOR, itemId, false);
                if (item instanceof org.apache.myfaces.tobago.model.SelectItem && (image = (tobagoItem = (org.apache.myfaces.tobago.model.SelectItem)item).getImage()) != null) {
                    writer.startElement(HtmlElements.IMG);
                    writer.writeAttribute(HtmlAttributes.SRC, image, true);
                    writer.writeAttribute(HtmlAttributes.ALT, "", false);
                    writer.endElement(HtmlElements.IMG);
                }
                if ((label = item.getLabel()) != null) {
                    writer.writeText(label);
                }
                writer.endElement(HtmlElements.LABEL);
                writer.endElement(HtmlElements.DIV);
            }
            ++i;
        }
    }

    private int[] getRenderRangeList(AbstractUISelectOneRadio select, AbstractUISelectReference reference) {
        int[] indices = StringUtils.getIndices(reference != null ? reference.getRenderRange() : select.getRenderRange());
        return (int[])(indices.length > 0 ? indices : null);
    }

    @Override
    protected void encodeEndField(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(this.getTag(facesContext));
        this.encodeBehavior(writer, facesContext, (ClientBehaviorHolder)component);
    }

    private HtmlElements getTag(FacesContext facesContext) {
        if (this.isInside(facesContext, HtmlElements.COMMAND)) {
            return HtmlElements.TOBAGO_SELECT_ONE_RADIO;
        }
        return HtmlElements.DIV;
    }

    @Override
    protected String getFieldId(FacesContext facesContext, T component) {
        return null;
    }
}

