/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.daemon;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.maven.logging.ProjectBuildLogAppender;

class DaemonInputStream
extends InputStream {
    private final BiConsumer<String, Integer> startReadingFromProject;
    private final LinkedList<byte[]> datas = new LinkedList();
    private final Charset charset;
    private int pos = -1;
    private String projectReading = null;
    private volatile boolean eof = false;

    DaemonInputStream(BiConsumer<String, Integer> startReadingFromProject) {
        this.startReadingFromProject = startReadingFromProject;
        this.charset = Charset.forName(System.getProperty("file.encoding"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        LinkedList<byte[]> linkedList = this.datas;
        synchronized (linkedList) {
            String projectId = ProjectBuildLogAppender.getProjectId();
            if (!this.eof && !Objects.equals(projectId, this.projectReading)) {
                this.projectReading = projectId;
                this.startReadingFromProject.accept(projectId, 1);
            }
            return this.datas.stream().mapToInt(a -> ((byte[])a).length).sum() - Math.max(this.pos, 0);
        }
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b, 0, 1);
        if (read == 1) {
            return b[0];
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        LinkedList<byte[]> linkedList = this.datas;
        synchronized (linkedList) {
            if (this.eof && this.datas.isEmpty()) {
                return -1;
            }
            String projectId = ProjectBuildLogAppender.getProjectId();
            if (!Objects.equals(projectId, this.projectReading)) {
                this.projectReading = projectId;
            }
            int read = 0;
            while (read < len) {
                if (this.datas.isEmpty()) {
                    if (this.eof) {
                        return read > 0 ? read : -1;
                    }
                    if (read > 0) break;
                    this.startReadingFromProject.accept(this.projectReading, len - read);
                    try {
                        this.datas.wait();
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException("Interrupted");
                    }
                    this.pos = -1;
                    continue;
                }
                byte[] curData = this.datas.getFirst();
                if (this.pos >= curData.length) {
                    this.datas.removeFirst();
                    this.pos = -1;
                    continue;
                }
                if (this.pos < 0) {
                    this.pos = 0;
                }
                b[off + read++] = curData[this.pos++];
            }
            return read;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInputData(String data) {
        LinkedList<byte[]> linkedList = this.datas;
        synchronized (linkedList) {
            if (data == null) {
                this.eof = true;
            } else {
                this.datas.add(data.getBytes(this.charset));
            }
            this.datas.notifyAll();
        }
    }
}

