/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.jmh;

import java.util.concurrent.TimeUnit;
import org.apache.lucene.util.SloppyMath;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=1, warmups=1)
@Warmup(iterations=1, time=1)
@Measurement(iterations=3, time=2)
public class SloppySinBenchmark {
    @Benchmark
    public double standardSin(ExecutionPlan plan) {
        return Math.sin(plan.value);
    }

    @Benchmark
    public double sloppySin(ExecutionPlan plan) {
        return SloppyMath.sin((double)plan.value);
    }

    @State(value=Scope.Benchmark)
    public static class ExecutionPlan {
        @Param(value={"0.1", "0.5", "1.0", "2.0", "3.14"})
        public double value;
    }
}

