/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.junit;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.test.junit.Log4jExtension;
import org.apache.logging.log4j.plugins.di.Keys;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.ReflectionSupport;

class AppenderManagerResolver
implements ParameterResolver {
    AppenderManagerResolver() {
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter = parameterContext.getParameter();
        return AbstractManager.class.isAssignableFrom(parameter.getType()) && Keys.hasName((AnnotatedElement)parameter);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter;
        String name;
        Configuration configuration = Log4jExtension.getRequiredLoggerContext(extensionContext).getConfiguration();
        Appender appender = configuration.getAppender(name = Keys.getName((Parameter)(parameter = parameterContext.getParameter())));
        if (appender == null) {
            throw new ParameterResolutionException("No appender named " + name);
        }
        Class<?> appenderClass = appender.getClass();
        Object manager = ReflectionSupport.findMethod(appenderClass, (String)"getManager", (Class[])new Class[0]).map(method -> ReflectionSupport.invokeMethod((Method)method, (Object)appender, (Object[])new Object[0])).orElseThrow(() -> new ParameterResolutionException("Cannot find getManager() on appender " + appenderClass));
        Class<?> parameterType = parameter.getType();
        if (!parameterType.isInstance(manager)) {
            throw new ParameterResolutionException("Expected type " + parameterType + " but got type " + manager.getClass());
        }
        return manager;
    }
}

