/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.script.appender.rolling.action;

import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.rolling.action.PathWithAttributes;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.script.Script;
import org.apache.logging.log4j.core.script.ScriptBindings;
import org.apache.logging.log4j.core.script.ScriptConditional;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.script.ScriptManagerImpl;
import org.apache.logging.log4j.script.ScriptRef;
import org.apache.logging.log4j.status.StatusLogger;

@Configurable(printObject=true)
@Plugin
public class ScriptCondition
implements ScriptConditional {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final Script script;
    private final Configuration configuration;

    public ScriptCondition(Script script, Configuration configuration) {
        this.script = Objects.requireNonNull(script, "script");
        this.configuration = Objects.requireNonNull(configuration, "configuration");
    }

    public List<PathWithAttributes> selectFilesToDelete(Path basePath, List<PathWithAttributes> candidates) {
        ScriptBindings bindings = ScriptManagerImpl.createBindings();
        bindings.put((Object)"basePath", (Object)basePath);
        bindings.put((Object)"pathList", candidates);
        bindings.putAll(this.configuration.getProperties());
        bindings.put((Object)"configuration", (Object)this.configuration);
        bindings.put((Object)"substitutor", (Object)this.configuration.getStrSubstitutor());
        bindings.put((Object)"statusLogger", (Object)LOGGER);
        Object object = this.configuration.getScriptManager().execute(this.script.getName(), bindings);
        return (List)object;
    }

    @PluginFactory
    public static ScriptCondition createCondition(@PluginElement(value="Script") @PluginElement(value="Script") Script script, @PluginConfiguration Configuration configuration) {
        if (script == null) {
            LOGGER.error("A Script, ScriptFile or ScriptRef element must be provided for this ScriptCondition");
            return null;
        }
        if (configuration.getScriptManager() == null) {
            LOGGER.error("Script support is not enabled");
            return null;
        }
        if (script instanceof ScriptRef) {
            if (configuration.getScriptManager().getScript(script.getName()) == null) {
                LOGGER.error("ScriptCondition: No script with name {} has been declared.", (Object)script.getName());
                return null;
            }
        } else if (!configuration.getScriptManager().addScript(script)) {
            return null;
        }
        return new ScriptCondition(script, configuration);
    }
}

