/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.OrderComparator;
import org.apache.logging.log4j.core.config.URIConfigurationFactory;
import org.apache.logging.log4j.core.config.composite.CompositeConfiguration;
import org.apache.logging.log4j.core.impl.CoreProperties;
import org.apache.logging.log4j.core.lookup.ConfigurationStrSubstitutor;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.kit.env.PropertyEnvironment;
import org.apache.logging.log4j.plugins.di.InstanceFactory;
import org.apache.logging.log4j.plugins.model.PluginNamespace;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.Strings;

public class DefaultConfigurationFactory
extends ConfigurationFactory {
    private static final String ALL_TYPES = "*";
    private static final String OVERRIDE_PARAM = "override";

    @Override
    public Configuration getConfiguration(LoggerContext loggerContext, String name, URI configLocation) {
        Configuration config;
        InstanceFactory instanceFactory = loggerContext.getInstanceFactory();
        PropertyEnvironment environment = loggerContext.getEnvironment();
        List<URIConfigurationFactory> configurationFactories = DefaultConfigurationFactory.loadConfigurationFactories(instanceFactory);
        StrSubstitutor substitutor = (StrSubstitutor)instanceFactory.getInstance(ConfigurationStrSubstitutor.class);
        if (configLocation == null) {
            CoreProperties.ConfigurationProperties properties = (CoreProperties.ConfigurationProperties)environment.getProperty(CoreProperties.ConfigurationProperties.class);
            String configLocationStr = substitutor.replace(properties.location());
            if (configLocationStr != null) {
                String[] sources = this.parseConfigLocations(configLocationStr);
                if (sources.length > 1) {
                    ArrayList<AbstractConfiguration> configs = new ArrayList<AbstractConfiguration>();
                    for (String sourceLocation : sources) {
                        Configuration config2 = this.getConfiguration(null, loggerContext, sourceLocation.trim(), configurationFactories);
                        if (config2 != null) {
                            if (config2 instanceof AbstractConfiguration) {
                                configs.add((AbstractConfiguration)config2);
                                continue;
                            }
                            LOGGER.error("Failed to created configuration at {}", (Object)sourceLocation);
                            return null;
                        }
                        LOGGER.warn("Unable to create configuration for {}, ignoring", (Object)sourceLocation);
                    }
                    if (configs.size() > 1) {
                        return new CompositeConfiguration(loggerContext, configs);
                    }
                    if (configs.size() == 1) {
                        return (Configuration)configs.get(0);
                    }
                }
                return this.getConfiguration(null, loggerContext, configLocationStr, configurationFactories);
            }
            String log4j1ConfigStr = substitutor.replace(((CoreProperties.Version1Properties)environment.getProperty(CoreProperties.Version1Properties.class)).configuration());
            if (log4j1ConfigStr != null) {
                return this.getConfiguration("1", loggerContext, log4j1ConfigStr, configurationFactories);
            }
            for (URIConfigurationFactory factory : configurationFactories) {
                String[] types = factory.getSupportedExtensions();
                if (types == null) continue;
                for (String type : types) {
                    Configuration config3;
                    if (!type.equals(ALL_TYPES) || (config3 = factory.getConfiguration(loggerContext, name, null)) == null) continue;
                    return config3;
                }
            }
        } else {
            String[] sources = this.parseConfigLocations(configLocation);
            if (sources.length > 1) {
                ArrayList<AbstractConfiguration> configs = new ArrayList<AbstractConfiguration>();
                for (String sourceLocation : sources) {
                    Configuration config4 = this.getConfiguration(null, loggerContext, sourceLocation.trim(), configurationFactories);
                    if (!(config4 instanceof AbstractConfiguration)) {
                        LOGGER.error("Failed to created configuration at {}", (Object)sourceLocation);
                        return null;
                    }
                    configs.add((AbstractConfiguration)config4);
                }
                return new CompositeConfiguration(loggerContext, configs);
            }
            String configLocationStr = configLocation.toString();
            for (URIConfigurationFactory factory : configurationFactories) {
                String[] types = factory.getSupportedExtensions();
                if (types == null) continue;
                for (String type : types) {
                    Configuration config5;
                    if (!type.equals(ALL_TYPES) && !configLocationStr.endsWith(type) || (config5 = factory.getConfiguration(loggerContext, name, configLocation)) == null) continue;
                    return config5;
                }
            }
        }
        if ((config = this.getConfiguration(loggerContext, true, (CharSequence)name, configurationFactories)) == null && (config = this.getConfiguration(loggerContext, true, null, configurationFactories)) == null && (config = this.getConfiguration(loggerContext, false, (CharSequence)name, configurationFactories)) == null) {
            config = this.getConfiguration(loggerContext, false, null, configurationFactories);
        }
        if (config != null) {
            return config;
        }
        LOGGER.warn("No Log4j 2 configuration file found. Using default configuration (logging only errors to the console), or user programmatically provided configurations. Set system property 'log4j2.debug' to show Log4j 2 internal initialization logging. See https://logging.apache.org/log4j/2.x/manual/configuration.html for instructions on how to configure Log4j 2");
        return new DefaultConfiguration(loggerContext);
    }

    private Configuration getConfiguration(String requiredVersion, LoggerContext loggerContext, String configLocation, Iterable<? extends URIConfigurationFactory> configurationFactories) {
        ConfigurationSource source = null;
        try {
            source = ConfigurationSource.fromUri(NetUtils.toURI(configLocation));
        }
        catch (Exception ex) {
            LOGGER.catching(Level.DEBUG, (Throwable)ex);
        }
        if (source != null) {
            for (URIConfigurationFactory uRIConfigurationFactory : configurationFactories) {
                String[] types;
                if (requiredVersion != null && !uRIConfigurationFactory.getVersion().equals(requiredVersion) || (types = uRIConfigurationFactory.getSupportedExtensions()) == null) continue;
                for (String type : types) {
                    Configuration config;
                    if (!type.equals(ALL_TYPES) && !configLocation.endsWith(type) || (config = uRIConfigurationFactory.getConfiguration(loggerContext, source)) == null) continue;
                    return config;
                }
            }
        }
        return null;
    }

    private Configuration getConfiguration(LoggerContext loggerContext, boolean isTest, CharSequence name, Iterable<? extends URIConfigurationFactory> configurationFactories) {
        boolean named = Strings.isNotEmpty((CharSequence)name);
        ClassLoader loader = LoaderUtil.getThreadContextClassLoader();
        for (URIConfigurationFactory uRIConfigurationFactory : configurationFactories) {
            String prefix = isTest ? uRIConfigurationFactory.getTestPrefix() : uRIConfigurationFactory.getDefaultPrefix();
            String[] types = uRIConfigurationFactory.getSupportedExtensions();
            if (types == null) continue;
            for (String suffix : types) {
                String configName;
                ConfigurationSource source;
                if (suffix.equals(ALL_TYPES) || (source = ConfigurationSource.fromResource(configName = named ? prefix + name + suffix : prefix + suffix, loader)) == null) continue;
                try {
                    return uRIConfigurationFactory.getConfiguration(loggerContext, source);
                }
                catch (LinkageError e) {
                    LOGGER.warn("Failed to create configuration from resource {} using {}.", (Object)source, (Object)uRIConfigurationFactory.getClass().getName(), (Object)e);
                }
            }
        }
        return null;
    }

    @Override
    protected String[] getSupportedTypes() {
        return null;
    }

    @Override
    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        if (source != null) {
            List<URIConfigurationFactory> configurationFactories = DefaultConfigurationFactory.loadConfigurationFactories(loggerContext.getInstanceFactory());
            String config = source.getLocation();
            for (URIConfigurationFactory factory : configurationFactories) {
                String[] types = factory.getSupportedExtensions();
                if (types == null) continue;
                for (String type : types) {
                    if (!type.equals(ALL_TYPES) && (config == null || !config.endsWith(type))) continue;
                    Configuration c = factory.getConfiguration(loggerContext, source);
                    if (c != null) {
                        LOGGER.debug("Loaded configuration from {}", (Object)source);
                        return c;
                    }
                    LOGGER.error("Cannot determine the ConfigurationFactory to use for {}", (Object)config);
                    return null;
                }
            }
        }
        LOGGER.error("Cannot process configuration, input source is null");
        return null;
    }

    private String[] parseConfigLocations(URI configLocations) {
        String[] uris = configLocations.toString().split("\\?");
        ArrayList<String> locations = new ArrayList<String>();
        if (uris.length > 1) {
            String[] pairs;
            locations.add(uris[0]);
            for (String pair : pairs = configLocations.getQuery().split("&")) {
                String key;
                int idx = pair.indexOf("=");
                String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8) : pair;
                if (!key.equalsIgnoreCase(OVERRIDE_PARAM)) continue;
                locations.add(URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8));
            }
            return locations.toArray(new String[0]);
        }
        return new String[]{uris[0]};
    }

    private String[] parseConfigLocations(String configLocations) {
        String[] uris = configLocations.split(",");
        if (uris.length > 1) {
            return uris;
        }
        try {
            return this.parseConfigLocations(new URI(configLocations));
        }
        catch (URISyntaxException ex) {
            LOGGER.warn("Error parsing URI {}", (Object)configLocations);
            return new String[]{configLocations};
        }
    }

    private static List<URIConfigurationFactory> loadConfigurationFactories(InstanceFactory instanceFactory) {
        ArrayList<URIConfigurationFactory> factories = new ArrayList<URIConfigurationFactory>();
        Optional.of((CoreProperties.ConfigurationProperties)PropertyEnvironment.getGlobal().getProperty(CoreProperties.ConfigurationProperties.class)).flatMap(props -> Optional.ofNullable(props.factory())).map(clazz -> {
            try {
                return (ConfigurationFactory)instanceFactory.getInstance(clazz);
            }
            catch (Exception ex) {
                LOGGER.error("Unable to create instance of {}", clazz, (Object)ex);
                return null;
            }
        }).ifPresent(factories::add);
        ArrayList configurationFactoryPluginClasses = new ArrayList();
        ((PluginNamespace)instanceFactory.getInstance(PLUGIN_NAMESPACE_KEY)).forEach(type -> {
            try {
                configurationFactoryPluginClasses.add(type.getPluginClass().asSubclass(URIConfigurationFactory.class));
            }
            catch (Exception ex) {
                LOGGER.warn("Unable to add class {}", (Object)type.getPluginClass(), (Object)ex);
            }
        });
        configurationFactoryPluginClasses.sort(OrderComparator.getInstance());
        configurationFactoryPluginClasses.forEach(clazz -> {
            try {
                factories.add((URIConfigurationFactory)instanceFactory.getInstance(clazz));
            }
            catch (Exception ex) {
                LOGGER.error("Unable to create instance of {}", clazz, (Object)ex);
            }
        });
        return factories;
    }
}

