/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.ConfigurationFactoryData;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.util.FileUtils;

public class RandomAccessFileManager
extends OutputStreamManager {
    static final int DEFAULT_BUFFER_SIZE = 262144;
    private static final RandomAccessFileManagerFactory FACTORY = new RandomAccessFileManagerFactory();
    private final String advertiseURI;
    private final RandomAccessFile randomAccessFile;

    protected RandomAccessFileManager(LoggerContext loggerContext, RandomAccessFile file, String fileName, OutputStream os, int bufferSize, String advertiseURI, Layout layout, boolean writeHeader) {
        super(loggerContext, os, fileName, false, layout, writeHeader, ByteBuffer.wrap(new byte[bufferSize]));
        this.randomAccessFile = file;
        this.advertiseURI = advertiseURI;
    }

    public static RandomAccessFileManager getFileManager(String fileName, boolean append, boolean immediateFlush, int bufferSize, String advertiseURI, Layout layout, Configuration configuration) {
        return RandomAccessFileManager.narrow(RandomAccessFileManager.class, RandomAccessFileManager.getManager(fileName, new FactoryData(append, immediateFlush, bufferSize, advertiseURI, layout, configuration), FACTORY));
    }

    @Override
    protected void writeToDestination(byte[] bytes, int offset, int length) {
        try {
            this.randomAccessFile.write(bytes, offset, length);
        }
        catch (IOException ex) {
            String msg = "Error writing to RandomAccessFile " + this.getName();
            throw new AppenderLoggingException(msg, ex);
        }
    }

    @Override
    public void flush() {
        this.writeLock.lock();
        try {
            this.flushBuffer(this.byteBuffer);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean closeOutputStream() {
        this.writeLock.lock();
        try {
            this.flush();
            this.randomAccessFile.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            this.logError("Unable to close RandomAccessFile", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String getFileName() {
        return this.getName();
    }

    public int getBufferSize() {
        return this.byteBuffer.capacity();
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> result = new HashMap<String, String>(super.getContentFormat());
        result.put("fileURI", this.advertiseURI);
        return result;
    }

    private static class FactoryData
    extends ConfigurationFactoryData {
        private final boolean append;
        private final boolean immediateFlush;
        private final int bufferSize;
        private final String advertiseURI;
        private final Layout layout;

        public FactoryData(boolean append, boolean immediateFlush, int bufferSize, String advertiseURI, Layout layout, Configuration configuration) {
            super(configuration);
            this.append = append;
            this.immediateFlush = immediateFlush;
            this.bufferSize = bufferSize;
            this.advertiseURI = advertiseURI;
            this.layout = layout;
        }
    }

    private static class RandomAccessFileManagerFactory
    implements ManagerFactory<RandomAccessFileManager, FactoryData> {
        private RandomAccessFileManagerFactory() {
        }

        @Override
        @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The destination file should be specified in the configuration file.")
        public RandomAccessFileManager createManager(String name, FactoryData data) {
            File file = new File(name);
            if (!data.append) {
                file.delete();
            }
            boolean writeHeader = !data.append || !file.exists();
            OutputStream os = OutputStream.nullOutputStream();
            try {
                FileUtils.makeParentDirs(file);
                RandomAccessFile raf = new RandomAccessFile(name, "rw");
                if (data.append) {
                    raf.seek(raf.length());
                } else {
                    raf.setLength(0L);
                }
                return new RandomAccessFileManager(data.getLoggerContext(), raf, name, os, data.bufferSize, data.advertiseURI, data.layout, writeHeader);
            }
            catch (Exception ex) {
                AbstractManager.LOGGER.error("RandomAccessFileManager (" + name + ") " + ex, (Throwable)ex);
                return null;
            }
        }
    }
}

