/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.async.logger;

import com.lmax.disruptor.EventTranslator;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.async.logger.AsyncLogger;
import org.apache.logging.log4j.async.logger.RingBufferLogEvent;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.time.Clock;
import org.apache.logging.log4j.core.time.NanoClock;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.apache.logging.log4j.util.StringMap;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class RingBufferLogEventTranslator
implements EventTranslator<RingBufferLogEvent> {
    private ContextDataInjector contextDataInjector;
    private AsyncLogger asyncLogger;
    String loggerName;
    protected @Nullable Marker marker;
    protected Level level;
    protected @Nullable Message message;
    protected @Nullable Throwable thrown;
    private ThreadContext.ContextStack contextStack;
    private long threadId = Thread.currentThread().getId();
    private String threadName = Thread.currentThread().getName();
    private int threadPriority = Thread.currentThread().getPriority();
    private Clock clock;
    private NanoClock nanoClock;
    protected String fqcn;
    private @Nullable StackTraceElement location;
    private boolean requiresLocation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void translateTo(RingBufferLogEvent event, long sequence) {
        try {
            StringMap contextData = event.getContextData();
            event.setValues(this.asyncLogger, this.loggerName, this.marker, this.fqcn, this.level, this.message, this.thrown, this.contextDataInjector.injectContextData(null, contextData), this.contextStack, this.threadId, this.threadName, this.threadPriority, this.requiresLocation ? StackLocatorUtil.calcLocation((String)this.fqcn) : this.location, this.clock, this.nanoClock);
        }
        finally {
            this.clear();
        }
    }

    void clear() {
        this.setBasicValues(null, null, null, null, null, null, null, null, null, null, null, null, false);
    }

    public void setBasicValues(AsyncLogger asyncLogger, String loggerName, @Nullable Marker marker, String fqcn, Level level, @Nullable Message message, @Nullable Throwable throwable, ThreadContext.ContextStack contextStack, @Nullable StackTraceElement location, Clock clock, NanoClock nanoClock, ContextDataInjector contextDataInjector, boolean includeLocation) {
        this.asyncLogger = asyncLogger;
        this.loggerName = loggerName;
        this.marker = marker;
        this.fqcn = fqcn;
        this.level = level;
        this.message = message;
        this.thrown = throwable;
        this.contextStack = contextStack;
        this.location = location;
        this.clock = clock;
        this.nanoClock = nanoClock;
        this.contextDataInjector = contextDataInjector;
        this.requiresLocation = location == null && includeLocation;
    }

    public void updateThreadValues() {
        Thread currentThread = Thread.currentThread();
        this.threadId = currentThread.getId();
        this.threadName = currentThread.getName();
        this.threadPriority = currentThread.getPriority();
    }
}

