/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.http.util;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.kyuubi.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;

public final class HttpAuthUtils$
implements Logging {
    public static HttpAuthUtils$ MODULE$;
    private final String WWW_AUTHENTICATE_HEADER;
    private final String AUTHORIZATION_HEADER;
    private final String NEGOTIATE;
    private final String BASIC;
    private final String DIGEST;
    private final String COOKIE_ATTR_SEPARATOR;
    private final String COOKIE_CLIENT_USER_NAME;
    private final String COOKIE_CLIENT_RAND_NUMBER;
    private final String COOKIE_KEY_VALUE_SEPARATOR;
    private final HashSet<String> COOKIE_ATTRIBUTES;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new HttpAuthUtils$();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public String WWW_AUTHENTICATE_HEADER() {
        return this.WWW_AUTHENTICATE_HEADER;
    }

    public String AUTHORIZATION_HEADER() {
        return this.AUTHORIZATION_HEADER;
    }

    public String NEGOTIATE() {
        return this.NEGOTIATE;
    }

    public String BASIC() {
        return this.BASIC;
    }

    public String DIGEST() {
        return this.DIGEST;
    }

    public String basicAuthorizationHeader(String userId, String password) {
        return new java.lang.StringBuilder(6).append("BASIC ").append(new String(Base64.getEncoder().encode(new java.lang.StringBuilder(1).append(userId).append(":").append(password).toString().getBytes()), StandardCharsets.UTF_8)).toString();
    }

    public String basicAuthorizationHeader$default$2() {
        return "none";
    }

    private String COOKIE_ATTR_SEPARATOR() {
        return this.COOKIE_ATTR_SEPARATOR;
    }

    private String COOKIE_CLIENT_USER_NAME() {
        return this.COOKIE_CLIENT_USER_NAME;
    }

    private String COOKIE_CLIENT_RAND_NUMBER() {
        return this.COOKIE_CLIENT_RAND_NUMBER;
    }

    private String COOKIE_KEY_VALUE_SEPARATOR() {
        return this.COOKIE_KEY_VALUE_SEPARATOR;
    }

    private HashSet<String> COOKIE_ATTRIBUTES() {
        return this.COOKIE_ATTRIBUTES;
    }

    public String createCookieToken(String clientUserName) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.COOKIE_CLIENT_USER_NAME()).append(this.COOKIE_KEY_VALUE_SEPARATOR()).append(clientUserName).append(this.COOKIE_ATTR_SEPARATOR()).append(this.COOKIE_CLIENT_RAND_NUMBER()).append(this.COOKIE_KEY_VALUE_SEPARATOR()).append(new SecureRandom().nextLong());
        return sb.toString();
    }

    public String getUserNameFromCookieToken(String tokenStr) {
        Map<String, String> map = this.splitCookieToken(tokenStr);
        Set<String> set = map.keySet();
        HashSet<String> hashSet = this.COOKIE_ATTRIBUTES();
        if (set == null ? hashSet != null : !((Object)set).equals(hashSet)) {
            this.error((Function0<Object>)(Function0 & java.io.Serializable & Serializable)() -> new java.lang.StringBuilder(38).append("Invalid token with missing attributes ").append(tokenStr).toString());
            return null;
        }
        return map.get(this.COOKIE_CLIENT_USER_NAME());
    }

    private Map<String, String> splitCookieToken(String tokenStr) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(tokenStr, this.COOKIE_ATTR_SEPARATOR());
        while (st.hasMoreTokens()) {
            String part = st.nextToken();
            int separator = part.indexOf(this.COOKIE_KEY_VALUE_SEPARATOR());
            if (separator == -1) {
                this.error((Function0<Object>)(Function0 & java.io.Serializable & Serializable)() -> new java.lang.StringBuilder(21).append("Invalid token string ").append(tokenStr).toString());
                return null;
            }
            String key = part.substring(0, separator);
            String value = part.substring(separator + 1);
            map.put(key, value);
        }
        return map;
    }

    private HttpAuthUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
        this.AUTHORIZATION_HEADER = "Authorization";
        this.NEGOTIATE = "Negotiate";
        this.BASIC = "Basic";
        this.DIGEST = "Digest";
        this.COOKIE_ATTR_SEPARATOR = "&";
        this.COOKIE_CLIENT_USER_NAME = "cu";
        this.COOKIE_CLIENT_RAND_NUMBER = "rn";
        this.COOKIE_KEY_VALUE_SEPARATOR = "=";
        this.COOKIE_ATTRIBUTES = new HashSet<Object>(Arrays.asList((Object[])new String[]{this.COOKIE_CLIENT_USER_NAME(), this.COOKIE_CLIENT_RAND_NUMBER()}));
    }
}

