/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.service;

import java.io.Serializable;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.util.Locale;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLServerSocket;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.service.TFrontendService;
import org.apache.kyuubi.shaded.thrift.TProcessorFactory;
import org.apache.kyuubi.shaded.thrift.protocol.TBinaryProtocol;
import org.apache.kyuubi.shaded.thrift.server.TServer;
import org.apache.kyuubi.shaded.thrift.server.TThreadPoolServer;
import org.apache.kyuubi.shaded.thrift.transport.TSSLTransportFactory;
import org.apache.kyuubi.shaded.thrift.transport.TServerSocket;
import org.apache.kyuubi.shaded.thrift.transport.TTransportFactory;
import org.apache.kyuubi.util.NamedThreadFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mb!\u0002\t\u0012\u0003\u0003Q\u0002\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u000b)\u0003A\u0011A&\t\u00119\u0003\u0001R1A\u0005V=C\u0001\u0002\u0016\u0001\t\u0006\u0004%)&\u0016\u0005\b3\u0002\u0001\r\u0011\"\u0005[\u0011\u001d\u0011\u0007\u00011A\u0005\u0012\rDa!\u001b\u0001!B\u0013Y\u0006\"\u00036\u0001\u0001\u0004\u0005\r\u0011\"\u0003V\u0011%Y\u0007\u00011AA\u0002\u0013%A\u000eC\u0005o\u0001\u0001\u0007\t\u0011)Q\u0005-\"Aq\u000e\u0001EC\u0002\u0013ES\u000bC\u0003q\u0001\u0011\u0005\u0013\u000fC\u0003{\u0001\u0011%1\u0010C\u0004\u00026\u0001!\t%a\u000e\t\u000f\u0005e\u0002\u0001\"\u0015\u00028\t1BKQ5oCJLhI]8oi\u0016tGmU3sm&\u001cWM\u0003\u0002\u0013'\u000591/\u001a:wS\u000e,'B\u0001\u000b\u0016\u0003\u0019Y\u00170^;cS*\u0011acF\u0001\u0007CB\f7\r[3\u000b\u0003a\t1a\u001c:h\u0007\u0001\u0019R\u0001A\u000e aa\u0002\"\u0001H\u000f\u000e\u0003EI!AH\t\u0003!Q3%o\u001c8uK:$7+\u001a:wS\u000e,\u0007C\u0001\u0011.\u001d\t\t3&D\u0001#\u0015\t\u0019C%\u0001\u0004uQJLg\r\u001e\u0006\u0003K\u0019\n1A\u001d9d\u0015\t\u0011rE\u0003\u0002)S\u0005!\u0001.\u001b<f\u0015\tQ3#\u0001\u0004tQ\u0006$W\rZ\u0005\u0003Y\t\n1\u0002V\"M\u0013N+'O^5dK&\u0011af\f\u0002\u0006\u0013\u001a\f7-\u001a\u0006\u0003Y\t\u0002\"!\r\u001c\u000e\u0003IR!a\r\u001b\u0002\t1\fgn\u001a\u0006\u0002k\u0005!!.\u0019<b\u0013\t9$G\u0001\u0005Sk:t\u0017M\u00197f!\tI$(D\u0001\u0014\u0013\tY4CA\u0004M_\u001e<\u0017N\\4\u0002\t9\fW.\u001a\t\u0003}\u001ds!aP#\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\tK\u0012A\u0002\u001fs_>$hHC\u0001E\u0003\u0015\u00198-\u00197b\u0013\t15)\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0011&\u0013aa\u0015;sS:<'B\u0001$D\u0003\u0019a\u0014N\\5u}Q\u0011A*\u0014\t\u00039\u0001AQ\u0001\u0010\u0002A\u0002u\n!b]3sm\u0016\u0014\bj\\:u+\u0005\u0001\u0006cA)S{5\t1)\u0003\u0002T\u0007\n1q\n\u001d;j_:\fq\u0001]8si:+X.F\u0001W!\t\tv+\u0003\u0002Y\u0007\n\u0019\u0011J\u001c;\u0002\rM,'O^3s+\u0005Y\u0006cA)S9B\u0011Q\fY\u0007\u0002=*\u0011\u0011l\u0018\u0006\u0003G%J!!\u00190\u0003\u000fQ\u001bVM\u001d<fe\u0006Q1/\u001a:wKJ|F%Z9\u0015\u0005\u0011<\u0007CA)f\u0013\t17I\u0001\u0003V]&$\bb\u00025\u0007\u0003\u0003\u0005\raW\u0001\u0004q\u0012\n\u0014aB:feZ,'\u000fI\u0001\f?\u0006\u001cG/^1m!>\u0014H/A\b`C\u000e$X/\u00197Q_J$x\fJ3r)\t!W\u000eC\u0004i\u0013\u0005\u0005\t\u0019\u0001,\u0002\u0019}\u000b7\r^;bYB{'\u000f\u001e\u0011\u0002\u0015\u0005\u001cG/^1m!>\u0014H/\u0001\u0006j]&$\u0018.\u00197ju\u0016$\"\u0001\u001a:\t\u000bMd\u0001\u0019\u0001;\u0002\t\r|gN\u001a\t\u0003kbl\u0011A\u001e\u0006\u0003oN\taaY8oM&<\u0017BA=w\u0005)Y\u00150^;cS\u000e{gNZ\u0001\u0013O\u0016$8+\u001a:wKJ\u001c6\u000bT*pG.,G\u000fF\u0007}\u0003\u000b\tI!!\u0004\u0002\u0012\u0005U\u0011q\u0004\t\u0004{\u0006\u0005Q\"\u0001@\u000b\u0005}|\u0016!\u0003;sC:\u001c\bo\u001c:u\u0013\r\t\u0019A \u0002\u000e)N+'O^3s'>\u001c7.\u001a;\t\r\u0005\u001dQ\u00021\u0001>\u00031YW-_*u_J,\u0007+\u0019;i\u0011\u0019\tY!\u0004a\u0001{\u0005\u00012.Z=Ti>\u0014X\rU1tg^|'\u000f\u001a\u0005\u0007\u0003\u001fi\u0001\u0019\u0001)\u0002\u0019-,\u0017p\u0015;pe\u0016$\u0016\u0010]3\t\r\u0005MQ\u00021\u0001Q\u0003EYW-_*u_J,\u0017\t\\4pe&$\b.\u001c\u0005\b\u0003/i\u0001\u0019AA\r\u0003Y!\u0017n]1mY><X\rZ*tYB\u0013x\u000e^8d_2\u001c\b\u0003\u0002 \u0002\u001cuJ1!!\bJ\u0005\r\u0019V\r\u001e\u0005\b\u0003Ci\u0001\u0019AA\u0012\u0003MIgn\u00197vI\u0016\u001c\u0015\u000e\u001d5feN+\u0018\u000e^3t!\u0015\t)#a\f>\u001d\u0011\t9#a\u000b\u000f\u0007\u0001\u000bI#C\u0001E\u0013\r\ticQ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t$a\r\u0003\u0007M+\u0017OC\u0002\u0002.\r\u000b1A];o)\u0005!\u0017AC:u_B\u001cVM\u001d<fe\u0002")
public abstract class TBinaryFrontendService
extends TFrontendService {
    private Option<String> serverHost;
    private int portNum;
    private int actualPort;
    private final String name;
    private Option<TServer> server;
    private int _actualPort;
    private volatile byte bitmap$0;

    private Option<String> serverHost$lzycompute() {
        TBinaryFrontendService tBinaryFrontendService = this;
        synchronized (tBinaryFrontendService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.serverHost = this.conf().get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_BINARY_BIND_HOST());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.serverHost;
    }

    @Override
    public final Option<String> serverHost() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.serverHost$lzycompute();
        }
        return this.serverHost;
    }

    private int portNum$lzycompute() {
        TBinaryFrontendService tBinaryFrontendService = this;
        synchronized (tBinaryFrontendService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.portNum = BoxesRunTime.unboxToInt(this.conf().get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_BINARY_BIND_PORT()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.portNum;
    }

    @Override
    public final int portNum() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.portNum$lzycompute();
        }
        return this.portNum;
    }

    public Option<TServer> server() {
        return this.server;
    }

    public void server_$eq(Option<TServer> x$1) {
        this.server = x$1;
    }

    private int _actualPort() {
        return this._actualPort;
    }

    private void _actualPort_$eq(int x$1) {
        this._actualPort = x$1;
    }

    private int actualPort$lzycompute() {
        TBinaryFrontendService tBinaryFrontendService = this;
        synchronized (tBinaryFrontendService) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.actualPort = this._actualPort();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.actualPort;
    }

    @Override
    public int actualPort() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.actualPort$lzycompute();
        }
        return this.actualPort;
    }

    @Override
    public synchronized void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        try {
            TServerSocket tServerSocket;
            int minThreads = BoxesRunTime.unboxToInt(conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_MIN_WORKER_THREADS()));
            int maxThreads = BoxesRunTime.unboxToInt(conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_MAX_WORKER_THREADS()));
            long keepAliveTime = BoxesRunTime.unboxToLong(conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_WORKER_KEEPALIVE_TIME()));
            ThreadPoolExecutor executor = new ThreadPoolExecutor(minThreads, maxThreads, keepAliveTime, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new NamedThreadFactory(new StringBuilder(12).append(this.name).append("Handler-Pool").toString(), false));
            TTransportFactory transFactory = this.authFactory().getTTransportFactory();
            TProcessorFactory tProcFactory = this.authFactory().getTProcessorFactory(this);
            if (this.isServer() && BoxesRunTime.unboxToBoolean(conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_BINARY_SSL_ENABLED()))) {
                Option keyStorePath = (Option)((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_SSL_KEYSTORE_PATH()));
                Option keyStorePassword = (Option)((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_SSL_KEYSTORE_PASSWORD()));
                Option keyStoreType = (Option)((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_SSL_KEYSTORE_TYPE()));
                Option keyStoreAlgorithm = (Option)((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_SSL_KEYSTORE_ALGORITHM()));
                Set<String> disallowedSslProtocols = conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_BINARY_SSL_DISALLOWED_PROTOCOLS());
                Seq<String> includeCipherSuites = conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_BINARY_SSL_INCLUDE_CIPHER_SUITES());
                if (keyStorePath.isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(34).append(KyuubiConf$.MODULE$.FRONTEND_SSL_KEYSTORE_PATH().key()).append(" not configured for SSL connection").toString());
                }
                if (keyStorePassword.isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(34).append(KyuubiConf$.MODULE$.FRONTEND_SSL_KEYSTORE_PASSWORD().key()).append(" not configured for SSL connection").toString());
                }
                tServerSocket = this.getServerSSLSocket((String)keyStorePath.get(), (String)keyStorePassword.get(), keyStoreType, keyStoreAlgorithm, disallowedSslProtocols, includeCipherSuites);
            } else {
                tServerSocket = new TServerSocket(new ServerSocket(this.portNum(), -1, this.serverAddr()));
            }
            TServerSocket tServerSocket2 = tServerSocket;
            this._actualPort_$eq(tServerSocket2.getServerSocket().getLocalPort());
            int maxMessageSize = BoxesRunTime.unboxToInt(conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_MAX_MESSAGE_SIZE()));
            TThreadPoolServer.Args args = ((TThreadPoolServer.Args)((TServer.AbstractServerArgs)((TServer.AbstractServerArgs)((TServer.AbstractServerArgs)new TThreadPoolServer.Args(tServerSocket2).processorFactory(tProcFactory)).transportFactory(transFactory)).protocolFactory(new TBinaryProtocol.Factory())).inputProtocolFactory(new TBinaryProtocol.Factory(true, true, maxMessageSize, maxMessageSize))).executorService(executor);
            this.server_$eq(new Some<TServer>(new TThreadPoolServer(args)));
            this.server().foreach((Function1<TServer, Object> & Serializable & scala.Serializable)x$1 -> {
                x$1.setServerEventHandler(new TFrontendService.FeTServerEventHandler(this));
                return BoxedUnit.UNIT;
            });
            this.info((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Initializing ").append($this.name).append(" on ").append(this.serverAddr().getHostName()).append(":").append(this._actualPort()).append(" with").append(" [").append(minThreads).append(", ").append(maxThreads).append("] worker threads").toString());
        }
        catch (Throwable e) {
            this.error((Function0<Object>)(Function0<Throwable> & Serializable & scala.Serializable)() -> e);
            throw new KyuubiException(new StringBuilder(43).append("Failed to initialize frontend service on ").append(this.serverAddr()).append(":").append(this.portNum()).append(".").toString(), e);
        }
        super.initialize(conf);
    }

    private TServerSocket getServerSSLSocket(String keyStorePath, String keyStorePassword, Option<String> keyStoreType, Option<String> keyStoreAlgorithm, Set<String> disallowedSslProtocols, Seq<String> includeCipherSuites) {
        TServerSocket tServerSocket;
        block0: {
            TSSLTransportFactory.TSSLTransportParameters params = includeCipherSuites.nonEmpty() ? new TSSLTransportFactory.TSSLTransportParameters("TLS", (String[])includeCipherSuites.toArray(ClassTag$.MODULE$.apply(String.class))) : new TSSLTransportFactory.TSSLTransportParameters();
            params.setKeyStore(keyStorePath, keyStorePassword, (String)keyStoreAlgorithm.getOrElse((Function0<String> & Serializable & scala.Serializable)() -> KeyManagerFactory.getDefaultAlgorithm()), (String)keyStoreType.getOrElse((Function0<String> & Serializable & scala.Serializable)() -> KeyStore.getDefaultType()));
            tServerSocket = TSSLTransportFactory.getServerSocket(this.portNum(), 0, this.serverAddr(), params);
            ServerSocket serverSocket = tServerSocket.getServerSocket();
            if (!(serverSocket instanceof SSLServerSocket)) break block0;
            SSLServerSocket sSLServerSocket = (SSLServerSocket)serverSocket;
            Set lowerDisallowedSslProtocols = disallowedSslProtocols.map((Function1<String, String> & Serializable & scala.Serializable)x$2 -> x$2.toLowerCase(Locale.ROOT), Set$.MODULE$.canBuildFrom());
            String[] enabledProtocols = (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])sSLServerSocket.getEnabledProtocols())).flatMap((Function1<String, Iterable> & Serializable & scala.Serializable)protocol -> {
                if (lowerDisallowedSslProtocols.contains(protocol.toLowerCase(Locale.ROOT))) {
                    this.debug((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Disabling SSL Protocol: ").append((String)protocol).toString());
                    return Option$.MODULE$.option2Iterable(None$.MODULE$);
                }
                return Option$.MODULE$.option2Iterable(new Some<String>((String)protocol));
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            sSLServerSocket.setEnabledProtocols(enabledProtocols);
            this.info((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(37).append("SSL Server Socket enabled protocols: ").append(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])enabledProtocols)).mkString(",")).toString());
        }
        return tServerSocket;
    }

    @Override
    public void run() {
        try {
            if (this.isServer()) {
                this.info((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Starting and exposing JDBC connection at: jdbc:hive2://").append(this.connectionUrl()).append("/").toString());
            }
            this.server().foreach((Function1<TServer, Object> & Serializable & scala.Serializable)x$3 -> {
                x$3.serve();
                return BoxedUnit.UNIT;
            });
        }
        catch (InterruptedException interruptedException) {
            this.error((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(15).append(this.getName()).append(" is interrupted").toString());
        }
        catch (Throwable t) {
            this.error((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Error starting ").append(this.getName()).toString(), t);
            System.exit(-1);
        }
    }

    @Override
    public void stopServer() {
        this.server().foreach((Function1<TServer, Object> & Serializable & scala.Serializable)x$4 -> {
            x$4.stop();
            return BoxedUnit.UNIT;
        });
        this.server_$eq(None$.MODULE$);
    }

    public TBinaryFrontendService(String name) {
        this.name = name;
        super(name);
        this.server = None$.MODULE$;
    }
}

