/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.auth;

import java.net.Socket;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import org.apache.kyuubi.shaded.thrift.TConfiguration;
import org.apache.kyuubi.shaded.thrift.transport.TSSLTransportFactory;
import org.apache.kyuubi.shaded.thrift.transport.TSocket;
import org.apache.kyuubi.shaded.thrift.transport.TTransport;
import org.apache.kyuubi.shaded.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftUtils.class);

    public static <T extends TTransport> T configureThriftMaxMessageSize(T transport, int maxMessageSize) {
        if (maxMessageSize > 0) {
            if (transport.getConfiguration() == null) {
                LOG.warn("TTransport {} is returning a null Configuration, Thrift max message size is not getting configured", (Object)transport.getClass().getName());
                return transport;
            }
            transport.getConfiguration().setMaxMessageSize(maxMessageSize);
        }
        return transport;
    }

    public static TTransport getSocketTransport(String host, int port, int connectTimeout, int socketTimeout, int maxMessageSize) throws TTransportException {
        TConfiguration.Builder tConfBuilder = TConfiguration.custom();
        if (maxMessageSize > 0) {
            tConfBuilder.setMaxMessageSize(maxMessageSize);
        }
        TConfiguration tConf = tConfBuilder.build();
        return new TSocket(tConf, host, port, socketTimeout, connectTimeout);
    }

    public static TTransport getSSLSocket(String host, int port, int connectTimeout, int socketTimeout, int maxMessageSize) throws TTransportException {
        TSocket tSSLSocket = TSSLTransportFactory.getClientSocket((String)host, (int)port, (int)socketTimeout);
        tSSLSocket.setConnectTimeout(connectTimeout);
        return ThriftUtils.getSSLSocketWithHttps(tSSLSocket, maxMessageSize);
    }

    public static TTransport getSSLSocket(String host, int port, int connectTimeout, int socketTimeout, String trustStorePath, String trustStorePassWord, int maxMessageSize) throws TTransportException {
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
        params.setTrustStore(trustStorePath, trustStorePassWord);
        params.requireClientAuth(true);
        TSocket tSSLSocket = TSSLTransportFactory.getClientSocket((String)host, (int)port, (int)socketTimeout, (TSSLTransportFactory.TSSLTransportParameters)params);
        tSSLSocket.setConnectTimeout(connectTimeout);
        return ThriftUtils.getSSLSocketWithHttps(tSSLSocket, maxMessageSize);
    }

    private static TSocket getSSLSocketWithHttps(TSocket tSSLSocket, int maxMessageSize) throws TTransportException {
        SSLSocket sslSocket = (SSLSocket)tSSLSocket.getSocket();
        SSLParameters sslParams = sslSocket.getSSLParameters();
        sslParams.setEndpointIdentificationAlgorithm("HTTPS");
        sslSocket.setSSLParameters(sslParams);
        TSocket tSocket = new TSocket((Socket)sslSocket);
        return ThriftUtils.configureThriftMaxMessageSize(tSocket, maxMessageSize);
    }
}

