/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.serialization;

import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class BooleanDeserializer
implements Deserializer<Boolean> {
    private static final byte TRUE = 1;
    private static final byte FALSE = 0;

    @Override
    public Boolean deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length != 1) {
            throw new SerializationException("Size of data received by BooleanDeserializer is not 1");
        }
        if (data[0] == 1) {
            return true;
        }
        if (data[0] == 0) {
            return false;
        }
        throw new SerializationException("Unexpected byte received by BooleanDeserializer: " + data[0]);
    }
}

