/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.net.impl;

import java.io.IOException;
import java.util.List;
import org.apache.kyuubi.shade.io.netty.channel.Channel;
import org.apache.kyuubi.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.kyuubi.shade.io.netty.handler.codec.MessageToMessageDecoder;
import org.apache.kyuubi.shade.io.netty.handler.codec.haproxy.HAProxyMessage;
import org.apache.kyuubi.shade.io.netty.handler.codec.haproxy.HAProxyProxiedProtocol;
import org.apache.kyuubi.shade.io.netty.handler.timeout.IdleState;
import org.apache.kyuubi.shade.io.netty.handler.timeout.IdleStateEvent;
import org.apache.kyuubi.shade.io.netty.util.concurrent.Promise;
import org.apache.kyuubi.shade.io.vertx.core.impl.logging.Logger;
import org.apache.kyuubi.shade.io.vertx.core.impl.logging.LoggerFactory;
import org.apache.kyuubi.shade.io.vertx.core.net.SocketAddress;
import org.apache.kyuubi.shade.io.vertx.core.net.impl.ConnectionBase;

public class HAProxyMessageCompletionHandler
extends MessageToMessageDecoder<HAProxyMessage> {
    public static final IOException UNSUPPORTED_PROTOCOL_EXCEPTION = new IOException("Unsupported HA PROXY transport protocol");
    private static final Logger log = LoggerFactory.getLogger(HAProxyMessageCompletionHandler.class);
    private static final boolean proxyProtocolCodecFound;
    private final Promise<Channel> promise;

    public static boolean canUseProxyProtocol(boolean requested) {
        if (requested && !proxyProtocolCodecFound) {
            log.warn("Proxy protocol support could not be enabled. Make sure that netty-codec-haproxy is included in your classpath");
        }
        return proxyProtocolCodecFound && requested;
    }

    public HAProxyMessageCompletionHandler(Promise<Channel> promise) {
        this.promise = promise;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, HAProxyMessage msg, List<Object> out) {
        HAProxyProxiedProtocol protocol = msg.proxiedProtocol();
        if (protocol.transportProtocol().equals((Object)HAProxyProxiedProtocol.TransportProtocol.DGRAM)) {
            ctx.close();
            this.promise.tryFailure(UNSUPPORTED_PROTOCOL_EXCEPTION);
        } else {
            if (!protocol.equals((Object)HAProxyProxiedProtocol.UNKNOWN)) {
                if (msg.sourceAddress() != null) {
                    ctx.channel().attr(ConnectionBase.REMOTE_ADDRESS_OVERRIDE).set(this.createAddress(protocol, msg.sourceAddress(), msg.sourcePort()));
                }
                if (msg.destinationAddress() != null) {
                    ctx.channel().attr(ConnectionBase.LOCAL_ADDRESS_OVERRIDE).set(this.createAddress(protocol, msg.destinationAddress(), msg.destinationPort()));
                }
            }
            ctx.pipeline().remove(this);
            this.promise.setSuccess(ctx.channel());
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.promise.tryFailure(cause);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.ALL_IDLE) {
            ctx.close();
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }

    private SocketAddress createAddress(HAProxyProxiedProtocol protocol, String sourceAddress, int port) {
        switch (protocol) {
            case TCP4: 
            case TCP6: {
                return SocketAddress.inetSocketAddress(port, sourceAddress);
            }
            case UNIX_STREAM: {
                return SocketAddress.domainSocketAddress(sourceAddress);
            }
        }
        throw new IllegalStateException("Should never happen");
    }

    static {
        boolean proxyProtocolCodecCheck = true;
        try {
            Class.forName("org.apache.kyuubi.shade.io.netty.handler.codec.haproxy.HAProxyMessageDecoder");
        }
        catch (Throwable ex) {
            proxyProtocolCodecCheck = false;
        }
        proxyProtocolCodecFound = proxyProtocolCodecCheck;
    }
}

