/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.file.impl;

import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.Objects;
import org.apache.kyuubi.shade.io.vertx.core.AsyncResult;
import org.apache.kyuubi.shade.io.vertx.core.Future;
import org.apache.kyuubi.shade.io.vertx.core.Handler;
import org.apache.kyuubi.shade.io.vertx.core.file.AsyncFileLock;
import org.apache.kyuubi.shade.io.vertx.core.file.FileSystemException;
import org.apache.kyuubi.shade.io.vertx.core.impl.VertxInternal;

public class AsyncFileLockImpl
implements AsyncFileLock {
    private final VertxInternal vertx;
    private final FileLock fileLock;

    public AsyncFileLockImpl(VertxInternal vertx, FileLock fileLock) {
        this.vertx = Objects.requireNonNull(vertx, "vertx is null");
        this.fileLock = Objects.requireNonNull(fileLock, "fileLock is null");
    }

    @Override
    public long position() {
        return this.fileLock.position();
    }

    @Override
    public long size() {
        return this.fileLock.size();
    }

    @Override
    public boolean isShared() {
        return this.fileLock.isShared();
    }

    @Override
    public boolean overlaps(long position, long size) {
        return this.fileLock.overlaps(position, size);
    }

    @Override
    public boolean isValidBlocking() {
        return this.fileLock.isValid();
    }

    @Override
    public Future<Boolean> isValid() {
        return this.vertx.getOrCreateContext().executeBlockingInternal(prom -> prom.complete(this.isValidBlocking()));
    }

    @Override
    public void isValid(Handler<AsyncResult<Boolean>> handler) {
        Future<Boolean> future = this.isValid();
        if (handler != null) {
            future.onComplete(handler);
        }
    }

    @Override
    public void releaseBlocking() {
        try {
            this.fileLock.release();
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
    }

    @Override
    public Future<Void> release() {
        return this.vertx.getOrCreateContext().executeBlockingInternal(prom -> {
            try {
                this.fileLock.release();
                prom.complete();
            }
            catch (IOException e) {
                prom.fail(new FileSystemException(e));
            }
        });
    }

    @Override
    public void release(Handler<AsyncResult<Void>> handler) {
        Future<Void> future = this.release();
        if (handler != null) {
            future.onComplete(handler);
        }
    }
}

