/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.common.WorkerUtils;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.task.WorkerStatusTracker;
import org.apache.kafka.trogdor.workload.ConnectionStressSpec;
import org.apache.kafka.trogdor.workload.Throttle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionStressWorker
implements TaskWorker {
    private static final Logger log = LoggerFactory.getLogger(ConnectionStressWorker.class);
    private static final Time TIME = Time.SYSTEM;
    private static final int THROTTLE_PERIOD_MS = 100;
    private static final int REPORT_INTERVAL_MS = 5000;
    private final String id;
    private final ConnectionStressSpec spec;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private KafkaFutureImpl<String> doneFuture;
    private WorkerStatusTracker status;
    private long totalConnections;
    private long totalFailedConnections;
    private long startTimeMs;
    private Future<?> statusUpdaterFuture;
    private ExecutorService workerExecutor;
    private ScheduledExecutorService statusUpdaterExecutor;

    public ConnectionStressWorker(String id, ConnectionStressSpec spec) {
        this.id = id;
        this.spec = spec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Platform platform, WorkerStatusTracker status, KafkaFutureImpl<String> doneFuture) throws Exception {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("ConnectionStressWorker is already running.");
        }
        log.info("{}: Activating ConnectionStressWorker with {}", (Object)this.id, (Object)this.spec);
        this.doneFuture = doneFuture;
        this.status = status;
        ConnectionStressWorker connectionStressWorker = this;
        synchronized (connectionStressWorker) {
            this.totalConnections = 0L;
            this.totalFailedConnections = 0L;
            this.startTimeMs = TIME.milliseconds();
        }
        this.statusUpdaterExecutor = Executors.newScheduledThreadPool(1, ThreadUtils.createThreadFactory((String)"StatusUpdaterWorkerThread%d", (boolean)false));
        this.statusUpdaterFuture = this.statusUpdaterExecutor.scheduleAtFixedRate(new StatusUpdater(), 0L, 5000L, TimeUnit.MILLISECONDS);
        this.workerExecutor = Executors.newFixedThreadPool(this.spec.numThreads(), ThreadUtils.createThreadFactory((String)"ConnectionStressWorkerThread%d", (boolean)false));
        for (int i = 0; i < this.spec.numThreads(); ++i) {
            this.workerExecutor.submit(new ConnectLoop());
        }
    }

    @Override
    public void stop(Platform platform) throws Exception {
        if (!this.running.compareAndSet(true, false)) {
            throw new IllegalStateException("ConnectionStressWorker is not running.");
        }
        log.info("{}: Deactivating ConnectionStressWorker.", (Object)this.id);
        this.statusUpdaterFuture.cancel(false);
        this.statusUpdaterExecutor.shutdown();
        this.statusUpdaterExecutor.awaitTermination(1L, TimeUnit.DAYS);
        this.statusUpdaterExecutor = null;
        new StatusUpdater().run();
        this.doneFuture.complete((Object)"");
        this.workerExecutor.shutdownNow();
        this.workerExecutor.awaitTermination(1L, TimeUnit.DAYS);
        this.workerExecutor = null;
        this.status = null;
    }

    public static class StatusData {
        private final long totalConnections;
        private final long totalFailedConnections;
        private final double connectsPerSec;

        @JsonCreator
        StatusData(@JsonProperty(value="totalConnections") long totalConnections, @JsonProperty(value="totalFailedConnections") long totalFailedConnections, @JsonProperty(value="connectsPerSec") double connectsPerSec) {
            this.totalConnections = totalConnections;
            this.totalFailedConnections = totalFailedConnections;
            this.connectsPerSec = connectsPerSec;
        }

        @JsonProperty
        public long totalConnections() {
            return this.totalConnections;
        }

        @JsonProperty
        public long totalFailedConnections() {
            return this.totalFailedConnections;
        }

        @JsonProperty
        public double connectsPerSec() {
            return this.connectsPerSec;
        }
    }

    private class StatusUpdater
    implements Runnable {
        private StatusUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                JsonNode node;
                long lastTimeMs = Time.SYSTEM.milliseconds();
                ConnectionStressWorker connectionStressWorker = ConnectionStressWorker.this;
                synchronized (connectionStressWorker) {
                    node = JsonUtil.JSON_SERDE.valueToTree((Object)new StatusData(ConnectionStressWorker.this.totalConnections, ConnectionStressWorker.this.totalFailedConnections, (double)ConnectionStressWorker.this.totalConnections * 1000.0 / (double)(lastTimeMs - ConnectionStressWorker.this.startTimeMs)));
                }
                ConnectionStressWorker.this.status.update(node);
            }
            catch (Exception e) {
                WorkerUtils.abort(log, "StatusUpdater", e, (KafkaFutureImpl<String>)ConnectionStressWorker.this.doneFuture);
            }
        }
    }

    public class ConnectLoop
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Stressor stressor = Stressor.fromSpec(ConnectionStressWorker.this.spec);
            int rate = WorkerUtils.perSecToPerPeriod((float)ConnectionStressWorker.this.spec.targetConnectionsPerSec() / (float)ConnectionStressWorker.this.spec.numThreads(), 100L);
            ConnectStressThrottle throttle = new ConnectStressThrottle(rate);
            try {
                while (!ConnectionStressWorker.this.doneFuture.isDone()) {
                    throttle.increment();
                    boolean success = stressor.tryConnect();
                    ConnectionStressWorker connectionStressWorker = ConnectionStressWorker.this;
                    synchronized (connectionStressWorker) {
                        ConnectionStressWorker.this.totalConnections++;
                        if (!success) {
                            ConnectionStressWorker.this.totalFailedConnections++;
                        }
                    }
                }
                return;
            }
            catch (Exception e) {
                WorkerUtils.abort(log, "ConnectLoop", e, (KafkaFutureImpl<String>)ConnectionStressWorker.this.doneFuture);
                return;
            }
            finally {
                Utils.closeQuietly((AutoCloseable)stressor, (String)"stressor");
            }
        }
    }

    static class FetchMetadataStressor
    implements Stressor {
        private final Properties props = new Properties();

        FetchMetadataStressor(ConnectionStressSpec spec) {
            this.props.put("bootstrap.servers", spec.bootstrapServers());
            WorkerUtils.addConfigsToProperties(this.props, spec.commonClientConf(), spec.commonClientConf());
        }

        @Override
        public boolean tryConnect() {
            try (Admin client = Admin.create((Properties)this.props);){
                client.describeCluster().nodes().get();
            }
            catch (InterruptedException | ExecutionException e) {
                return false;
            }
            return true;
        }

        @Override
        public void close() throws Exception {
        }
    }

    static class ConnectStressor
    implements Stressor {
        private final AdminClientConfig conf;
        private final ManualMetadataUpdater updater;
        private final LogContext logContext = new LogContext();

        ConnectStressor(ConnectionStressSpec spec) {
            Properties props = new Properties();
            props.put("bootstrap.servers", spec.bootstrapServers());
            WorkerUtils.addConfigsToProperties(props, spec.commonClientConf(), spec.commonClientConf());
            this.conf = new AdminClientConfig((Map)props);
            List addresses = ClientUtils.parseAndValidateAddresses((List)this.conf.getList("bootstrap.servers"), (String)this.conf.getString("client.dns.lookup"));
            this.updater = new ManualMetadataUpdater(Cluster.bootstrap((List)addresses).nodes());
        }

        @Override
        public boolean tryConnect() {
            try {
                List nodes = this.updater.fetchNodes();
                Node targetNode = (Node)nodes.get(ThreadLocalRandom.current().nextInt(nodes.size()));
                ChannelBuilder channelBuilder = ClientUtils.createChannelBuilder((AbstractConfig)this.conf, (Time)TIME, (LogContext)this.logContext);
                try (Metrics metrics = new Metrics();
                     Selector selector = new Selector(this.conf.getLong("connections.max.idle.ms").longValue(), metrics, TIME, "", channelBuilder, this.logContext);
                     NetworkClient client = new NetworkClient((Selectable)selector, (MetadataUpdater)this.updater, "ConnectionStressWorker", 1, 1000L, 1000L, 4096, 4096, 1000, 10000L, 127000L, TIME, false, new ApiVersions(), this.logContext, MetadataRecoveryStrategy.NONE);){
                    NetworkClientUtils.awaitReady((KafkaClient)client, (Node)targetNode, (Time)TIME, (long)500L);
                }
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        public void close() throws Exception {
            Utils.closeQuietly((AutoCloseable)this.updater, (String)"ManualMetadataUpdater");
        }
    }

    static interface Stressor
    extends AutoCloseable {
        public static Stressor fromSpec(ConnectionStressSpec spec) {
            switch (spec.action()) {
                case CONNECT: {
                    return new ConnectStressor(spec);
                }
                case FETCH_METADATA: {
                    return new FetchMetadataStressor(spec);
                }
            }
            throw new RuntimeException("invalid spec.action " + (Object)((Object)spec.action()));
        }

        public boolean tryConnect();
    }

    private static class ConnectStressThrottle
    extends Throttle {
        ConnectStressThrottle(int maxPerPeriod) {
            super(maxPerPeriod, 100);
        }
    }
}

