/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.StringUtils;

public class ReflectionMap<V> {
    private final List<ClassEntry<V>> classEntries;
    private final List<MethodEntry<V>> methodEntries;
    private final List<FieldEntry<V>> fieldEntries;
    private final List<ConstructorEntry<V>> constructorEntries;
    final boolean noClassEntries;
    final boolean noMethodEntries;
    final boolean noFieldEntries;
    final boolean noConstructorEntries;

    ReflectionMap(Builder<V> b) {
        this.classEntries = Collections.unmodifiableList(new ArrayList(b.classEntries));
        this.methodEntries = Collections.unmodifiableList(new ArrayList(b.methodEntries));
        this.fieldEntries = Collections.unmodifiableList(new ArrayList(b.fieldEntries));
        this.constructorEntries = Collections.unmodifiableList(new ArrayList(b.constructorEntries));
        this.noClassEntries = this.classEntries.isEmpty();
        this.noMethodEntries = this.methodEntries.isEmpty();
        this.noFieldEntries = this.fieldEntries.isEmpty();
        this.noConstructorEntries = this.constructorEntries.isEmpty();
    }

    public static <V> Builder<V> create(Class<V> c) {
        return new Builder();
    }

    static List<String> splitNames(String key) {
        if (key.indexOf(44) == -1) {
            return Collections.singletonList(key.trim());
        }
        ArrayList<String> l = new ArrayList<String>();
        int m = 0;
        boolean escaped = false;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c == '(') {
                escaped = true;
                continue;
            }
            if (c == ')') {
                escaped = false;
                continue;
            }
            if (c != ',' || escaped) continue;
            l.add(key.substring(m, i).trim());
            m = i + 1;
        }
        l.add(key.substring(m).trim());
        return l;
    }

    public Optional<V> find(Class<?> c, Class<? extends V> ofType) {
        if (!this.noClassEntries) {
            for (ClassEntry<V> e : this.classEntries) {
                if (!e.matches(c) || ofType != null && !ofType.isInstance(e.value)) continue;
                return Optional.of(e.value);
            }
        }
        return Optional.empty();
    }

    public Optional<V> find(Method m, Class<? extends V> ofType) {
        if (!this.noMethodEntries) {
            for (MethodEntry<V> e : this.methodEntries) {
                if (!e.matches(m) || ofType != null && !ofType.isInstance(e.value)) continue;
                return Optional.of(e.value);
            }
        }
        return Optional.empty();
    }

    public Optional<V> find(Field f, Class<? extends V> ofType) {
        if (!this.noFieldEntries) {
            for (FieldEntry<V> e : this.fieldEntries) {
                if (!e.matches(f) || ofType != null && !ofType.isInstance(e.value)) continue;
                return Optional.of(e.value);
            }
        }
        return Optional.empty();
    }

    public Optional<V> find(Constructor<?> c, Class<? extends V> ofType) {
        if (!this.noConstructorEntries) {
            for (ConstructorEntry<V> e : this.constructorEntries) {
                if (!e.matches(c) || ofType != null && !ofType.isInstance(e.value)) continue;
                return Optional.of(e.value);
            }
        }
        return Optional.empty();
    }

    static boolean argsMatch(String[] names, Class<?>[] args) {
        if (names == null) {
            return true;
        }
        if (names.length != args.length) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            String n = names[i];
            Class<?> a = args[i];
            if (StringUtils.isEquals(n, a.getSimpleName()) || StringUtils.isEquals(n, a.getName())) continue;
            return false;
        }
        return true;
    }

    static String simpleClassName(String name) {
        int i = name.indexOf(46);
        if (i == -1) {
            return name;
        }
        return null;
    }

    static boolean classMatches(String simpleName, String fullName, Class<?> c) {
        String cSimple = c.getSimpleName();
        String cFull = c.getName();
        if (StringUtils.isEquals(simpleName, cSimple) || StringUtils.isEquals(fullName, cFull)) {
            return true;
        }
        if (cFull.indexOf(36) != -1) {
            Package p = c.getPackage();
            if (p != null) {
                cFull = cFull.substring(p.getName().length() + 1);
            }
            if (StringUtils.isEquals(simpleName, cFull)) {
                return true;
            }
            int i = cFull.indexOf(36);
            while (i != -1) {
                if (StringUtils.isEquals(simpleName, cFull = cFull.substring(i + 1))) {
                    return true;
                }
                i = cFull.indexOf(36);
            }
        }
        return false;
    }

    public String toString() {
        return new ObjectMap().append("classEntries", this.classEntries).append("methodEntries", this.methodEntries).append("fieldEntries", this.fieldEntries).append("constructorEntries", this.constructorEntries).toString();
    }

    static class FieldEntry<V> {
        String simpleClassName;
        String fullClassName;
        String fieldName;
        V value;

        FieldEntry(String name, V value) {
            int i = name.lastIndexOf(46);
            String s1 = name.substring(0, i);
            String s2 = name.substring(i + 1);
            this.simpleClassName = ReflectionMap.simpleClassName(s1);
            this.fullClassName = s1;
            this.fieldName = s2;
            this.value = value;
        }

        public boolean matches(Field f) {
            if (f == null) {
                return false;
            }
            Class<?> c = f.getDeclaringClass();
            return ReflectionMap.classMatches(this.simpleClassName, this.fullClassName, c) && StringUtils.isEquals(f.getName(), this.fieldName);
        }

        public ObjectMap asMap() {
            return new ObjectMap().append("simpleClassName", this.simpleClassName).append("fullClassName", this.fullClassName).append("fieldName", this.fieldName).append("value", this.value);
        }

        public String toString() {
            return this.asMap().toString();
        }
    }

    static class ConstructorEntry<V> {
        String simpleClassName;
        String fullClassName;
        String[] args;
        V value;

        ConstructorEntry(String name, V value) {
            int i = name.indexOf(40);
            this.args = StringUtils.split(name.substring(i + 1, name.length() - 1));
            name = name.substring(0, i).trim();
            this.simpleClassName = ReflectionMap.simpleClassName(name);
            this.fullClassName = name;
            this.value = value;
        }

        public boolean matches(Constructor<?> m) {
            if (m == null) {
                return false;
            }
            Class<?> c = m.getDeclaringClass();
            return ReflectionMap.classMatches(this.simpleClassName, this.fullClassName, c) && ReflectionMap.argsMatch(this.args, m.getParameterTypes());
        }

        public ObjectMap asMap() {
            return new ObjectMap().append("simpleClassName", this.simpleClassName).append("fullClassName", this.fullClassName).append("args", this.args).append("value", this.value);
        }

        public String toString() {
            return this.asMap().toString();
        }
    }

    static class MethodEntry<V> {
        String simpleClassName;
        String fullClassName;
        String methodName;
        String[] args;
        V value;

        MethodEntry(String name, V value) {
            int i = name.indexOf(40);
            this.args = i == -1 ? null : StringUtils.split(name.substring(i + 1, name.length() - 1));
            name = i == -1 ? name : name.substring(0, i);
            i = name.lastIndexOf(46);
            String s1 = name.substring(0, i).trim();
            String s2 = name.substring(i + 1).trim();
            this.simpleClassName = ReflectionMap.simpleClassName(s1);
            this.fullClassName = s1;
            this.methodName = s2;
            this.value = value;
        }

        public boolean matches(Method m) {
            if (m == null) {
                return false;
            }
            Class<?> c = m.getDeclaringClass();
            return ReflectionMap.classMatches(this.simpleClassName, this.fullClassName, c) && StringUtils.isEquals(m.getName(), this.methodName) && ReflectionMap.argsMatch(this.args, m.getParameterTypes());
        }

        public ObjectMap asMap() {
            return new ObjectMap().append("simpleClassName", this.simpleClassName).append("fullClassName", this.fullClassName).append("methodName", this.methodName).append("args", this.args).append("value", this.value);
        }

        public String toString() {
            return this.asMap().toString();
        }
    }

    static class ClassEntry<V> {
        final String simpleName;
        final String fullName;
        final V value;

        ClassEntry(String name, V value) {
            this.simpleName = ReflectionMap.simpleClassName(name);
            this.fullName = name;
            this.value = value;
        }

        public boolean matches(Class<?> c) {
            if (c == null) {
                return false;
            }
            return ReflectionMap.classMatches(this.simpleName, this.fullName, c);
        }

        public ObjectMap asMap() {
            return new ObjectMap().append("simpleName", this.simpleName).append("fullName", this.fullName).append("value", this.value);
        }

        public String toString() {
            return this.asMap().toString();
        }
    }

    public static class Builder<V> {
        List<ClassEntry<V>> classEntries = new ArrayList<ClassEntry<V>>();
        List<MethodEntry<V>> methodEntries = new ArrayList<MethodEntry<V>>();
        List<FieldEntry<V>> fieldEntries = new ArrayList<FieldEntry<V>>();
        List<ConstructorEntry<V>> constructorEntries = new ArrayList<ConstructorEntry<V>>();

        public Builder<V> append(String key, V value) {
            if (StringUtils.isEmpty(key)) {
                throw new RuntimeException("Invalid reflection signature: [" + key + "]");
            }
            try {
                for (String k : ReflectionMap.splitNames(key)) {
                    int i;
                    if (k.endsWith(")")) {
                        i = k.substring(0, k.indexOf(40)).lastIndexOf(46);
                        if (i == -1 || Character.isUpperCase(k.charAt(i + 1))) {
                            this.constructorEntries.add(new ConstructorEntry<V>(k, value));
                            continue;
                        }
                        this.methodEntries.add(new MethodEntry<V>(k, value));
                        continue;
                    }
                    i = k.lastIndexOf(46);
                    if (i == -1) {
                        this.classEntries.add(new ClassEntry<V>(k, value));
                        continue;
                    }
                    if (Character.isUpperCase(k.charAt(i + 1))) {
                        this.classEntries.add(new ClassEntry<V>(k, value));
                        this.fieldEntries.add(new FieldEntry<V>(k, value));
                        continue;
                    }
                    this.methodEntries.add(new MethodEntry<V>(k, value));
                    this.fieldEntries.add(new FieldEntry<V>(k, value));
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeException("Invalid reflection signature: [" + key + "]");
            }
            return this;
        }

        public ReflectionMap<V> build() {
            return new ReflectionMap(this);
        }
    }
}

