/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.parser;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.jmeter.protocol.http.parser.CssParserCacheLoader;
import org.apache.jmeter.protocol.http.parser.LinkExtractorParseException;
import org.apache.jmeter.protocol.http.parser.LinkExtractorParser;
import org.apache.jmeter.protocol.http.parser.URLCollection;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssParser
implements LinkExtractorParser {
    private static final URLCollection EMPTY_URL_COLLECTION = new URLCollection(Collections.emptyList());
    private static final Logger LOG = LoggerFactory.getLogger(CssParser.class);
    private static final LoadingCache<Triple<String, URL, Charset>, URLCollection> CSS_URL_CACHE;

    @Override
    public Iterator<URL> getEmbeddedResourceURLs(String userAgent, byte[] data, URL baseUrl, String encoding) throws LinkExtractorParseException {
        try {
            String cssContent = new String(data, encoding);
            Charset charset = Charset.forName(encoding);
            ImmutableTriple triple = ImmutableTriple.of((Object)cssContent, (Object)baseUrl, (Object)charset);
            URLCollection urlCollection = CssParser.orDefault((URLCollection)CSS_URL_CACHE.get((Object)triple), EMPTY_URL_COLLECTION);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parsed: {}, got: {}", (Object)baseUrl, (Object)StringUtils.join((Iterable)urlCollection, (String)","));
            }
            return urlCollection.iterator();
        }
        catch (Exception e) {
            throw new LinkExtractorParseException(e);
        }
    }

    private static URLCollection orDefault(URLCollection urlCollection, URLCollection defaultValue) {
        if (urlCollection == null) {
            return Objects.requireNonNull(defaultValue);
        }
        return urlCollection;
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    static {
        int cacheSize = JMeterUtils.getPropDefault((String)"css.parser.cache.size", (int)400);
        CSS_URL_CACHE = Caffeine.newBuilder().maximumSize((long)cacheSize).build((CacheLoader)new CssParserCacheLoader());
    }
}

