/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapConfiguration;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.StatusDataItems;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.StatusRequest;
import org.apache.james.imap.message.response.MailboxStatusResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class StatusProcessor
extends AbstractMailboxProcessor<StatusRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusProcessor.class);
    private ImapConfiguration imapConfiguration;

    @Inject
    public StatusProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(StatusRequest.class, mailboxManager, factory, metricFactory);
    }

    @Override
    public void configure(ImapConfiguration imapConfiguration) {
        super.configure(imapConfiguration);
        this.imapConfiguration = imapConfiguration;
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return ImmutableList.of((Object)Capability.of("STATUS=SIZE"));
    }

    @Override
    protected Mono<Void> processRequestReactive(StatusRequest request, ImapSession session, ImapProcessor.Responder responder) {
        MailboxPath mailboxPath = PathConverter.forSession(session).buildFullPath(request.getMailboxName());
        MailboxSession mailboxSession = session.getMailboxSession();
        StatusDataItems statusDataItems = request.getStatusDataItems();
        return this.logInitialRequest(mailboxPath).then(this.sendStatus(mailboxPath, statusDataItems, responder, session, mailboxSession)).then(this.unsolicitedResponses(session, responder, false)).then(Mono.fromRunnable(() -> this.okComplete(request, responder))).onErrorResume(MailboxException.class, e -> {
            this.no(request, responder, HumanReadableText.STATUS_FAILED);
            return ReactorUtils.logAsMono(() -> LOGGER.error("Status failed for mailbox {}", (Object)mailboxPath, (Object)e));
        }).then();
    }

    private Mono<MailboxStatusResponse> sendStatus(MailboxPath mailboxPath, StatusDataItems statusDataItems, ImapProcessor.Responder responder, ImapSession session, MailboxSession mailboxSession) {
        return Mono.from((Publisher)this.getMailboxManager().getMailboxReactive(mailboxPath, mailboxSession)).flatMap(mailbox -> this.sendStatus((MessageManager)mailbox, statusDataItems, responder, session, mailboxSession));
    }

    Mono<MailboxStatusResponse> sendStatus(MessageManager mailbox, StatusDataItems statusDataItems, ImapProcessor.Responder responder, ImapSession session, MailboxSession mailboxSession) {
        return this.retrieveMetadata(mailbox, statusDataItems, mailboxSession).flatMap(metaData -> this.computeStatusResponse(mailbox, statusDataItems, (MessageManager.MailboxMetaData)metaData, mailboxSession).doOnNext(response -> {
            if (response.getHighestModSeq() != null) {
                this.condstoreEnablingCommand(session, responder, (MessageManager.MailboxMetaData)metaData, false);
            }
            responder.respond((ImapResponseMessage)response);
        }));
    }

    private Mono<Void> logInitialRequest(MailboxPath mailboxPath) {
        if (LOGGER.isDebugEnabled()) {
            return ReactorUtils.logAsMono(() -> LOGGER.debug("Status called on mailbox named {}", (Object)mailboxPath));
        }
        return Mono.empty();
    }

    private Mono<MessageManager.MailboxMetaData> retrieveMetadata(MessageManager mailbox, StatusDataItems statusDataItems, MailboxSession mailboxSession) {
        EnumSet<MessageManager.MailboxMetaData.Item> fetchGroup = this.computeFetchGroup(statusDataItems);
        MessageManager.MailboxMetaData.RecentMode recentMode = this.computeRecentMode(statusDataItems);
        try {
            return mailbox.getMetaDataReactive(recentMode, mailboxSession, fetchGroup);
        }
        catch (MailboxException e) {
            throw new RuntimeException(e);
        }
    }

    private MessageManager.MailboxMetaData.RecentMode computeRecentMode(StatusDataItems statusDataItems) {
        if (statusDataItems.isRecent()) {
            return MessageManager.MailboxMetaData.RecentMode.RETRIEVE;
        }
        return MessageManager.MailboxMetaData.RecentMode.IGNORE;
    }

    private Mono<MailboxStatusResponse> computeStatusResponse(MessageManager mailbox, StatusDataItems statusDataItems, MessageManager.MailboxMetaData metaData, MailboxSession session) {
        return this.iterateMailbox(statusDataItems, mailbox, session).map(maybeIterationResult -> {
            Optional<Long> appendLimit = this.appendLimit(statusDataItems);
            Long messages = this.messages(statusDataItems, metaData);
            Long recent = this.recent(statusDataItems, metaData);
            MessageUid uidNext = this.uidNext(statusDataItems, metaData);
            UidValidity uidValidity = this.uidValidity(statusDataItems, metaData);
            Long unseen = this.unseen(statusDataItems, metaData);
            ModSeq highestModSeq = this.highestModSeq(statusDataItems, metaData);
            MailboxId mailboxId = this.mailboxId(statusDataItems, mailbox);
            return new MailboxStatusResponse(appendLimit, maybeIterationResult.flatMap(result -> result.getSize(statusDataItems)).orElse(null), maybeIterationResult.flatMap(result -> result.getDeleted(statusDataItems)).orElse(null), maybeIterationResult.flatMap(result -> result.getDeletedStorage(statusDataItems)).orElse(null), messages, recent, uidNext, highestModSeq, uidValidity, unseen, mailbox.getMailboxPath().getName(), mailboxId);
        });
    }

    private EnumSet<MessageManager.MailboxMetaData.Item> computeFetchGroup(StatusDataItems statusDataItems) {
        EnumSet<MessageManager.MailboxMetaData.Item> result = EnumSet.noneOf(MessageManager.MailboxMetaData.Item.class);
        if (statusDataItems.isUnseen() || statusDataItems.isMessages()) {
            result.add(MessageManager.MailboxMetaData.Item.MailboxCounters);
        }
        if (statusDataItems.isHighestModSeq()) {
            result.add(MessageManager.MailboxMetaData.Item.HighestModSeq);
        }
        if (statusDataItems.isUidNext()) {
            result.add(MessageManager.MailboxMetaData.Item.NextUid);
        }
        return result;
    }

    private Long unseen(StatusDataItems statusDataItems, MessageManager.MailboxMetaData metaData) {
        if (statusDataItems.isUnseen()) {
            return metaData.getUnseenCount();
        }
        return null;
    }

    private MailboxId mailboxId(StatusDataItems statusDataItems, MessageManager mailbox) {
        if (statusDataItems.isMailboxId()) {
            return mailbox.getId();
        }
        return null;
    }

    private Optional<Long> appendLimit(StatusDataItems statusDataItems) {
        if (statusDataItems.isAppendLimit()) {
            return this.imapConfiguration.getAppendLimit();
        }
        return null;
    }

    private UidValidity uidValidity(StatusDataItems statusDataItems, MessageManager.MailboxMetaData metaData) {
        if (statusDataItems.isUidValidity()) {
            return metaData.getUidValidity();
        }
        return null;
    }

    private ModSeq highestModSeq(StatusDataItems statusDataItems, MessageManager.MailboxMetaData metaData) {
        if (statusDataItems.isHighestModSeq()) {
            return metaData.getHighestModSeq();
        }
        return null;
    }

    private MessageUid uidNext(StatusDataItems statusDataItems, MessageManager.MailboxMetaData metaData) {
        if (statusDataItems.isUidNext()) {
            return metaData.getUidNext();
        }
        return null;
    }

    private Long recent(StatusDataItems statusDataItems, MessageManager.MailboxMetaData metaData) {
        if (statusDataItems.isRecent()) {
            return metaData.countRecent();
        }
        return null;
    }

    private Long messages(StatusDataItems statusDataItems, MessageManager.MailboxMetaData metaData) {
        if (statusDataItems.isMessages()) {
            return metaData.getMessageCount();
        }
        return null;
    }

    private Mono<Optional<MailboxIterationResult>> iterateMailbox(StatusDataItems statusDataItems, MessageManager messageManager, MailboxSession session) {
        if (statusDataItems.isSize() || statusDataItems.isDeletedStorage()) {
            return Flux.from((Publisher)messageManager.getMessagesReactive(MessageRange.all(), FetchGroup.MINIMAL, session)).reduce((Object)new MailboxIterationResult(), MailboxIterationResult::accumulate).map(Optional::of);
        }
        if (statusDataItems.isDeleted()) {
            return Flux.from((Publisher)messageManager.listMessagesMetadata(MessageRange.all(), session)).reduce((Object)new MailboxIterationResult(), MailboxIterationResult::accumulateDeleted).map(Optional::of);
        }
        return Mono.just(Optional.empty());
    }

    @Override
    protected MDCBuilder mdc(StatusRequest request) {
        return MDCBuilder.create().addToContext("action", "STATUS").addToContext("mailbox", request.getMailboxName()).addToContext("parameters", request.getStatusDataItems().toString());
    }

    public static class MailboxIterationResult {
        private long size = 0L;
        private long deleted = 0L;
        private long deletedStorage = 0L;

        public MailboxIterationResult accumulate(MessageResult messageResult) {
            if (messageResult.getFlags().contains(Flags.Flag.DELETED)) {
                ++this.deleted;
                this.deletedStorage += messageResult.getSize();
            }
            this.size += messageResult.getSize();
            return this;
        }

        public MailboxIterationResult accumulateDeleted(ComposedMessageIdWithMetaData metaData) {
            if (metaData.getFlags().contains(Flags.Flag.DELETED)) {
                ++this.deleted;
            }
            return this;
        }

        public Optional<Long> getSize(StatusDataItems items) {
            if (items.isSize()) {
                return Optional.of(this.size);
            }
            return Optional.empty();
        }

        public Optional<Long> getDeleted(StatusDataItems items) {
            if (items.isDeleted()) {
                return Optional.of(this.deleted);
            }
            return Optional.empty();
        }

        public Optional<Long> getDeletedStorage(StatusDataItems items) {
            if (items.isDeletedStorage()) {
                return Optional.of(this.deletedStorage);
            }
            return Optional.empty();
        }
    }
}

