/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.tsfile;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTsFileResourceSegmentLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTsFileResourceSegmentLock.class);
    private static final int SEGMENT_LOCK_MIN_SIZE = 32;
    private static final int SEGMENT_LOCK_MAX_SIZE = 128;
    private volatile ReentrantLock[] locks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIfNecessary() {
        if (this.locks == null) {
            PipeTsFileResourceSegmentLock pipeTsFileResourceSegmentLock = this;
            synchronized (pipeTsFileResourceSegmentLock) {
                int lockSegmentSize = PipeConfig.getInstance().getPipeTsFileResourceSegmentLockNum();
                if (this.locks == null) {
                    if (lockSegmentSize <= 0) {
                        try {
                            lockSegmentSize = Math.min(Math.max(StorageEngine.getInstance().getAllDataRegionIds().size(), 32), 128);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Cannot get data region ids, use default lock segment size: {}", (Object)lockSegmentSize);
                            lockSegmentSize = 32;
                        }
                    }
                    ReentrantLock[] tmpLocks = new ReentrantLock[lockSegmentSize];
                    for (int i = 0; i < tmpLocks.length; ++i) {
                        tmpLocks[i] = new ReentrantLock();
                    }
                    this.locks = tmpLocks;
                } else if (this.locks.length < lockSegmentSize) {
                    ReentrantLock[] tmpLocks = new ReentrantLock[lockSegmentSize];
                    System.arraycopy(this.locks, 0, tmpLocks, 0, this.locks.length);
                    for (int i = this.locks.length; i < lockSegmentSize; ++i) {
                        tmpLocks[i] = new ReentrantLock();
                    }
                    this.locks = tmpLocks;
                }
            }
        }
    }

    public void lock(File file) {
        this.initIfNecessary();
        this.locks[Math.abs(file.hashCode()) % this.locks.length].lock();
    }

    public boolean tryLock(File file, long timeout, TimeUnit timeUnit) throws InterruptedException {
        this.initIfNecessary();
        return this.locks[Math.abs(file.hashCode()) % this.locks.length].tryLock(timeout, timeUnit);
    }

    public void unlock(File file) {
        this.initIfNecessary();
        this.locks[Math.abs(file.hashCode()) % this.locks.length].unlock();
    }
}

