/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.utils.datastructure.MemPointIterator;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.reader.series.PaginationController;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public abstract class MultiTVListIterator
extends MemPointIterator {
    protected TSDataType tsDataType;
    protected List<TVList.TVListIterator> tvListIterators;
    protected int floatPrecision;
    protected TSEncoding encoding;
    protected boolean probeNext = false;
    protected boolean hasNext = false;
    protected long currentTime = 0L;
    protected int iteratorIndex = 0;
    protected int rowIndex = 0;
    protected final int maxNumberOfPointsInPage;

    protected MultiTVListIterator(Ordering scanOrder, Filter globalTimeFilter, TSDataType tsDataType, List<TVList> tvLists, List<Integer> tvListRowCounts, List<TimeRange> deletionList, Integer floatPrecision, TSEncoding encoding, int maxNumberOfPointsInPage) {
        super(scanOrder);
        this.tsDataType = tsDataType;
        this.tvListIterators = new ArrayList<TVList.TVListIterator>(tvLists.size());
        if (scanOrder.isAscending()) {
            for (int i = 0; i < tvLists.size(); ++i) {
                TVList tvList = tvLists.get(i);
                int rowCount = tvListRowCounts == null ? tvList.rowCount : tvListRowCounts.get(i);
                TVList.TVListIterator iterator = tvList.iterator(scanOrder, rowCount, globalTimeFilter, deletionList, null, null, maxNumberOfPointsInPage);
                this.tvListIterators.add(iterator);
            }
        } else {
            for (int i = tvLists.size() - 1; i >= 0; --i) {
                TVList tvList = tvLists.get(i);
                int rowCount = tvListRowCounts == null ? tvList.rowCount : tvListRowCounts.get(i);
                TVList.TVListIterator iterator = tvList.iterator(scanOrder, rowCount, globalTimeFilter, deletionList, null, null, maxNumberOfPointsInPage);
                this.tvListIterators.add(iterator);
            }
        }
        this.floatPrecision = floatPrecision != null ? floatPrecision : 0;
        this.encoding = encoding;
        this.maxNumberOfPointsInPage = maxNumberOfPointsInPage;
    }

    public boolean hasNextTimeValuePair() {
        if (!this.paginationController.hasCurLimit()) {
            return false;
        }
        if (!this.probeNext) {
            this.prepareNext();
        }
        return this.hasNext && !this.isCurrentTimeExceedTimeRange(this.currentTime);
    }

    public TimeValuePair nextTimeValuePair() {
        if (!this.hasNextTimeValuePair()) {
            return null;
        }
        TVList.TVListIterator iterator = this.tvListIterators.get(this.iteratorIndex);
        TimeValuePair currentTvPair = iterator.getTVList().getTimeValuePair(iterator.getScanOrderIndex(this.rowIndex), this.currentTime, this.floatPrecision, this.encoding);
        this.next();
        return currentTvPair;
    }

    public TimeValuePair currentTimeValuePair() {
        if (!this.hasNextTimeValuePair()) {
            return null;
        }
        TVList.TVListIterator iterator = this.tvListIterators.get(this.iteratorIndex);
        return iterator.getTVList().getTimeValuePair(this.rowIndex, this.currentTime, this.floatPrecision, this.encoding);
    }

    @Override
    public boolean hasNextBatch() {
        return this.hasNextTimeValuePair();
    }

    @Override
    public TsBlock nextBatch() {
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(this.tsDataType));
        switch (this.tsDataType) {
            case BOOLEAN: {
                TVList.TVListIterator iterator;
                while (this.hasNextTimeValuePair() && builder.getPositionCount() < this.maxNumberOfPointsInPage) {
                    iterator = this.tvListIterators.get(this.iteratorIndex);
                    boolean aBoolean = iterator.getTVList().getBoolean(iterator.getScanOrderIndex(this.rowIndex));
                    if (this.pushDownFilter == null || this.pushDownFilter.satisfyBoolean(this.currentTime, aBoolean)) {
                        builder.getTimeColumnBuilder().writeLong(this.currentTime);
                        builder.getColumnBuilder(0).writeBoolean(aBoolean);
                        builder.declarePosition();
                    }
                    this.next();
                }
                break;
            }
            case INT32: 
            case DATE: {
                TVList.TVListIterator iterator;
                while (this.hasNextTimeValuePair() && builder.getPositionCount() < this.maxNumberOfPointsInPage) {
                    iterator = this.tvListIterators.get(this.iteratorIndex);
                    int anInt = iterator.getTVList().getInt(iterator.getScanOrderIndex(this.rowIndex));
                    if (this.pushDownFilter == null || this.pushDownFilter.satisfyInteger(this.currentTime, anInt)) {
                        builder.getTimeColumnBuilder().writeLong(this.currentTime);
                        builder.getColumnBuilder(0).writeInt(anInt);
                        builder.declarePosition();
                    }
                    this.next();
                }
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                TVList.TVListIterator iterator;
                while (this.hasNextTimeValuePair() && builder.getPositionCount() < this.maxNumberOfPointsInPage) {
                    iterator = this.tvListIterators.get(this.iteratorIndex);
                    long aLong = iterator.getTVList().getLong(iterator.getScanOrderIndex(this.rowIndex));
                    if (this.pushDownFilter == null || this.pushDownFilter.satisfyLong(this.currentTime, aLong)) {
                        builder.getTimeColumnBuilder().writeLong(this.currentTime);
                        builder.getColumnBuilder(0).writeLong(aLong);
                        builder.declarePosition();
                    }
                    this.next();
                }
                break;
            }
            case FLOAT: {
                TVList.TVListIterator iterator;
                while (this.hasNextTimeValuePair() && builder.getPositionCount() < this.maxNumberOfPointsInPage) {
                    iterator = this.tvListIterators.get(this.iteratorIndex);
                    TVList floatTvList = iterator.getTVList();
                    float aFloat = floatTvList.roundValueWithGivenPrecision(floatTvList.getFloat(iterator.getScanOrderIndex(this.rowIndex)), this.floatPrecision, this.encoding);
                    if (this.pushDownFilter == null || this.pushDownFilter.satisfyFloat(this.currentTime, aFloat)) {
                        builder.getTimeColumnBuilder().writeLong(this.currentTime);
                        builder.getColumnBuilder(0).writeFloat(aFloat);
                        builder.declarePosition();
                    }
                    this.next();
                }
                break;
            }
            case DOUBLE: {
                TVList.TVListIterator iterator;
                while (this.hasNextTimeValuePair() && builder.getPositionCount() < this.maxNumberOfPointsInPage) {
                    iterator = this.tvListIterators.get(this.iteratorIndex);
                    TVList doubleTvList = iterator.getTVList();
                    double aDouble = doubleTvList.roundValueWithGivenPrecision(doubleTvList.getDouble(iterator.getScanOrderIndex(this.rowIndex)), this.floatPrecision, this.encoding);
                    if (this.pushDownFilter == null || this.pushDownFilter.satisfyDouble(this.currentTime, aDouble)) {
                        builder.getTimeColumnBuilder().writeLong(this.currentTime);
                        builder.getColumnBuilder(0).writeDouble(aDouble);
                        builder.declarePosition();
                    }
                    this.next();
                }
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                TVList.TVListIterator iterator;
                while (this.hasNextTimeValuePair() && builder.getPositionCount() < this.maxNumberOfPointsInPage) {
                    iterator = this.tvListIterators.get(this.iteratorIndex);
                    Binary binary = iterator.getTVList().getBinary(iterator.getScanOrderIndex(this.rowIndex));
                    if (this.pushDownFilter == null || this.pushDownFilter.satisfyBinary(this.currentTime, binary)) {
                        builder.getTimeColumnBuilder().writeLong(this.currentTime);
                        builder.getColumnBuilder(0).writeBinary(binary);
                        builder.declarePosition();
                    }
                    this.next();
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.tsDataType));
            }
        }
        TsBlock tsBlock = this.paginationController.applyTsBlock(builder.build());
        this.addTsBlock(tsBlock);
        return tsBlock;
    }

    @Override
    public TsBlock getBatch(int tsBlockIndex) {
        if (tsBlockIndex < 0 || tsBlockIndex >= this.tsBlocks.size()) {
            return null;
        }
        return (TsBlock)this.tsBlocks.get(tsBlockIndex);
    }

    public long getUsedMemorySize() {
        return 0L;
    }

    protected abstract void prepareNext();

    protected abstract void next();

    @Override
    public void setPushDownFilter(Filter pushDownFilter) {
        for (TVList.TVListIterator iterator : this.tvListIterators) {
            iterator.setPushDownFilter(pushDownFilter);
        }
        this.pushDownFilter = pushDownFilter;
    }

    @Override
    public void setLimitAndOffset(PaginationController paginationController) {
        for (TVList.TVListIterator iterator : this.tvListIterators) {
            iterator.setLimitAndOffset(paginationController);
        }
        this.paginationController = paginationController;
    }
}

