#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# coding: utf-8

"""
    Apache Iceberg REST Catalog API

    Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from polaris.catalog.models.token_type import TokenType
from typing import Optional, Set
from typing_extensions import Self

class OAuthTokenResponse(BaseModel):
    """
    OAuthTokenResponse
    """ # noqa: E501
    access_token: StrictStr = Field(description="The access token, for client credentials or token exchange")
    token_type: StrictStr = Field(description="Access token type for client credentials or token exchange  See https://datatracker.ietf.org/doc/html/rfc6749#section-7.1")
    expires_in: Optional[StrictInt] = Field(default=None, description="Lifetime of the access token in seconds for client credentials or token exchange")
    issued_token_type: Optional[TokenType] = None
    refresh_token: Optional[StrictStr] = Field(default=None, description="Refresh token for client credentials or token exchange")
    scope: Optional[StrictStr] = Field(default=None, description="Authorization scope for client credentials or token exchange")
    __properties: ClassVar[List[str]] = ["access_token", "token_type", "expires_in", "issued_token_type", "refresh_token", "scope"]

    @field_validator('token_type')
    def token_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['bearer', 'mac', 'N_A']):
            raise ValueError("must be one of enum values ('bearer', 'mac', 'N_A')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OAuthTokenResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OAuthTokenResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "access_token": obj.get("access_token"),
            "token_type": obj.get("token_type"),
            "expires_in": obj.get("expires_in"),
            "issued_token_type": obj.get("issued_token_type"),
            "refresh_token": obj.get("refresh_token"),
            "scope": obj.get("scope")
        })
        return _obj


