/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.pbf;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.baremaps.openstreetmap.model.Blob;
import org.apache.baremaps.osm.binary.Fileformat;

class BlobIterator
implements Iterator<Blob> {
    private final DataInputStream dis;
    private Blob next;

    public BlobIterator(InputStream input) {
        this.dis = new DataInputStream(input);
    }

    private Blob read() throws IOException {
        int headerSize = this.dis.readInt();
        byte[] headerBytes = new byte[headerSize];
        this.dis.readFully(headerBytes);
        Fileformat.BlobHeader header = Fileformat.BlobHeader.parseFrom(headerBytes);
        int dataSize = header.getDatasize();
        byte[] data = new byte[dataSize];
        this.dis.readFully(data);
        return new Blob(header, data, 8 + headerSize + dataSize);
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.next == null) {
                this.next = this.read();
            }
            return true;
        }
        catch (IOException exception) {
            return false;
        }
    }

    @Override
    public Blob next() {
        try {
            if (this.next == null) {
                this.next = this.read();
            }
            Blob current = this.next;
            this.next = null;
            return current;
        }
        catch (IOException exception) {
            throw new NoSuchElementException();
        }
    }
}

