/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.util.ServiceNamingUtil;
import com.linecorp.armeria.server.LengthBasedServiceNaming;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleTypeServiceNaming;
import java.util.Objects;

@FunctionalInterface
public interface ServiceNaming {
    public static ServiceNaming of(String defaultServiceName) {
        Objects.requireNonNull(defaultServiceName, "defaultServiceName");
        return ctx -> defaultServiceName;
    }

    public static ServiceNaming fullTypeName() {
        return ctx -> {
            RpcRequest rpcReq = ctx.rpcRequest();
            if (rpcReq != null) {
                return rpcReq.serviceName();
            }
            return ServiceNamingUtil.trimTrailingDollarSigns(ServiceNamingUtil.fullTypeHttpServiceName(ctx.config().service()));
        };
    }

    public static ServiceNaming simpleTypeName() {
        return SimpleTypeServiceNaming.INSTANCE;
    }

    public static ServiceNaming shorten(int targetLength) {
        return LengthBasedServiceNaming.of(targetLength);
    }

    public static ServiceNaming shorten() {
        return ServiceNaming.shorten(0);
    }

    @Nullable
    public String serviceName(ServiceRequestContext var1);
}

