/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.server.CorsHeaderUtil;
import com.linecorp.armeria.server.HttpResponseException;
import com.linecorp.armeria.server.ServerErrorHandler;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.cors.CorsConfig;
import com.linecorp.armeria.server.cors.CorsService;

final class CorsServerErrorHandler
implements ServerErrorHandler {
    ServerErrorHandler serverErrorHandler;

    CorsServerErrorHandler(ServerErrorHandler serverErrorHandler) {
        this.serverErrorHandler = serverErrorHandler;
    }

    @Override
    @Nullable
    public AggregatedHttpResponse renderStatus(@Nullable ServiceRequestContext ctx, ServiceConfig serviceConfig, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
        if (ctx == null) {
            return this.serverErrorHandler.renderStatus(null, serviceConfig, headers, status, description, cause);
        }
        CorsService corsService = ctx.findService(CorsService.class);
        if (corsService == null) {
            return this.serverErrorHandler.renderStatus(ctx, serviceConfig, headers, status, description, cause);
        }
        AggregatedHttpResponse res = this.serverErrorHandler.renderStatus(ctx, serviceConfig, headers, status, description, cause);
        if (res == null) {
            return this.serverErrorHandler.renderStatus(ctx, serviceConfig, headers, status, description, cause);
        }
        CorsConfig corsConfig = corsService.config();
        ResponseHeaders updatedResponseHeaders = CorsHeaderUtil.addCorsHeaders(ctx, corsConfig, res.headers());
        return AggregatedHttpResponse.of(updatedResponseHeaders, res.content());
    }

    @Override
    @Nullable
    public HttpResponse onServiceException(ServiceRequestContext ctx, Throwable cause) {
        if (cause instanceof HttpResponseException) {
            HttpResponse oldRes = this.serverErrorHandler.onServiceException(ctx, cause);
            if (oldRes == null) {
                return null;
            }
            CorsService corsService = ctx.findService(CorsService.class);
            if (corsService == null) {
                return oldRes;
            }
            return oldRes.recover(HttpResponseException.class, ex -> ex.httpResponse().mapHeaders(oldHeaders -> CorsHeaderUtil.addCorsHeaders(ctx, corsService.config(), oldHeaders)));
        }
        return this.serverErrorHandler.onServiceException(ctx, cause);
    }

    @Override
    @Nullable
    public AggregatedHttpResponse onProtocolViolation(ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
        return this.serverErrorHandler.onProtocolViolation(config, headers, status, description, cause);
    }
}

