/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.server.RouteUtil;
import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.RoutingResultBuilder;
import java.util.Objects;

abstract class AbstractPathMapping
implements PathMapping {
    AbstractPathMapping() {
    }

    static String mappedPath(String prefix, String path) {
        int length = prefix.length();
        if (length == 0 || "/".equals(prefix)) {
            return path;
        }
        if (prefix.charAt(length - 1) == '/') {
            --length;
        }
        return path.substring(length);
    }

    @Override
    public final PathMapping withPrefix(String prefix) {
        if ("/".equals(prefix = RouteUtil.ensureAbsolutePath(prefix, "prefix"))) {
            return this;
        }
        return this.doWithPrefix(prefix.charAt(prefix.length() - 1) == '/' ? prefix : prefix + '/');
    }

    abstract PathMapping doWithPrefix(String var1);

    @Override
    @Nullable
    public final RoutingResultBuilder apply(RoutingContext routingCtx) {
        RouteUtil.ensureAbsolutePath(Objects.requireNonNull(routingCtx, "routingCtx").path(), "path");
        return this.doApply(routingCtx);
    }

    @Nullable
    abstract RoutingResultBuilder doApply(RoutingContext var1);

    public String toString() {
        return this.patternString();
    }
}

