/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.metric;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.common.util.Ticker;
import com.linecorp.armeria.internal.common.metric.MicrometerUtil;
import com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Cache;
import com.linecorp.armeria.internal.shaded.caffeine.cache.LoadingCache;
import com.linecorp.armeria.internal.shaded.caffeine.cache.stats.CacheStats;
import io.micrometer.core.instrument.MeterRegistry;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.ToDoubleFunction;

public final class CaffeineMetricSupport {
    static final long UPDATE_INTERVAL_NANOS = TimeUnit.SECONDS.toNanos(3L);

    public static void setup(MeterRegistry registry, MeterIdPrefix idPrefix, Cache<?, ?> cache) {
        CaffeineMetricSupport.setup(registry, idPrefix, cache, Ticker.systemTicker());
    }

    public static void setup(MeterRegistry registry, MeterIdPrefix idPrefix, Cache<?, ?> cache, Ticker ticker) {
        Objects.requireNonNull(cache, "cache");
        if (!cache.policy().isRecordingStats()) {
            return;
        }
        CaffeineMetrics metrics = MicrometerUtil.register(registry, idPrefix, CaffeineMetrics.class, CaffeineMetrics::new);
        metrics.add(cache, ticker);
    }

    private CaffeineMetricSupport() {
    }

    private static final class CaffeineMetrics {
        private final MeterRegistry parent;
        private final MeterIdPrefix idPrefix;
        private final ReentrantLock lock = new ReentrantShortLock();
        @GuardedBy(value="lock")
        private final List<CacheReference> cacheRefs = new ArrayList<CacheReference>(2);
        private final AtomicBoolean hasLoadingCache = new AtomicBoolean();
        private final double[] statsForGarbageCollected = new double[Type.count];

        CaffeineMetrics(MeterRegistry parent, MeterIdPrefix idPrefix) {
            this.parent = Objects.requireNonNull(parent, "parent");
            this.idPrefix = Objects.requireNonNull(idPrefix, "idPrefix");
            String requests = idPrefix.name("requests");
            parent.more().counter(requests, idPrefix.tags("result", "hit"), (Object)this, this.func(Type.HIT_COUNT, ref -> ((CacheReference)ref).cacheStats.hitCount()));
            parent.more().counter(requests, idPrefix.tags("result", "miss"), (Object)this, this.func(Type.MISS_COUNT, ref -> ((CacheReference)ref).cacheStats.missCount()));
            parent.more().counter(idPrefix.name("evictions"), idPrefix.tags(), (Object)this, this.func(Type.EVICTION_COUNT, ref -> ((CacheReference)ref).cacheStats.evictionCount()));
            parent.more().counter(idPrefix.name("eviction.weight"), idPrefix.tags(), (Object)this, this.func(Type.EVICTION_WEIGHT, ref -> ((CacheReference)ref).cacheStats.evictionWeight()));
            parent.gauge(idPrefix.name("estimated.size"), idPrefix.tags(), (Object)this, this.func(null, ref -> ((CacheReference)ref).estimatedSize));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(Cache<?, ?> cache, Ticker ticker) {
            this.lock.lock();
            try {
                for (CacheReference ref2 : this.cacheRefs) {
                    if (ref2.get() != cache) continue;
                    return;
                }
                this.cacheRefs.add(new CacheReference(cache, ticker));
            }
            finally {
                this.lock.unlock();
            }
            if (cache instanceof LoadingCache && this.hasLoadingCache.compareAndSet(false, true)) {
                String loads = this.idPrefix.name("loads");
                this.parent.more().counter(loads, this.idPrefix.tags("result", "success"), (Object)this, this.func(Type.LOAD_SUCCESS_COUNT, ref -> ((CacheReference)ref).cacheStats.loadSuccessCount()));
                this.parent.more().counter(loads, this.idPrefix.tags("result", "failure"), (Object)this, this.func(Type.LOAD_FAILURE_COUNT, ref -> ((CacheReference)ref).cacheStats.loadFailureCount()));
                this.parent.more().counter(this.idPrefix.name("load.duration"), this.idPrefix.tags(), (Object)this, this.func(Type.TOTAL_LOAD_TIME, ref -> ((CacheReference)ref).cacheStats.totalLoadTime()));
            }
        }

        private ToDoubleFunction<CaffeineMetrics> func(@Nullable Type type, ToDoubleFunction<CacheReference> valueFunction) {
            return value -> {
                double sum = 0.0;
                this.lock.lock();
                try {
                    Iterator<CacheReference> i = this.cacheRefs.iterator();
                    while (i.hasNext()) {
                        CacheReference ref = i.next();
                        boolean garbageCollected = ref.updateCacheStats();
                        if (!garbageCollected) {
                            sum += valueFunction.applyAsDouble(ref);
                            continue;
                        }
                        i.remove();
                        CacheStats stats = ref.cacheStats;
                        int n = Type.HIT_COUNT.ordinal();
                        this.statsForGarbageCollected[n] = this.statsForGarbageCollected[n] + (double)stats.hitCount();
                        int n2 = Type.MISS_COUNT.ordinal();
                        this.statsForGarbageCollected[n2] = this.statsForGarbageCollected[n2] + (double)stats.missCount();
                        int n3 = Type.EVICTION_COUNT.ordinal();
                        this.statsForGarbageCollected[n3] = this.statsForGarbageCollected[n3] + (double)stats.evictionCount();
                        int n4 = Type.EVICTION_WEIGHT.ordinal();
                        this.statsForGarbageCollected[n4] = this.statsForGarbageCollected[n4] + (double)stats.evictionWeight();
                        int n5 = Type.LOAD_SUCCESS_COUNT.ordinal();
                        this.statsForGarbageCollected[n5] = this.statsForGarbageCollected[n5] + (double)stats.loadSuccessCount();
                        int n6 = Type.LOAD_FAILURE_COUNT.ordinal();
                        this.statsForGarbageCollected[n6] = this.statsForGarbageCollected[n6] + (double)stats.loadFailureCount();
                        int n7 = Type.TOTAL_LOAD_TIME.ordinal();
                        this.statsForGarbageCollected[n7] = this.statsForGarbageCollected[n7] + (double)stats.totalLoadTime();
                    }
                    if (type != null) {
                        sum += this.statsForGarbageCollected[type.ordinal()];
                    }
                }
                finally {
                    this.lock.unlock();
                }
                return sum;
            };
        }
    }

    private static final class CacheReference
    extends WeakReference<Cache<?, ?>> {
        private final Ticker ticker;
        private volatile long lastStatsUpdateTime;
        private CacheStats cacheStats = CacheStats.empty();
        private long estimatedSize;

        CacheReference(Cache<?, ?> cache, Ticker ticker) {
            super(Objects.requireNonNull(cache, "cache"));
            this.ticker = Objects.requireNonNull(ticker, "ticker");
            this.updateCacheStats(true);
        }

        boolean updateCacheStats() {
            return this.updateCacheStats(false);
        }

        private boolean updateCacheStats(boolean force) {
            Cache cache = (Cache)this.get();
            if (cache == null) {
                return true;
            }
            long currentTimeNanos = this.ticker.read();
            if (!force && currentTimeNanos - this.lastStatsUpdateTime < UPDATE_INTERVAL_NANOS) {
                return false;
            }
            this.cacheStats = cache.stats();
            this.estimatedSize = cache.estimatedSize();
            this.lastStatsUpdateTime = currentTimeNanos;
            return false;
        }
    }

    static enum Type {
        HIT_COUNT,
        MISS_COUNT,
        EVICTION_COUNT,
        EVICTION_WEIGHT,
        LOAD_SUCCESS_COUNT,
        LOAD_FAILURE_COUNT,
        TOTAL_LOAD_TIME;

        static final int count;

        static {
            count = Type.values().length;
        }
    }
}

