/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Stream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Http2GoAwayHandler {
    private static final Logger logger = LoggerFactory.getLogger(Http2GoAwayHandler.class);
    private static final ByteBuf ERROR_FLUSHING = Unpooled.copiedBuffer((CharSequence)"Error flushing", (Charset)StandardCharsets.UTF_8);
    private static final int ERROR_FLUSHING_LEN = ERROR_FLUSHING.readableBytes();
    private static final long CODE_NO_ERROR = Http2Error.NO_ERROR.code();
    private static final long CODE_INTERNAL_ERROR = Http2Error.INTERNAL_ERROR.code();
    private boolean goAwaySent;
    private long goAwayReceived = -1L;

    public boolean sentGoAway() {
        return this.goAwaySent;
    }

    public boolean receivedGoAway() {
        return this.goAwayReceived >= 0L;
    }

    public boolean receivedErrorGoAway() {
        return this.goAwayReceived > Http2Error.NO_ERROR.code();
    }

    public void onGoAwaySent(Channel channel, int lastStreamId, long errorCode, ByteBuf debugData) {
        this.goAwaySent = true;
        Http2GoAwayHandler.onGoAway(channel, "Sent", lastStreamId, errorCode, debugData);
    }

    public void onGoAwayReceived(Channel channel, int lastStreamId, long errorCode, ByteBuf debugData) {
        this.goAwayReceived = errorCode;
        Http2GoAwayHandler.onGoAway(channel, "Received", lastStreamId, errorCode, debugData);
        if (lastStreamId == Integer.MAX_VALUE && errorCode == Http2Error.NO_ERROR.code()) {
            return;
        }
        if (!this.goAwaySent) {
            channel.close();
        }
    }

    private static void onGoAway(Channel channel, String sentOrReceived, int lastStreamId, long errorCode, ByteBuf debugData) {
        if (errorCode == CODE_NO_ERROR) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} {} a GOAWAY frame: lastStreamId={}, errorCode=NO_ERROR(0)", new Object[]{channel, sentOrReceived, lastStreamId});
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            String logFormat = "{} {} a GOAWAY frame: lastStreamId={}, errorCode={}, debugData=\"{}\"";
            if (Http2GoAwayHandler.isExpected(errorCode, debugData)) {
                logger.debug("{} {} a GOAWAY frame: lastStreamId={}, errorCode={}, debugData=\"{}\"", new Object[]{channel, sentOrReceived, lastStreamId, Http2GoAwayHandler.errorStr(errorCode), debugData.toString(StandardCharsets.UTF_8)});
            } else if (logger.isWarnEnabled()) {
                logger.warn("{} {} a GOAWAY frame: lastStreamId={}, errorCode={}, debugData=\"{}\"", new Object[]{channel, sentOrReceived, lastStreamId, Http2GoAwayHandler.errorStr(errorCode), debugData.toString(StandardCharsets.UTF_8)});
            }
        }
    }

    static boolean isExpected(long errorCode, ByteBuf debugData) {
        return errorCode == CODE_INTERNAL_ERROR && ByteBufUtil.equals((ByteBuf)debugData, (int)debugData.readerIndex(), (ByteBuf)ERROR_FLUSHING, (int)0, (int)ERROR_FLUSHING_LEN);
    }

    private static String errorStr(long errorCode) {
        Http2Error error = Http2Error.valueOf((long)errorCode);
        return error != null ? error.toString() + '(' + errorCode + ')' : "UNKNOWN(" + errorCode + ')';
    }

    public void onStreamClosed(Channel channel, Http2Stream stream) {
        if (stream.id() == 1) {
            logger.debug("{} HTTP/2 upgrade stream closed: {}", (Object)channel, (Object)stream.state());
        }
    }
}

