/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.DnsTimeoutException;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.internal.common.util.StringUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsResponseCode;
import io.netty.resolver.dns.DnsNameResolverTimeoutException;
import io.netty.resolver.dns.DnsQueryLifecycleObserver;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.stream.Collectors;

final class DefaultDnsQueryLifecycleObserver
implements DnsQueryLifecycleObserver {
    private static final String NAME_TAG = "name";
    private static final String RESULT_TAG = "result";
    private static final String SERVERS_TAG = "servers";
    private static final String SERVER_TAG = "server";
    private static final String CODE_TAG = "code";
    private static final String CAUSE_TAG = "cause";
    private static final String CNAME_TAG = "cname";
    private static final String NXDOMAIN_EXCEPTION_MESSAGE = "NXDOMAIN";
    private static final String CNAME_EXCEPTION_MESSAGE = "CNAME";
    private static final String NO_MATCHING_EXCEPTION_MESSAGE = "No matching record";
    private static final String UNRECOGNIZED_TYPE_EXCEPTION_MESSAGE = "unrecognized";
    private static final String NO_NS_RETURNED_EXCEPTION_MESSAGE = "No name servers";
    private static final Tag TAG_SUCCESS = Tag.of((String)"result", (String)"success");
    private static final Tag TAG_FAILURE = Tag.of((String)"result", (String)"failure");
    private final MeterRegistry meterRegistry;
    private final MeterIdPrefix meterIdPrefix;
    private final Tag nameTag;
    private final String meterIdPrefixWritten;
    private final String meterIdPrefixCancelled;
    private final String meterIdPrefixRedirected;
    private final String meterIdPrefixCnamed;
    private final String meterIdPrefixNoAnswer;

    DefaultDnsQueryLifecycleObserver(MeterRegistry meterRegistry, DnsQuestion question, MeterIdPrefix prefix) {
        this.meterRegistry = meterRegistry;
        this.meterIdPrefix = prefix;
        this.nameTag = Tag.of((String)NAME_TAG, (String)question.name());
        this.meterIdPrefixWritten = this.meterIdPrefix.name() + ".written";
        this.meterIdPrefixCancelled = this.meterIdPrefix.name() + ".cancelled";
        this.meterIdPrefixRedirected = this.meterIdPrefix.name() + ".redirected";
        this.meterIdPrefixCnamed = this.meterIdPrefix.name() + ".cnamed";
        this.meterIdPrefixNoAnswer = this.meterIdPrefix.name() + ".noanswer";
    }

    public void queryWritten(InetSocketAddress dnsServerAddress, ChannelFuture future) {
        ImmutableList<Tag> tags = ImmutableList.of(this.nameTag, Tag.of((String)SERVER_TAG, (String)DefaultDnsQueryLifecycleObserver.getHostAddress(dnsServerAddress)));
        this.meterRegistry.counter(this.meterIdPrefixWritten, tags).increment();
    }

    public void queryCancelled(int queriesRemaining) {
        this.meterRegistry.counter(this.meterIdPrefixCancelled, (Iterable)Tags.of((Tag[])new Tag[]{this.nameTag})).increment();
    }

    public DnsQueryLifecycleObserver queryRedirected(List<InetSocketAddress> nameServers) {
        String servers = nameServers.stream().map(DefaultDnsQueryLifecycleObserver::getHostAddress).collect(Collectors.joining(","));
        ImmutableList<Tag> tags = ImmutableList.of(this.nameTag, Tag.of((String)SERVERS_TAG, (String)servers));
        this.meterRegistry.counter(this.meterIdPrefixRedirected, tags).increment();
        return this;
    }

    private static String getHostAddress(InetSocketAddress addr) {
        String value = addr.getAddress().getHostAddress();
        int percentIdx = value.indexOf(37);
        return percentIdx < 0 ? value : value.substring(0, percentIdx);
    }

    public DnsQueryLifecycleObserver queryCNAMEd(DnsQuestion cnameQuestion) {
        ImmutableList<Tag> tags = ImmutableList.of(this.nameTag, Tag.of((String)CNAME_TAG, (String)cnameQuestion.name()));
        this.meterRegistry.counter(this.meterIdPrefixCnamed, tags).increment();
        return this;
    }

    public DnsQueryLifecycleObserver queryNoAnswer(DnsResponseCode code) {
        ImmutableList<Tag> tags = ImmutableList.of(this.nameTag, Tag.of((String)CODE_TAG, (String)StringUtil.toString(code.intValue())));
        this.meterRegistry.counter(this.meterIdPrefixNoAnswer, tags).increment();
        return this;
    }

    public void queryFailed(Throwable cause) {
        String message = cause.getMessage();
        if (message == null || !message.contains(NO_NS_RETURNED_EXCEPTION_MESSAGE)) {
            ImmutableList<Tag> tags = ImmutableList.of(this.nameTag, TAG_FAILURE, Tag.of((String)CAUSE_TAG, (String)DefaultDnsQueryLifecycleObserver.determineDnsExceptionTag((Throwable)cause, (String)message).lowerCasedName));
            this.meterRegistry.counter(this.meterIdPrefix.name(), tags).increment();
        }
    }

    public void querySucceed() {
        ImmutableList<Tag> tags = ImmutableList.of(this.nameTag, TAG_SUCCESS, Tag.of((String)CAUSE_TAG, (String)"none"));
        this.meterRegistry.counter(this.meterIdPrefix.name(), tags).increment();
    }

    private static DnsExceptionTypes determineDnsExceptionTag(Throwable cause, @Nullable String message) {
        if (cause instanceof DnsTimeoutException) {
            return DnsExceptionTypes.SERVER_TIMEOUT;
        }
        if (cause instanceof DnsNameResolverTimeoutException) {
            return DnsExceptionTypes.RESOLVER_TIMEOUT;
        }
        if (message == null) {
            return DnsExceptionTypes.OTHERS;
        }
        if (message.contains(NXDOMAIN_EXCEPTION_MESSAGE)) {
            return DnsExceptionTypes.NX_DOMAIN;
        }
        if (message.contains(CNAME_EXCEPTION_MESSAGE)) {
            return DnsExceptionTypes.CNAME_NOT_FOUND;
        }
        if (message.contains(NO_MATCHING_EXCEPTION_MESSAGE)) {
            return DnsExceptionTypes.NO_MATCHING_RECORD;
        }
        if (message.contains(UNRECOGNIZED_TYPE_EXCEPTION_MESSAGE)) {
            return DnsExceptionTypes.UNRECOGNIZED_TYPE;
        }
        return DnsExceptionTypes.OTHERS;
    }

    private static enum DnsExceptionTypes {
        NX_DOMAIN,
        CNAME_NOT_FOUND,
        NO_MATCHING_RECORD,
        UNRECOGNIZED_TYPE,
        OTHERS,
        SERVER_TIMEOUT,
        RESOLVER_TIMEOUT;

        final String lowerCasedName = Ascii.toLowerCase(this.name());
    }
}

