/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridDerivation;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.coverage.internal.RangeArgument;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.storage.AbstractGridCoverageResource;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.RasterLoadingStrategy;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.aggregate.AggregatedResource;
import org.apache.sis.storage.aggregate.ConcatenatedGridCoverage;
import org.apache.sis.storage.aggregate.GridSliceLocator;
import org.apache.sis.storage.aggregate.GroupAggregate;
import org.apache.sis.storage.aggregate.MergeStrategy;
import org.apache.sis.storage.base.MemoryGridResource;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Localized;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.internal.UnmodifiableArrayList;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.GenericName;

final class ConcatenatedGridResource
extends AbstractGridCoverageResource
implements AggregatedResource {
    private GenericName identifier;
    private String name;
    private final GridGeometry gridGeometry;
    private final List<SampleDimension> sampleDimensions;
    final boolean isConverted;
    private final GridCoverageResource[] slices;
    private int[] deferredLoading;
    final GridSliceLocator locator;
    final MergeStrategy strategy;
    private ImmutableEnvelope envelope;
    private boolean envelopeIsEvaluated;
    private double[][] resolutions;

    ConcatenatedGridResource(String name, StoreListeners listeners, GridGeometry domain, List<SampleDimension> ranges, GridCoverageResource[] slices, GridSliceLocator locator, MergeStrategy strategy) {
        super(listeners, false);
        this.name = name;
        this.gridGeometry = domain;
        this.sampleDimensions = ranges;
        this.slices = slices;
        this.locator = locator;
        this.strategy = strategy;
        this.deferredLoading = new int[Numerics.ceilDiv((int)slices.length, (int)32)];
        for (SampleDimension sd : ranges) {
            if (sd.forConvertedValues(true) == sd) continue;
            this.isConverted = false;
            return;
        }
        this.isConverted = true;
    }

    private ConcatenatedGridResource(ConcatenatedGridResource source, MergeStrategy strategy) {
        super(source.listeners, true);
        this.name = source.name;
        this.gridGeometry = source.gridGeometry;
        this.sampleDimensions = source.sampleDimensions;
        this.isConverted = source.isConverted;
        this.slices = source.slices;
        this.deferredLoading = source.deferredLoading;
        this.locator = source.locator;
        this.envelope = source.envelope;
        this.envelopeIsEvaluated = source.envelopeIsEvaluated;
        this.resolutions = source.resolutions;
        this.strategy = strategy;
    }

    @Override
    public final synchronized Resource apply(MergeStrategy s) {
        if (Objects.equals(this.strategy, s)) {
            return this;
        }
        return new ConcatenatedGridResource(this, s);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setIdentifier(GenericName identifier) {
        this.identifier = identifier;
    }

    @Override
    public Optional<GenericName> getIdentifier() {
        return Optional.ofNullable(this.identifier);
    }

    @Override
    protected Metadata createMetadata() throws DataStoreException {
        MetadataBuilder builder = new MetadataBuilder();
        builder.addTitle(this.name);
        builder.addDefaultMetadata(this, this.listeners);
        return builder.build();
    }

    @Override
    public final GridGeometry getGridGeometry() {
        return this.gridGeometry;
    }

    @Override
    public final List<SampleDimension> getSampleDimensions() {
        return this.sampleDimensions;
    }

    @Override
    public synchronized Optional<Envelope> getEnvelope() throws DataStoreException {
        if (!this.envelopeIsEvaluated) {
            try {
                this.envelope = GroupAggregate.unionOfComponents(this.slices);
            }
            catch (TransformException e) {
                this.listeners.warning((Exception)((Object)e));
            }
            this.envelopeIsEvaluated = true;
        }
        return Optional.ofNullable(this.envelope);
    }

    @Override
    public synchronized List<double[]> getResolutions() throws DataStoreException {
        if (this.resolutions == null) {
            this.resolutions = ConcatenatedGridResource.commonResolutions(this.slices);
        }
        return UnmodifiableArrayList.wrap((Object[])this.resolutions);
    }

    static double[][] commonResolutions(GridCoverageResource[] sources) throws DataStoreException {
        int count = 0;
        double[][] resolutions = null;
        for (GridCoverageResource slice : sources) {
            double[][] sr = (double[][])slice.getResolutions().toArray(x$0 -> new double[x$0][]);
            if (sr == null) continue;
            if (resolutions == null) {
                resolutions = sr;
                count = sr.length;
                continue;
            }
            int retained = 0;
            block1: for (int i = 0; i < count; ++i) {
                double[] r = resolutions[i];
                for (int j = 0; j < sr.length; ++j) {
                    if (!Arrays.equals(r, sr[j])) continue;
                    resolutions[retained++] = r;
                    sr[j] = null;
                    continue block1;
                }
            }
            count = retained;
            if (count == 0) break;
        }
        return (double[][])ArraysExt.resize(resolutions, (int)count);
    }

    @Override
    public synchronized RasterLoadingStrategy getLoadingStrategy() throws DataStoreException {
        RasterLoadingStrategy conservative = RasterLoadingStrategy.AT_GET_TILE_TIME;
        for (int i = 0; i < this.slices.length; ++i) {
            GridCoverageResource slice = this.slices[i];
            RasterLoadingStrategy s = slice.getLoadingStrategy();
            if (s == null || s.ordinal() == 0) {
                RasterLoadingStrategy rasterLoadingStrategy = s = this.isDeferred(i) ? RasterLoadingStrategy.AT_RENDER_TIME : RasterLoadingStrategy.AT_READ_TIME;
            }
            if (s.ordinal() >= conservative.ordinal()) continue;
            conservative = s;
            if (s.ordinal() == 0) break;
        }
        return conservative;
    }

    @Override
    public synchronized boolean setLoadingStrategy(RasterLoadingStrategy strategy) throws DataStoreException {
        boolean deferred = strategy.ordinal() != 0;
        int[] newValues = new int[this.deferredLoading.length];
        boolean accepted = true;
        for (int i = 0; i < this.slices.length; ++i) {
            GridCoverageResource slice = this.slices[i];
            if (slice.setLoadingStrategy(strategy)) continue;
            if (deferred) {
                int n = i >>> 5;
                newValues[n] = newValues[n] | 1 << i;
            }
            accepted = false;
        }
        if (!Arrays.equals(this.deferredLoading, newValues)) {
            this.deferredLoading = newValues;
        }
        return accepted;
    }

    private boolean isDeferred(int i) {
        return (this.deferredLoading[i >>> 5] & 1 << i) != 0;
    }

    @Override
    public GridCoverage read(GridGeometry domain, int ... ranges) throws DataStoreException {
        if (ranges != null) {
            ranges = RangeArgument.validate((int)this.sampleDimensions.size(), (int[])ranges, (Localized)this.listeners).getSelectedBands();
        }
        int lower = 0;
        int upper = this.slices.length;
        if (domain != null) {
            GridDerivation subgrid = this.gridGeometry.derive().rounding(GridRoundingMode.ENCLOSING).subgrid(domain);
            domain = subgrid.build();
            GridExtent sliceExtent = subgrid.getIntersection();
            upper = this.locator.getUpper(sliceExtent, lower, upper);
            lower = this.locator.getLower(sliceExtent, lower, upper);
        }
        int count = upper - lower;
        Object[] coverages = new Object[count];
        GridGeometry[] geometries = new GridGeometry[count];
        int[] deferred = null;
        for (int i = 0; i < count; ++i) {
            GridCoverage coverage;
            int j = lower + i;
            GridCoverageResource slice = this.slices[j];
            if (slice instanceof MemoryGridResource) {
                coverage = ((MemoryGridResource)slice).coverage;
                coverages[i] = coverage;
                geometries[i] = coverage.getGridGeometry();
                continue;
            }
            if (!this.isDeferred(j) || count <= 1) {
                coverage = slice.read(domain, ranges);
                coverages[i] = coverage;
                geometries[i] = coverage.getGridGeometry();
                continue;
            }
            coverages[i] = slice;
            geometries[i] = slice.getGridGeometry();
            if (deferred == null) {
                deferred = new int[Numerics.ceilDiv((int)count, (int)32)];
            }
            int n = i >>> 5;
            deferred[n] = deferred[n] | 1 << i;
        }
        if (count == 1) {
            return (GridCoverage)coverages[0];
        }
        if (Arrays.equals(deferred, this.deferredLoading)) {
            deferred = this.deferredLoading;
        }
        GridGeometry union = this.locator.union(this.gridGeometry, Arrays.asList(geometries), GridGeometry::getExtent);
        return new ConcatenatedGridCoverage(this, union, coverages, lower, deferred, domain, ranges);
    }
}

