/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.rtree;

import java.util.List;
import java.util.Map;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.rtree.RTreeIndexExtension;
import mil.nga.geopackage.extension.rtree.RTreeIndexTableRow;
import mil.nga.geopackage.features.user.FeatureDao;
import mil.nga.geopackage.features.user.FeatureResultSet;
import mil.nga.geopackage.features.user.FeatureRow;
import mil.nga.geopackage.features.user.FeatureTable;
import mil.nga.geopackage.io.GeoPackageProgress;
import mil.nga.geopackage.user.custom.UserCustomDao;
import mil.nga.geopackage.user.custom.UserCustomResultSet;
import mil.nga.geopackage.user.custom.UserCustomRow;
import mil.nga.geopackage.user.custom.UserCustomTable;
import mil.nga.proj.Projection;
import mil.nga.sf.GeometryEnvelope;
import mil.nga.sf.proj.GeometryTransform;

public class RTreeIndexTableDao
extends UserCustomDao {
    private final RTreeIndexExtension rTree;
    private final FeatureDao featureDao;
    protected GeoPackageProgress progress;
    protected double tolerance = 1.0E-14;

    RTreeIndexTableDao(RTreeIndexExtension rTree, UserCustomDao dao, FeatureDao featureDao) {
        super(dao, (UserCustomTable)dao.getTable());
        this.rTree = rTree;
        this.featureDao = featureDao;
        this.projection = featureDao.getProjection();
    }

    public void setProgress(GeoPackageProgress progress) {
        this.progress = progress;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public boolean has() {
        return this.rTree.has((FeatureTable)this.featureDao.getTable());
    }

    public Extensions create() {
        Extensions extension = null;
        if (!this.has()) {
            extension = this.rTree.create((FeatureTable)this.featureDao.getTable());
            if (this.progress != null) {
                this.progress.addProgress(this.count());
            }
        }
        return extension;
    }

    public void delete() {
        this.rTree.delete((FeatureTable)this.featureDao.getTable());
    }

    public RTreeIndexExtension getRTreeIndexExtension() {
        return this.rTree;
    }

    public FeatureDao getFeatureDao() {
        return this.featureDao;
    }

    public RTreeIndexTableRow getRow(UserCustomResultSet resultSet) {
        return this.getRow((UserCustomRow)resultSet.getRow());
    }

    public RTreeIndexTableRow getRow(UserCustomRow row) {
        return new RTreeIndexTableRow(row);
    }

    public FeatureRow getFeatureRow(RTreeIndexTableRow row) {
        return (FeatureRow)this.featureDao.queryForIdRow(row.getId());
    }

    public FeatureRow getFeatureRow(UserCustomResultSet resultSet) {
        RTreeIndexTableRow row = this.getRow(resultSet);
        return this.getFeatureRow(row);
    }

    public FeatureRow getFeatureRow(UserCustomRow row) {
        return this.getFeatureRow(this.getRow(row));
    }

    public UserCustomResultSet query(boolean distinct, String[] columns) {
        this.validateRTree();
        return (UserCustomResultSet)super.query(distinct, columns);
    }

    public UserCustomResultSet query(boolean distinct, String[] columns, String[] columnsAs) {
        this.validateRTree();
        return (UserCustomResultSet)super.query(distinct, columns, columnsAs);
    }

    public UserCustomResultSet query(boolean distinct, String[] columns, String where, String[] whereArgs) {
        this.validateRTree();
        return (UserCustomResultSet)super.query(distinct, columns, where, whereArgs);
    }

    public UserCustomResultSet query(boolean distinct, String[] columns, String where, String[] whereArgs, String groupBy, String having, String orderBy) {
        this.validateRTree();
        return (UserCustomResultSet)super.query(distinct, columns, where, whereArgs, groupBy, having, orderBy);
    }

    public UserCustomResultSet query(boolean distinct, String[] columns, String where, String[] whereArgs, String groupBy, String having, String orderBy, String limit) {
        this.validateRTree();
        return (UserCustomResultSet)super.query(distinct, columns, where, whereArgs, groupBy, having, orderBy, limit);
    }

    public int count(boolean distinct, String column, String where, String[] args) {
        this.validateRTree();
        return super.count(distinct, column, where, args);
    }

    public FeatureResultSet queryFeatures() {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryIn(this.queryIdsSQL());
    }

    public FeatureResultSet queryFeatures(boolean distinct) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryIn(distinct, this.queryIdsSQL());
    }

    public FeatureResultSet queryFeatures(String[] columns) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryIn(columns, this.queryIdsSQL());
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryIn(distinct, columns, this.queryIdsSQL());
    }

    public int countFeatures() {
        this.validateRTree();
        return this.featureDao.countIn(this.queryIdsSQL());
    }

    public int countColumnFeatures(String column) {
        this.validateRTree();
        return this.featureDao.countIn(column, this.queryIdsSQL());
    }

    public int countFeatures(boolean distinct, String column) {
        this.validateRTree();
        return this.featureDao.countIn(distinct, column, this.queryIdsSQL());
    }

    public FeatureResultSet queryFeatures(Map<String, Object> fieldValues) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryIn(this.queryIdsSQL(), fieldValues);
    }

    public FeatureResultSet queryFeatures(boolean distinct, Map<String, Object> fieldValues) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryIn(distinct, this.queryIdsSQL(), fieldValues);
    }

    public FeatureResultSet queryFeatures(String[] columns, Map<String, Object> fieldValues) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryIn(columns, this.queryIdsSQL(), fieldValues);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, Map<String, Object> fieldValues) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryIn(distinct, columns, this.queryIdsSQL(), fieldValues);
    }

    public int countFeatures(Map<String, Object> fieldValues) {
        this.validateRTree();
        return this.featureDao.countIn(this.queryIdsSQL(), fieldValues);
    }

    public int countFeatures(String column, Map<String, Object> fieldValues) {
        this.validateRTree();
        return this.featureDao.countIn(column, this.queryIdsSQL(), fieldValues);
    }

    public int countFeatures(boolean distinct, String column, Map<String, Object> fieldValues) {
        this.validateRTree();
        return this.featureDao.countIn(distinct, column, this.queryIdsSQL(), fieldValues);
    }

    public FeatureResultSet queryFeatures(String where) {
        return this.queryFeatures(false, where);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String where) {
        return this.queryFeatures(distinct, where, null);
    }

    public FeatureResultSet queryFeatures(String[] columns, String where) {
        return this.queryFeatures(false, columns, where);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, String where) {
        return this.queryFeatures(distinct, columns, where, null);
    }

    public int countFeatures(String where) {
        return this.countFeatures(false, null, where);
    }

    public int countFeatures(String column, String where) {
        return this.countFeatures(false, column, where);
    }

    public int countFeatures(boolean distinct, String column, String where) {
        return this.countFeatures(distinct, column, where, null);
    }

    public FeatureResultSet queryFeatures(String where, String[] whereArgs) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryIn(this.queryIdsSQL(), where, whereArgs);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String where, String[] whereArgs) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryIn(distinct, this.queryIdsSQL(), where, whereArgs);
    }

    public FeatureResultSet queryFeatures(String[] columns, String where, String[] whereArgs) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryIn(columns, this.queryIdsSQL(), where, whereArgs);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, String where, String[] whereArgs) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryIn(distinct, columns, this.queryIdsSQL(), where, whereArgs);
    }

    public int countFeatures(String where, String[] whereArgs) {
        this.validateRTree();
        return this.featureDao.countIn(this.queryIdsSQL(), where, whereArgs);
    }

    public int countFeatures(String column, String where, String[] whereArgs) {
        this.validateRTree();
        return this.featureDao.countIn(column, this.queryIdsSQL(), where, whereArgs);
    }

    public int countFeatures(boolean distinct, String column, String where, String[] whereArgs) {
        this.validateRTree();
        return this.featureDao.countIn(distinct, column, this.queryIdsSQL(), where, whereArgs);
    }

    @Override
    public BoundingBox getBoundingBox() {
        List values = this.querySingleRowTypedResults("SELECT MIN(minx), MIN(miny), MAX(maxx), MAX(maxy) FROM " + CoreSQLUtils.quoteWrap((String)this.getTableName()), null);
        BoundingBox boundingBox = new BoundingBox(((Double)values.get(0)).doubleValue(), ((Double)values.get(1)).doubleValue(), ((Double)values.get(2)).doubleValue(), ((Double)values.get(3)).doubleValue());
        return boundingBox;
    }

    @Override
    public BoundingBox getBoundingBox(Projection projection) {
        BoundingBox boundingBox = this.getBoundingBox();
        if (boundingBox != null && projection != null) {
            GeometryTransform projectionTransform = GeometryTransform.create((Projection)this.featureDao.getProjection(), (Projection)projection);
            boundingBox = boundingBox.transform(projectionTransform);
        }
        return boundingBox;
    }

    public UserCustomResultSet query(BoundingBox boundingBox) {
        return this.query(false, boundingBox);
    }

    public UserCustomResultSet query(boolean distinct, BoundingBox boundingBox) {
        return this.query(distinct, boundingBox.buildEnvelope());
    }

    public UserCustomResultSet query(String[] columns, BoundingBox boundingBox) {
        return this.query(false, columns, boundingBox);
    }

    public UserCustomResultSet query(boolean distinct, String[] columns, BoundingBox boundingBox) {
        return this.query(distinct, columns, boundingBox.buildEnvelope());
    }

    public int count(BoundingBox boundingBox) {
        return this.count(false, null, boundingBox);
    }

    public int count(String column, BoundingBox boundingBox) {
        return this.count(false, column, boundingBox);
    }

    public int count(boolean distinct, String column, BoundingBox boundingBox) {
        return this.count(distinct, column, boundingBox.buildEnvelope());
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox) {
        return this.queryFeatures(false, boundingBox);
    }

    public FeatureResultSet queryFeatures(boolean distinct, BoundingBox boundingBox) {
        return this.queryFeatures(distinct, boundingBox.buildEnvelope());
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox) {
        return this.queryFeatures(false, columns, boundingBox);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, BoundingBox boundingBox) {
        return this.queryFeatures(distinct, columns, boundingBox.buildEnvelope());
    }

    public int countFeatures(BoundingBox boundingBox) {
        return this.countFeatures(false, null, boundingBox);
    }

    public int countFeatures(String column, BoundingBox boundingBox) {
        return this.countFeatures(false, column, boundingBox);
    }

    public int countFeatures(boolean distinct, String column, BoundingBox boundingBox) {
        return this.countFeatures(distinct, column, boundingBox.buildEnvelope());
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.queryFeatures(false, boundingBox, fieldValues);
    }

    public FeatureResultSet queryFeatures(boolean distinct, BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.queryFeatures(distinct, boundingBox.buildEnvelope(), fieldValues);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.queryFeatures(false, columns, boundingBox, fieldValues);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.queryFeatures(distinct, columns, boundingBox.buildEnvelope(), fieldValues);
    }

    public int countFeatures(BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.countFeatures(false, null, boundingBox, fieldValues);
    }

    public int countFeatures(String column, BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.countFeatures(false, column, boundingBox, fieldValues);
    }

    public int countFeatures(boolean distinct, String column, BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.countFeatures(distinct, column, boundingBox.buildEnvelope(), fieldValues);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, String where) {
        return this.queryFeatures(false, boundingBox, where);
    }

    public FeatureResultSet queryFeatures(boolean distinct, BoundingBox boundingBox, String where) {
        return this.queryFeatures(distinct, boundingBox, where, null);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, String where) {
        return this.queryFeatures(false, columns, boundingBox, where);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, BoundingBox boundingBox, String where) {
        return this.queryFeatures(distinct, columns, boundingBox, where, null);
    }

    public int countFeatures(BoundingBox boundingBox, String where) {
        return this.countFeatures(false, null, boundingBox, where);
    }

    public int countFeatures(String column, BoundingBox boundingBox, String where) {
        return this.countFeatures(false, column, boundingBox, where);
    }

    public int countFeatures(boolean distinct, String column, BoundingBox boundingBox, String where) {
        return this.countFeatures(distinct, column, boundingBox, where, null);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.queryFeatures(false, boundingBox, where, whereArgs);
    }

    public FeatureResultSet queryFeatures(boolean distinct, BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.queryFeatures(distinct, boundingBox.buildEnvelope(), where, whereArgs);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.queryFeatures(false, columns, boundingBox, where, whereArgs);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.queryFeatures(distinct, columns, boundingBox.buildEnvelope(), where, whereArgs);
    }

    public int countFeatures(BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.countFeatures(false, null, boundingBox, where, whereArgs);
    }

    public int countFeatures(String column, BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.countFeatures(false, column, boundingBox, where, whereArgs);
    }

    public int countFeatures(boolean distinct, String column, BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.countFeatures(distinct, column, boundingBox.buildEnvelope(), where, whereArgs);
    }

    public UserCustomResultSet query(BoundingBox boundingBox, Projection projection) {
        return this.query(false, boundingBox, projection);
    }

    public UserCustomResultSet query(boolean distinct, BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.query(distinct, featureBoundingBox);
    }

    public UserCustomResultSet query(String[] columns, BoundingBox boundingBox, Projection projection) {
        return this.query(false, columns, boundingBox, projection);
    }

    public UserCustomResultSet query(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.query(distinct, columns, featureBoundingBox);
    }

    public int count(BoundingBox boundingBox, Projection projection) {
        return this.count(false, null, boundingBox, projection);
    }

    public int count(String column, BoundingBox boundingBox, Projection projection) {
        return this.count(false, column, boundingBox, projection);
    }

    public int count(boolean distinct, String column, BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.count(distinct, column, featureBoundingBox);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, Projection projection) {
        return this.queryFeatures(false, boundingBox, projection);
    }

    public FeatureResultSet queryFeatures(boolean distinct, BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeatures(distinct, featureBoundingBox);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, Projection projection) {
        return this.queryFeatures(false, columns, boundingBox, projection);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeatures(distinct, columns, featureBoundingBox);
    }

    public int countFeatures(BoundingBox boundingBox, Projection projection) {
        return this.countFeatures(false, null, boundingBox, projection);
    }

    public int countFeatures(String column, BoundingBox boundingBox, Projection projection) {
        return this.countFeatures(false, column, boundingBox, projection);
    }

    public int countFeatures(boolean distinct, String column, BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.countFeatures(distinct, column, featureBoundingBox);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        return this.queryFeatures(false, boundingBox, projection, fieldValues);
    }

    public FeatureResultSet queryFeatures(boolean distinct, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeatures(distinct, featureBoundingBox, fieldValues);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        return this.queryFeatures(false, columns, boundingBox, projection, fieldValues);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeatures(distinct, columns, featureBoundingBox, fieldValues);
    }

    public int countFeatures(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        return this.countFeatures(false, null, boundingBox, projection, fieldValues);
    }

    public int countFeatures(String column, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        return this.countFeatures(false, column, boundingBox, projection, fieldValues);
    }

    public int countFeatures(boolean distinct, String column, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.countFeatures(distinct, column, featureBoundingBox, fieldValues);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, Projection projection, String where) {
        return this.queryFeatures(false, boundingBox, projection, where);
    }

    public FeatureResultSet queryFeatures(boolean distinct, BoundingBox boundingBox, Projection projection, String where) {
        return this.queryFeatures(distinct, boundingBox, projection, where, null);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, Projection projection, String where) {
        return this.queryFeatures(false, columns, boundingBox, projection, where);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where) {
        return this.queryFeatures(distinct, columns, boundingBox, projection, where, null);
    }

    public int countFeatures(BoundingBox boundingBox, Projection projection, String where) {
        return this.countFeatures(false, null, boundingBox, projection, where);
    }

    public int countFeatures(String column, BoundingBox boundingBox, Projection projection, String where) {
        return this.countFeatures(false, column, boundingBox, projection, where);
    }

    public int countFeatures(boolean distinct, String column, BoundingBox boundingBox, Projection projection, String where) {
        return this.countFeatures(distinct, column, boundingBox, projection, where, null);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        return this.queryFeatures(false, boundingBox, projection, where, whereArgs);
    }

    public FeatureResultSet queryFeatures(boolean distinct, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeatures(distinct, featureBoundingBox, where, whereArgs);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        return this.queryFeatures(false, columns, boundingBox, projection, where, whereArgs);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeatures(distinct, columns, featureBoundingBox, where, whereArgs);
    }

    public int countFeatures(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        return this.countFeatures(false, null, boundingBox, projection, where, whereArgs);
    }

    public int countFeatures(String column, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        return this.countFeatures(false, column, boundingBox, projection, where, whereArgs);
    }

    public int countFeatures(boolean distinct, String column, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.countFeatures(distinct, column, featureBoundingBox, where, whereArgs);
    }

    public UserCustomResultSet query(GeometryEnvelope envelope) {
        return this.query(false, envelope);
    }

    public UserCustomResultSet query(boolean distinct, GeometryEnvelope envelope) {
        return this.query(distinct, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public UserCustomResultSet query(String[] columns, GeometryEnvelope envelope) {
        return this.query(false, columns, envelope);
    }

    public UserCustomResultSet query(boolean distinct, String[] columns, GeometryEnvelope envelope) {
        return this.query(distinct, columns, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public int count(GeometryEnvelope envelope) {
        return this.count(false, null, envelope);
    }

    public int count(String column, GeometryEnvelope envelope) {
        return this.count(false, column, envelope);
    }

    public int count(boolean distinct, String column, GeometryEnvelope envelope) {
        return this.count(distinct, column, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public FeatureResultSet queryFeatures(GeometryEnvelope envelope) {
        return this.queryFeatures(false, envelope);
    }

    public FeatureResultSet queryFeatures(boolean distinct, GeometryEnvelope envelope) {
        return this.queryFeatures(distinct, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public FeatureResultSet queryFeatures(String[] columns, GeometryEnvelope envelope) {
        return this.queryFeatures(false, columns, envelope);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, GeometryEnvelope envelope) {
        return this.queryFeatures(distinct, columns, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public int countFeatures(GeometryEnvelope envelope) {
        return this.countFeatures(false, null, envelope);
    }

    public int countFeatures(String column, GeometryEnvelope envelope) {
        return this.countFeatures(false, column, envelope);
    }

    public int countFeatures(boolean distinct, String column, GeometryEnvelope envelope) {
        return this.countFeatures(distinct, column, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public FeatureResultSet queryFeatures(GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.queryFeatures(false, envelope, fieldValues);
    }

    public FeatureResultSet queryFeatures(boolean distinct, GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.queryFeatures(distinct, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), fieldValues);
    }

    public FeatureResultSet queryFeatures(String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.queryFeatures(false, columns, envelope, fieldValues);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.queryFeatures(distinct, columns, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), fieldValues);
    }

    public int countFeatures(GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.countFeatures(false, null, envelope, fieldValues);
    }

    public int countFeatures(String column, GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.countFeatures(false, column, envelope, fieldValues);
    }

    public int countFeatures(boolean distinct, String column, GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.countFeatures(distinct, column, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), fieldValues);
    }

    public FeatureResultSet queryFeatures(GeometryEnvelope envelope, String where) {
        return this.queryFeatures(false, envelope, where);
    }

    public FeatureResultSet queryFeatures(boolean distinct, GeometryEnvelope envelope, String where) {
        return this.queryFeatures(distinct, envelope, where, null);
    }

    public FeatureResultSet queryFeatures(String[] columns, GeometryEnvelope envelope, String where) {
        return this.queryFeatures(false, columns, envelope, where);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, GeometryEnvelope envelope, String where) {
        return this.queryFeatures(distinct, columns, envelope, where, null);
    }

    public int countFeatures(GeometryEnvelope envelope, String where) {
        return this.countFeatures(false, null, envelope, where);
    }

    public int countFeatures(String column, GeometryEnvelope envelope, String where) {
        return this.countFeatures(false, column, envelope, where);
    }

    public int countFeatures(boolean distinct, String column, GeometryEnvelope envelope, String where) {
        return this.countFeatures(distinct, column, envelope, where, null);
    }

    public FeatureResultSet queryFeatures(GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.queryFeatures(false, envelope, where, whereArgs);
    }

    public FeatureResultSet queryFeatures(boolean distinct, GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.queryFeatures(distinct, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), where, whereArgs);
    }

    public FeatureResultSet queryFeatures(String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.queryFeatures(false, columns, envelope, where, whereArgs);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.queryFeatures(distinct, columns, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), where, whereArgs);
    }

    public int countFeatures(GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.countFeatures(false, null, envelope, where, whereArgs);
    }

    public int countFeatures(String column, GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.countFeatures(false, column, envelope, where, whereArgs);
    }

    public int countFeatures(boolean distinct, String column, GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.countFeatures(distinct, column, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), where, whereArgs);
    }

    public UserCustomResultSet query(double minX, double minY, double maxX, double maxY) {
        return this.query(false, minX, minY, maxX, maxY);
    }

    public UserCustomResultSet query(boolean distinct, double minX, double minY, double maxX, double maxY) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (UserCustomResultSet)this.query(distinct, where, whereArgs);
    }

    public UserCustomResultSet query(String[] columns, double minX, double minY, double maxX, double maxY) {
        return this.query(false, columns, minX, minY, maxX, maxY);
    }

    public UserCustomResultSet query(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return this.query(distinct, columns, where, whereArgs);
    }

    public int count(double minX, double minY, double maxX, double maxY) {
        return this.count(false, null, minX, minY, maxX, maxY);
    }

    public int count(String column, double minX, double minY, double maxX, double maxY) {
        return this.count(false, column, minX, minY, maxX, maxY);
    }

    public int count(boolean distinct, String column, double minX, double minY, double maxX, double maxY) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return this.count(distinct, column, where, whereArgs);
    }

    public FeatureResultSet queryFeatures(double minX, double minY, double maxX, double maxY) {
        return this.queryFeatures(false, minX, minY, maxX, maxY);
    }

    public FeatureResultSet queryFeatures(boolean distinct, double minX, double minY, double maxX, double maxY) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryIn(distinct, this.queryIdsSQL(where), whereArgs);
    }

    public FeatureResultSet queryFeatures(String[] columns, double minX, double minY, double maxX, double maxY) {
        return this.queryFeatures(false, columns, minX, minY, maxX, maxY);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryIn(distinct, columns, this.queryIdsSQL(where), whereArgs);
    }

    public int countFeatures(double minX, double minY, double maxX, double maxY) {
        return this.countFeatures(false, null, minX, minY, maxX, maxY);
    }

    public int countFeatures(String column, double minX, double minY, double maxX, double maxY) {
        return this.countFeatures(false, column, minX, minY, maxX, maxY);
    }

    public int countFeatures(boolean distinct, String column, double minX, double minY, double maxX, double maxY) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return this.featureDao.countIn(distinct, column, this.queryIdsSQL(where), whereArgs);
    }

    public FeatureResultSet queryFeatures(double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues) {
        return this.queryFeatures(false, minX, minY, maxX, maxY, fieldValues);
    }

    public FeatureResultSet queryFeatures(boolean distinct, double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryIn(distinct, this.queryIdsSQL(where), whereArgs, fieldValues);
    }

    public FeatureResultSet queryFeatures(String[] columns, double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues) {
        return this.queryFeatures(false, columns, minX, minY, maxX, maxY, fieldValues);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryIn(distinct, columns, this.queryIdsSQL(where), whereArgs, fieldValues);
    }

    public int countFeatures(double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues) {
        return this.countFeatures(false, null, minX, minY, maxX, maxY, fieldValues);
    }

    public int countFeatures(String column, double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues) {
        return this.countFeatures(false, column, minX, minY, maxX, maxY, fieldValues);
    }

    public int countFeatures(boolean distinct, String column, double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return this.featureDao.countIn(distinct, column, this.queryIdsSQL(where), whereArgs, fieldValues);
    }

    public FeatureResultSet queryFeatures(double minX, double minY, double maxX, double maxY, String where) {
        return this.queryFeatures(false, minX, minY, maxX, maxY, where);
    }

    public FeatureResultSet queryFeatures(boolean distinct, double minX, double minY, double maxX, double maxY, String where) {
        return this.queryFeatures(distinct, minX, minY, maxX, maxY, where, null);
    }

    public FeatureResultSet queryFeatures(String[] columns, double minX, double minY, double maxX, double maxY, String where) {
        return this.queryFeatures(false, columns, minX, minY, maxX, maxY, where);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, String where) {
        return this.queryFeatures(distinct, columns, minX, minY, maxX, maxY, where, null);
    }

    public int countFeatures(double minX, double minY, double maxX, double maxY, String where) {
        return this.countFeatures(false, null, minX, minY, maxX, maxY, where);
    }

    public int countFeatures(String column, double minX, double minY, double maxX, double maxY, String where) {
        return this.countFeatures(false, column, minX, minY, maxX, maxY, where);
    }

    public int countFeatures(boolean distinct, String column, double minX, double minY, double maxX, double maxY, String where) {
        return this.countFeatures(distinct, column, minX, minY, maxX, maxY, where, null);
    }

    public FeatureResultSet queryFeatures(double minX, double minY, double maxX, double maxY, String where, String[] whereArgs) {
        return this.queryFeatures(false, minX, minY, maxX, maxY, where, whereArgs);
    }

    public FeatureResultSet queryFeatures(boolean distinct, double minX, double minY, double maxX, double maxY, String where, String[] whereArgs) {
        this.validateRTree();
        String whereBounds = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereBoundsArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryIn(distinct, this.queryIdsSQL(whereBounds), whereBoundsArgs, where, whereArgs);
    }

    public FeatureResultSet queryFeatures(String[] columns, double minX, double minY, double maxX, double maxY, String where, String[] whereArgs) {
        return this.queryFeatures(false, columns, minX, minY, maxX, maxY, where, whereArgs);
    }

    public FeatureResultSet queryFeatures(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, String where, String[] whereArgs) {
        this.validateRTree();
        String whereBounds = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereBoundsArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryIn(distinct, columns, this.queryIdsSQL(whereBounds), whereBoundsArgs, where, whereArgs);
    }

    public int countFeatures(double minX, double minY, double maxX, double maxY, String where, String[] whereArgs) {
        return this.countFeatures(false, null, minX, minY, maxX, maxY, where, whereArgs);
    }

    public int countFeatures(String column, double minX, double minY, double maxX, double maxY, String where, String[] whereArgs) {
        return this.countFeatures(false, column, minX, minY, maxX, maxY, where, whereArgs);
    }

    public int countFeatures(boolean distinct, String column, double minX, double minY, double maxX, double maxY, String where, String[] whereArgs) {
        this.validateRTree();
        String whereBounds = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereBoundsArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return this.featureDao.countIn(distinct, column, this.queryIdsSQL(whereBounds), whereBoundsArgs, where, whereArgs);
    }

    public FeatureResultSet queryFeaturesForChunk(int limit) {
        return this.queryFeaturesForChunk(this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(int limit, long offset) {
        return this.queryFeaturesForChunk(this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String orderBy, int limit) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(this.queryIdsSQL(), orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String orderBy, int limit, long offset) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(this.queryIdsSQL(), orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, int limit) {
        return this.queryFeaturesForChunk(distinct, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String orderBy, int limit) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, this.queryIdsSQL(), orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String orderBy, int limit, long offset) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, this.queryIdsSQL(), orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, int limit) {
        return this.queryFeaturesForChunk(columns, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, String orderBy, int limit) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(columns, this.queryIdsSQL(), orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, String orderBy, int limit, long offset) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(columns, this.queryIdsSQL(), orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, String orderBy, int limit) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, columns, this.queryIdsSQL(), orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, String orderBy, int limit, long offset) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, columns, this.queryIdsSQL(), orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(Map<String, Object> fieldValues, String orderBy, int limit) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(this.queryIdsSQL(), fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(this.queryIdsSQL(), fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(distinct, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, Map<String, Object> fieldValues, String orderBy, int limit) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, this.queryIdsSQL(), fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, this.queryIdsSQL(), fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(columns, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, Map<String, Object> fieldValues, String orderBy, int limit) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(columns, this.queryIdsSQL(), fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(columns, this.queryIdsSQL(), fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, Map<String, Object> fieldValues, String orderBy, int limit) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, columns, this.queryIdsSQL(), fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, columns, this.queryIdsSQL(), fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(String where, int limit) {
        return this.queryFeaturesForChunk(where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(String where, int limit, long offset) {
        return this.queryFeaturesForChunk(where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, where, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, where, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, String where, int limit) {
        return this.queryFeaturesForChunk(distinct, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, where, null, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, where, null, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(String[] columns, String where, int limit) {
        return this.queryFeaturesForChunk(columns, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(String[] columns, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, where, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, where, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, String[] columns, String where, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, String[] columns, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, where, null, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, where, null, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String where, String[] whereArgs, String orderBy, int limit) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(this.queryIdsSQL(), where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String where, String[] whereArgs, String orderBy, int limit, long offset) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(this.queryIdsSQL(), where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(distinct, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String where, String[] whereArgs, String orderBy, int limit) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, this.queryIdsSQL(), where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, this.queryIdsSQL(), where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(columns, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, String where, String[] whereArgs, String orderBy, int limit) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(columns, this.queryIdsSQL(), where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(columns, this.queryIdsSQL(), where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, String where, String[] whereArgs, String orderBy, int limit) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, columns, this.queryIdsSQL(), where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, columns, this.queryIdsSQL(), where, whereArgs, orderBy, limit, offset);
    }

    public UserCustomResultSet queryForChunk(BoundingBox boundingBox, int limit) {
        return this.queryForChunk(boundingBox, this.getPkColumnName(), limit);
    }

    public UserCustomResultSet queryForChunk(BoundingBox boundingBox, int limit, long offset) {
        return this.queryForChunk(boundingBox, this.getPkColumnName(), limit, offset);
    }

    public UserCustomResultSet queryForChunk(BoundingBox boundingBox, String orderBy, int limit) {
        return this.queryForChunk(false, boundingBox, orderBy, limit);
    }

    public UserCustomResultSet queryForChunk(BoundingBox boundingBox, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, boundingBox, orderBy, limit, offset);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, BoundingBox boundingBox, int limit) {
        return this.queryForChunk(distinct, boundingBox, this.getPkColumnName(), limit);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, BoundingBox boundingBox, int limit, long offset) {
        return this.queryForChunk(distinct, boundingBox, this.getPkColumnName(), limit, offset);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, BoundingBox boundingBox, String orderBy, int limit) {
        return this.queryForChunk(distinct, boundingBox.buildEnvelope(), orderBy, limit);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, BoundingBox boundingBox, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, boundingBox.buildEnvelope(), orderBy, limit, offset);
    }

    public UserCustomResultSet queryForChunk(String[] columns, BoundingBox boundingBox, int limit) {
        return this.queryForChunk(columns, boundingBox, this.getPkColumnName(), limit);
    }

    public UserCustomResultSet queryForChunk(String[] columns, BoundingBox boundingBox, int limit, long offset) {
        return this.queryForChunk(columns, boundingBox, this.getPkColumnName(), limit, offset);
    }

    public UserCustomResultSet queryForChunk(String[] columns, BoundingBox boundingBox, String orderBy, int limit) {
        return this.queryForChunk(false, columns, boundingBox, orderBy, limit);
    }

    public UserCustomResultSet queryForChunk(String[] columns, BoundingBox boundingBox, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, columns, boundingBox, orderBy, limit, offset);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, int limit) {
        return this.queryForChunk(distinct, columns, boundingBox, this.getPkColumnName(), limit);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, int limit, long offset) {
        return this.queryForChunk(distinct, columns, boundingBox, this.getPkColumnName(), limit, offset);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String orderBy, int limit) {
        return this.queryForChunk(distinct, columns, boundingBox.buildEnvelope(), orderBy, limit);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, columns, boundingBox.buildEnvelope(), orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, int limit) {
        return this.queryFeaturesForChunk(boundingBox, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, int limit, long offset) {
        return this.queryFeaturesForChunk(boundingBox, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, boundingBox, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, boundingBox, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox.buildEnvelope(), orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox.buildEnvelope(), orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, int limit) {
        return this.queryFeaturesForChunk(columns, boundingBox, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, boundingBox, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox.buildEnvelope(), orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox.buildEnvelope(), orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(boundingBox, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(boundingBox, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, boundingBox, fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, boundingBox, fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox.buildEnvelope(), fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox.buildEnvelope(), fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(columns, boundingBox, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, boundingBox, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox.buildEnvelope(), fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox.buildEnvelope(), fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(BoundingBox boundingBox, String where, int limit) {
        return this.queryFeaturesForChunk(boundingBox, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(BoundingBox boundingBox, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(boundingBox, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, boundingBox, where, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, boundingBox, where, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, BoundingBox boundingBox, String where, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, BoundingBox boundingBox, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox, where, null, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox, where, null, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(String[] columns, BoundingBox boundingBox, String where, int limit) {
        return this.queryFeaturesForChunk(columns, boundingBox, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(String[] columns, BoundingBox boundingBox, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, boundingBox, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, where, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, where, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, String[] columns, BoundingBox boundingBox, String where, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, String[] columns, BoundingBox boundingBox, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, where, null, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, where, null, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(boundingBox, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(boundingBox, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, boundingBox, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, boundingBox, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox.buildEnvelope(), where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox.buildEnvelope(), where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(columns, boundingBox, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, boundingBox, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox.buildEnvelope(), where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox.buildEnvelope(), where, whereArgs, orderBy, limit, offset);
    }

    public UserCustomResultSet queryForChunk(BoundingBox boundingBox, Projection projection, int limit) {
        return this.queryForChunk(boundingBox, projection, this.getPkColumnName(), limit);
    }

    public UserCustomResultSet queryForChunk(BoundingBox boundingBox, Projection projection, int limit, long offset) {
        return this.queryForChunk(boundingBox, projection, this.getPkColumnName(), limit, offset);
    }

    public UserCustomResultSet queryForChunk(BoundingBox boundingBox, Projection projection, String orderBy, int limit) {
        return this.queryForChunk(false, boundingBox, projection, orderBy, limit);
    }

    public UserCustomResultSet queryForChunk(BoundingBox boundingBox, Projection projection, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, boundingBox, projection, orderBy, limit, offset);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, int limit) {
        return this.queryForChunk(distinct, boundingBox, projection, this.getPkColumnName(), limit);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, int limit, long offset) {
        return this.queryForChunk(distinct, boundingBox, projection, this.getPkColumnName(), limit, offset);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String orderBy, int limit) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryForChunk(distinct, featureBoundingBox, orderBy, limit);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String orderBy, int limit, long offset) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryForChunk(distinct, featureBoundingBox, orderBy, limit, offset);
    }

    public UserCustomResultSet queryForChunk(String[] columns, BoundingBox boundingBox, Projection projection, int limit) {
        return this.queryForChunk(columns, boundingBox, projection, this.getPkColumnName(), limit);
    }

    public UserCustomResultSet queryForChunk(String[] columns, BoundingBox boundingBox, Projection projection, int limit, long offset) {
        return this.queryForChunk(columns, boundingBox, projection, this.getPkColumnName(), limit, offset);
    }

    public UserCustomResultSet queryForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String orderBy, int limit) {
        return this.queryForChunk(false, columns, boundingBox, projection, orderBy, limit);
    }

    public UserCustomResultSet queryForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, columns, boundingBox, projection, orderBy, limit, offset);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, int limit) {
        return this.queryForChunk(distinct, columns, boundingBox, projection, this.getPkColumnName(), limit);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, int limit, long offset) {
        return this.queryForChunk(distinct, columns, boundingBox, projection, this.getPkColumnName(), limit, offset);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String orderBy, int limit) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryForChunk(distinct, columns, featureBoundingBox, orderBy, limit);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String orderBy, int limit, long offset) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryForChunk(distinct, columns, featureBoundingBox, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, int limit) {
        return this.queryFeaturesForChunk(boundingBox, projection, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, int limit, long offset) {
        return this.queryFeaturesForChunk(boundingBox, projection, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, boundingBox, projection, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, boundingBox, projection, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox, projection, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox, projection, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String orderBy, int limit) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, featureBoundingBox, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String orderBy, int limit, long offset) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, featureBoundingBox, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, int limit) {
        return this.queryFeaturesForChunk(columns, boundingBox, projection, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, boundingBox, projection, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, projection, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, projection, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, projection, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, projection, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String orderBy, int limit) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, columns, featureBoundingBox, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String orderBy, int limit, long offset) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, columns, featureBoundingBox, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(boundingBox, projection, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(boundingBox, projection, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, boundingBox, projection, fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, boundingBox, projection, fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox, projection, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox, projection, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, featureBoundingBox, fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, featureBoundingBox, fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(columns, boundingBox, projection, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, boundingBox, projection, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, projection, fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, projection, fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, projection, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, projection, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, columns, featureBoundingBox, fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, columns, featureBoundingBox, fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(BoundingBox boundingBox, Projection projection, String where, int limit) {
        return this.queryFeaturesForChunk(boundingBox, projection, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(BoundingBox boundingBox, Projection projection, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(boundingBox, projection, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, boundingBox, projection, where, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, boundingBox, projection, where, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, BoundingBox boundingBox, Projection projection, String where, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox, projection, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, BoundingBox boundingBox, Projection projection, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox, projection, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox, projection, where, null, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox, projection, where, null, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(String[] columns, BoundingBox boundingBox, Projection projection, String where, int limit) {
        return this.queryFeaturesForChunk(columns, boundingBox, projection, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(String[] columns, BoundingBox boundingBox, Projection projection, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, boundingBox, projection, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, projection, where, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, projection, where, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, projection, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, projection, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, projection, where, null, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, projection, where, null, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(boundingBox, projection, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(boundingBox, projection, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, boundingBox, projection, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, boundingBox, projection, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(distinct, boundingBox, projection, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, boundingBox, projection, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, featureBoundingBox, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, featureBoundingBox, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(columns, boundingBox, projection, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, boundingBox, projection, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, projection, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, boundingBox, projection, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, projection, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, boundingBox, projection, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, columns, featureBoundingBox, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeaturesForChunk(distinct, columns, featureBoundingBox, where, whereArgs, orderBy, limit, offset);
    }

    public UserCustomResultSet queryForChunk(GeometryEnvelope envelope, int limit) {
        return this.queryForChunk(envelope, this.getPkColumnName(), limit);
    }

    public UserCustomResultSet queryForChunk(GeometryEnvelope envelope, int limit, long offset) {
        return this.queryForChunk(envelope, this.getPkColumnName(), limit, offset);
    }

    public UserCustomResultSet queryForChunk(GeometryEnvelope envelope, String orderBy, int limit) {
        return this.queryForChunk(false, envelope, orderBy, limit);
    }

    public UserCustomResultSet queryForChunk(GeometryEnvelope envelope, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, envelope, orderBy, limit, offset);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, GeometryEnvelope envelope, int limit) {
        return this.queryForChunk(distinct, envelope, this.getPkColumnName(), limit);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, GeometryEnvelope envelope, int limit, long offset) {
        return this.queryForChunk(distinct, envelope, this.getPkColumnName(), limit, offset);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, GeometryEnvelope envelope, String orderBy, int limit) {
        return this.queryForChunk(distinct, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), orderBy, limit);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, GeometryEnvelope envelope, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), orderBy, limit, offset);
    }

    public UserCustomResultSet queryForChunk(String[] columns, GeometryEnvelope envelope, int limit) {
        return this.queryForChunk(columns, envelope, this.getPkColumnName(), limit);
    }

    public UserCustomResultSet queryForChunk(String[] columns, GeometryEnvelope envelope, int limit, long offset) {
        return this.queryForChunk(columns, envelope, this.getPkColumnName(), limit, offset);
    }

    public UserCustomResultSet queryForChunk(String[] columns, GeometryEnvelope envelope, String orderBy, int limit) {
        return this.queryForChunk(false, columns, envelope, orderBy, limit);
    }

    public UserCustomResultSet queryForChunk(String[] columns, GeometryEnvelope envelope, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, columns, envelope, orderBy, limit, offset);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, int limit) {
        return this.queryForChunk(distinct, columns, envelope, this.getPkColumnName(), limit);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, int limit, long offset) {
        return this.queryForChunk(distinct, columns, envelope, this.getPkColumnName(), limit, offset);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String orderBy, int limit) {
        return this.queryForChunk(distinct, columns, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), orderBy, limit);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, columns, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, int limit) {
        return this.queryFeaturesForChunk(envelope, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, int limit, long offset) {
        return this.queryFeaturesForChunk(envelope, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, envelope, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, envelope, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, int limit) {
        return this.queryFeaturesForChunk(distinct, envelope, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, envelope, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, int limit) {
        return this.queryFeaturesForChunk(columns, envelope, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, envelope, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, envelope, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, envelope, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, envelope, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, envelope, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(envelope, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(envelope, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, envelope, fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, envelope, fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(distinct, envelope, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, envelope, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(columns, envelope, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, envelope, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, envelope, fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, envelope, fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, envelope, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, envelope, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(GeometryEnvelope envelope, String where, int limit) {
        return this.queryFeaturesForChunk(envelope, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(GeometryEnvelope envelope, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(envelope, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, envelope, where, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, envelope, where, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, GeometryEnvelope envelope, String where, int limit) {
        return this.queryFeaturesForChunk(distinct, envelope, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, GeometryEnvelope envelope, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, envelope, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, envelope, where, null, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, envelope, where, null, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(String[] columns, GeometryEnvelope envelope, String where, int limit) {
        return this.queryFeaturesForChunk(columns, envelope, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(String[] columns, GeometryEnvelope envelope, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, envelope, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, envelope, where, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, envelope, where, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, envelope, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, envelope, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, envelope, where, null, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, envelope, where, null, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(envelope, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(envelope, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, envelope, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, envelope, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(distinct, envelope, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, envelope, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(columns, envelope, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, envelope, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, envelope, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, envelope, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, envelope, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, envelope, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), where, whereArgs, orderBy, limit, offset);
    }

    public UserCustomResultSet queryForChunk(double minX, double minY, double maxX, double maxY, int limit) {
        return this.queryForChunk(minX, minY, maxX, maxY, this.getPkColumnName(), limit);
    }

    public UserCustomResultSet queryForChunk(double minX, double minY, double maxX, double maxY, int limit, long offset) {
        return this.queryForChunk(minX, minY, maxX, maxY, this.getPkColumnName(), limit, offset);
    }

    public UserCustomResultSet queryForChunk(double minX, double minY, double maxX, double maxY, String orderBy, int limit) {
        return this.queryForChunk(false, minX, minY, maxX, maxY, orderBy, limit);
    }

    public UserCustomResultSet queryForChunk(double minX, double minY, double maxX, double maxY, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, minX, minY, maxX, maxY, orderBy, limit, offset);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, double minX, double minY, double maxX, double maxY, int limit) {
        return this.queryForChunk(distinct, minX, minY, maxX, maxY, this.getPkColumnName(), limit);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, double minX, double minY, double maxX, double maxY, int limit, long offset) {
        return this.queryForChunk(distinct, minX, minY, maxX, maxY, this.getPkColumnName(), limit, offset);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, double minX, double minY, double maxX, double maxY, String orderBy, int limit) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (UserCustomResultSet)this.queryForChunk(distinct, where, whereArgs, orderBy, limit);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, double minX, double minY, double maxX, double maxY, String orderBy, int limit, long offset) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (UserCustomResultSet)this.queryForChunk(distinct, where, whereArgs, orderBy, limit, offset);
    }

    public UserCustomResultSet queryForChunk(String[] columns, double minX, double minY, double maxX, double maxY, int limit) {
        return this.queryForChunk(columns, minX, minY, maxX, maxY, this.getPkColumnName(), limit);
    }

    public UserCustomResultSet queryForChunk(String[] columns, double minX, double minY, double maxX, double maxY, int limit, long offset) {
        return this.queryForChunk(columns, minX, minY, maxX, maxY, this.getPkColumnName(), limit, offset);
    }

    public UserCustomResultSet queryForChunk(String[] columns, double minX, double minY, double maxX, double maxY, String orderBy, int limit) {
        return this.queryForChunk(false, columns, minX, minY, maxX, maxY, orderBy, limit);
    }

    public UserCustomResultSet queryForChunk(String[] columns, double minX, double minY, double maxX, double maxY, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, columns, minX, minY, maxX, maxY, orderBy, limit, offset);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, int limit) {
        return this.queryForChunk(distinct, columns, minX, minY, maxX, maxY, this.getPkColumnName(), limit);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, int limit, long offset) {
        return this.queryForChunk(distinct, columns, minX, minY, maxX, maxY, this.getPkColumnName(), limit, offset);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, String orderBy, int limit) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (UserCustomResultSet)this.queryForChunk(distinct, columns, where, whereArgs, orderBy, limit);
    }

    public UserCustomResultSet queryForChunk(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, String orderBy, int limit, long offset) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (UserCustomResultSet)this.queryForChunk(distinct, columns, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(double minX, double minY, double maxX, double maxY, int limit) {
        return this.queryFeaturesForChunk(minX, minY, maxX, maxY, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(double minX, double minY, double maxX, double maxY, int limit, long offset) {
        return this.queryFeaturesForChunk(minX, minY, maxX, maxY, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(double minX, double minY, double maxX, double maxY, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, minX, minY, maxX, maxY, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(double minX, double minY, double maxX, double maxY, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, minX, minY, maxX, maxY, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, double minX, double minY, double maxX, double maxY, int limit) {
        return this.queryFeaturesForChunk(distinct, minX, minY, maxX, maxY, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, double minX, double minY, double maxX, double maxY, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, minX, minY, maxX, maxY, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, double minX, double minY, double maxX, double maxY, String orderBy, int limit) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, this.queryIdsSQL(where), whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, double minX, double minY, double maxX, double maxY, String orderBy, int limit, long offset) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, this.queryIdsSQL(where), whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, double minX, double minY, double maxX, double maxY, int limit) {
        return this.queryFeaturesForChunk(columns, minX, minY, maxX, maxY, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, double minX, double minY, double maxX, double maxY, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, minX, minY, maxX, maxY, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, double minX, double minY, double maxX, double maxY, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, minX, minY, maxX, maxY, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, double minX, double minY, double maxX, double maxY, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, minX, minY, maxX, maxY, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, minX, minY, maxX, maxY, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, minX, minY, maxX, maxY, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, String orderBy, int limit) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, columns, this.queryIdsSQL(where), whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, String orderBy, int limit, long offset) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, columns, this.queryIdsSQL(where), whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(minX, minY, maxX, maxY, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(minX, minY, maxX, maxY, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, minX, minY, maxX, maxY, fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, minX, minY, maxX, maxY, fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(distinct, minX, minY, maxX, maxY, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, minX, minY, maxX, maxY, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues, String orderBy, int limit) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, this.queryIdsSQL(where), whereArgs, fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, this.queryIdsSQL(where), whereArgs, fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(columns, minX, minY, maxX, maxY, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, minX, minY, maxX, maxY, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, minX, minY, maxX, maxY, fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, minX, minY, maxX, maxY, fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, minX, minY, maxX, maxY, fieldValues, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, minX, minY, maxX, maxY, fieldValues, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues, String orderBy, int limit) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, columns, this.queryIdsSQL(where), whereArgs, fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, columns, this.queryIdsSQL(where), whereArgs, fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(double minX, double minY, double maxX, double maxY, String where, int limit) {
        return this.queryFeaturesForChunk(minX, minY, maxX, maxY, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(double minX, double minY, double maxX, double maxY, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(minX, minY, maxX, maxY, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(double minX, double minY, double maxX, double maxY, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, minX, minY, maxX, maxY, where, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(double minX, double minY, double maxX, double maxY, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, minX, minY, maxX, maxY, where, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, double minX, double minY, double maxX, double maxY, String where, int limit) {
        return this.queryFeaturesForChunk(distinct, minX, minY, maxX, maxY, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, double minX, double minY, double maxX, double maxY, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, minX, minY, maxX, maxY, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, double minX, double minY, double maxX, double maxY, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, minX, minY, maxX, maxY, where, null, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, double minX, double minY, double maxX, double maxY, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, minX, minY, maxX, maxY, where, null, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(String[] columns, double minX, double minY, double maxX, double maxY, String where, int limit) {
        return this.queryFeaturesForChunk(columns, minX, minY, maxX, maxY, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(String[] columns, double minX, double minY, double maxX, double maxY, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, minX, minY, maxX, maxY, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, double minX, double minY, double maxX, double maxY, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, minX, minY, maxX, maxY, where, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, double minX, double minY, double maxX, double maxY, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, minX, minY, maxX, maxY, where, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, String where, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, minX, minY, maxX, maxY, where, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunkIdOrder(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, String where, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, minX, minY, maxX, maxY, where, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, String where, String orderBy, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, minX, minY, maxX, maxY, where, null, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, String where, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, minX, minY, maxX, maxY, where, null, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(double minX, double minY, double maxX, double maxY, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(minX, minY, maxX, maxY, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(double minX, double minY, double maxX, double maxY, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(minX, minY, maxX, maxY, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(double minX, double minY, double maxX, double maxY, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, minX, minY, maxX, maxY, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(double minX, double minY, double maxX, double maxY, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, minX, minY, maxX, maxY, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, double minX, double minY, double maxX, double maxY, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(distinct, minX, minY, maxX, maxY, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, double minX, double minY, double maxX, double maxY, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, minX, minY, maxX, maxY, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, double minX, double minY, double maxX, double maxY, String where, String[] whereArgs, String orderBy, int limit) {
        this.validateRTree();
        String whereBounds = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereBoundsArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, this.queryIdsSQL(whereBounds), whereBoundsArgs, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, double minX, double minY, double maxX, double maxY, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        this.validateRTree();
        String whereBounds = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereBoundsArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, this.queryIdsSQL(whereBounds), whereBoundsArgs, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, double minX, double minY, double maxX, double maxY, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(columns, minX, minY, maxX, maxY, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, double minX, double minY, double maxX, double maxY, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(columns, minX, minY, maxX, maxY, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, double minX, double minY, double maxX, double maxY, String where, String[] whereArgs, String orderBy, int limit) {
        return this.queryFeaturesForChunk(false, columns, minX, minY, maxX, maxY, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(String[] columns, double minX, double minY, double maxX, double maxY, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryFeaturesForChunk(false, columns, minX, minY, maxX, maxY, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, String where, String[] whereArgs, int limit) {
        return this.queryFeaturesForChunk(distinct, columns, minX, minY, maxX, maxY, where, whereArgs, this.getPkColumnName(), limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, String where, String[] whereArgs, int limit, long offset) {
        return this.queryFeaturesForChunk(distinct, columns, minX, minY, maxX, maxY, where, whereArgs, this.getPkColumnName(), limit, offset);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, String where, String[] whereArgs, String orderBy, int limit) {
        this.validateRTree();
        String whereBounds = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereBoundsArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, columns, this.queryIdsSQL(whereBounds), whereBoundsArgs, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryFeaturesForChunk(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        this.validateRTree();
        String whereBounds = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereBoundsArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryInForChunk(distinct, columns, this.queryIdsSQL(whereBounds), whereBoundsArgs, where, whereArgs, orderBy, limit, offset);
    }

    private void validateRTree() {
        if (!this.has()) {
            throw new GeoPackageException("RTree Extension not found for feature table: " + this.featureDao.getTableName());
        }
    }

    private String buildWhere(double minX, double minY, double maxX, double maxY) {
        StringBuilder where = new StringBuilder();
        where.append(this.buildWhere("minx", maxX, "<="));
        where.append(" AND ");
        where.append(this.buildWhere("miny", maxY, "<="));
        where.append(" AND ");
        where.append(this.buildWhere("maxx", minX, ">="));
        where.append(" AND ");
        where.append(this.buildWhere("maxy", minY, ">="));
        return where.toString();
    }

    private String[] buildWhereArgs(double minX, double minY, double maxX, double maxY) {
        return this.buildWhereArgs(new Object[]{maxX += this.tolerance, maxY += this.tolerance, minX -= this.tolerance, minY -= this.tolerance});
    }
}

