/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.shapefile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.baremaps.shapefile.CommonByteReader;
import org.apache.baremaps.shapefile.DBaseDataType;
import org.apache.baremaps.shapefile.DBaseFieldDescriptor;
import org.apache.baremaps.shapefile.DbaseByteReader;
import org.apache.baremaps.shapefile.ShapefileDescriptor;
import org.apache.baremaps.shapefile.ShapefileException;
import org.apache.baremaps.shapefile.ShapefileGeometryType;
import org.apache.baremaps.store.DataColumn;
import org.apache.baremaps.store.DataColumnFixed;
import org.apache.baremaps.store.DataRow;
import org.apache.baremaps.store.DataSchema;
import org.apache.baremaps.store.DataSchemaImpl;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class ShapefileByteReader
extends CommonByteReader {
    private static final String GEOMETRY_NAME = "geometry";
    private ShapefileDescriptor shapefileDescriptor;
    private List<DBaseFieldDescriptor> databaseFieldsDescriptors;
    private DataSchema schema;
    private File shapeFileIndex;
    private ArrayList<Integer> indexes;
    private ArrayList<Integer> recordsLengths;
    private GeometryFactory geometryFactory = new GeometryFactory();

    public ShapefileByteReader(File shapefile, File dbaseFile, File shapefileIndex) throws IOException {
        super(shapefile);
        this.shapeFileIndex = shapefileIndex;
        this.loadDatabaseFieldDescriptors(dbaseFile);
        this.loadDescriptor();
        if (this.shapeFileIndex != null) {
            this.loadShapefileIndexes();
        }
        this.schema = this.getSchema(shapefile.getName());
    }

    public List<DBaseFieldDescriptor> getFieldsDescriptors() {
        return this.databaseFieldsDescriptors;
    }

    public ShapefileDescriptor getShapefileDescriptor() {
        return this.shapefileDescriptor;
    }

    public DataSchema getSchema() {
        return this.schema;
    }

    private DataSchema getSchema(String name) {
        Objects.requireNonNull(name, "The row name cannot be null.");
        ArrayList<DataColumnFixed> columns = new ArrayList<DataColumnFixed>();
        for (int i = 0; i < this.databaseFieldsDescriptors.size(); ++i) {
            DBaseFieldDescriptor fieldDescriptor = this.databaseFieldsDescriptors.get(i);
            String columnName = fieldDescriptor.getName();
            DataColumn.Type columnType = switch (fieldDescriptor.getType()) {
                default -> throw new IncompatibleClassChangeError();
                case DBaseDataType.CHARACTER -> DataColumn.Type.STRING;
                case DBaseDataType.NUMBER -> {
                    if (fieldDescriptor.getDecimalCount() == 0) {
                        yield DataColumn.Type.LONG;
                    }
                    yield DataColumn.Type.DOUBLE;
                }
                case DBaseDataType.CURRENCY -> DataColumn.Type.DOUBLE;
                case DBaseDataType.DOUBLE -> DataColumn.Type.DOUBLE;
                case DBaseDataType.INTEGER -> DataColumn.Type.INTEGER;
                case DBaseDataType.AUTO_INCREMENT -> DataColumn.Type.INTEGER;
                case DBaseDataType.LOGICAL -> DataColumn.Type.STRING;
                case DBaseDataType.DATE -> DataColumn.Type.STRING;
                case DBaseDataType.MEMO -> DataColumn.Type.STRING;
                case DBaseDataType.FLOATING_POINT -> DataColumn.Type.STRING;
                case DBaseDataType.PICTURE -> DataColumn.Type.STRING;
                case DBaseDataType.VARI_FIELD -> DataColumn.Type.STRING;
                case DBaseDataType.VARIANT -> DataColumn.Type.STRING;
                case DBaseDataType.TIMESTAMP -> DataColumn.Type.STRING;
                case DBaseDataType.DATE_TIME -> DataColumn.Type.STRING;
            };
            columns.add(new DataColumnFixed(columnName, DataColumn.Cardinality.OPTIONAL, columnType));
        }
        columns.add(new DataColumnFixed(GEOMETRY_NAME, DataColumn.Cardinality.OPTIONAL, DataColumn.Type.GEOMETRY));
        return new DataSchemaImpl(name, columns);
    }

    private void loadDescriptor() {
        this.shapefileDescriptor = new ShapefileDescriptor(this.getByteBuffer());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean loadShapefileIndexes() {
        if (this.shapeFileIndex == null) {
            return false;
        }
        try (FileInputStream fis = new FileInputStream(this.shapeFileIndex);){
            boolean bl;
            block15: {
                FileChannel fc = fis.getChannel();
                try {
                    int fsize = (int)fc.size();
                    MappedByteBuffer indexesByteBuffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fsize);
                    this.indexes = new ArrayList();
                    this.recordsLengths = new ArrayList();
                    indexesByteBuffer.position(100);
                    indexesByteBuffer.order(ByteOrder.BIG_ENDIAN);
                    while (indexesByteBuffer.hasRemaining()) {
                        this.indexes.add(indexesByteBuffer.getInt());
                        this.recordsLengths.add(indexesByteBuffer.getInt());
                    }
                    bl = true;
                    if (fc == null) break block15;
                }
                catch (Throwable throwable) {
                    if (fc != null) {
                        try {
                            fc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                fc.close();
            }
            return bl;
        }
        catch (IOException e) {
            this.shapeFileIndex = null;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDatabaseFieldDescriptors(File dbaseFile) throws IOException {
        DbaseByteReader databaseReader = null;
        try {
            databaseReader = new DbaseByteReader(dbaseFile, null);
            this.databaseFieldsDescriptors = databaseReader.getFieldsDescriptors();
        }
        finally {
            if (databaseReader != null) {
                try {
                    databaseReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setRowNum(int recordNumber) throws ShapefileException {
        if (recordNumber < 1) {
            throw new IllegalArgumentException("Wrong direct access before start");
        }
        if (this.shapeFileIndex == null) {
            throw new ShapefileException("No direct access");
        }
        int position = this.indexes.get(recordNumber - 1) * 2;
        if (position >= this.getByteBuffer().capacity()) {
            throw new ShapefileException("Wrong direct access after last");
        }
        try {
            this.getByteBuffer().position(position);
        }
        catch (IllegalArgumentException e) {
            throw new ShapefileException("Wrong position", e);
        }
    }

    public void completeRow(DataRow row) throws ShapefileException {
        this.getByteBuffer().getInt();
        this.getByteBuffer().getInt();
        this.getByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
        int shapeTypeId = this.getByteBuffer().getInt();
        ShapefileGeometryType shapefileGeometryType = ShapefileGeometryType.get(shapeTypeId);
        if (shapefileGeometryType == null) {
            throw new ShapefileException("The shapefile schema doesn''t match to any known schema.");
        }
        switch (shapefileGeometryType) {
            case NULL_SHAPE: {
                this.loadNullRow(row);
                break;
            }
            case POINT: {
                this.loadPointRow(row);
                break;
            }
            case POLYGON: {
                this.loadPolygonRow(row);
                break;
            }
            case POLY_LINE: {
                this.loadPolylineRow(row);
                break;
            }
            default: {
                throw new ShapefileException("Unsupported shapefile type: " + shapeTypeId);
            }
        }
        this.getByteBuffer().order(ByteOrder.BIG_ENDIAN);
    }

    private void loadNullRow(DataRow row) {
        row.set(GEOMETRY_NAME, null);
    }

    private void loadPointRow(DataRow row) {
        double x = this.getByteBuffer().getDouble();
        double y = this.getByteBuffer().getDouble();
        Point pnt = this.geometryFactory.createPoint(new Coordinate(x, y));
        row.set(GEOMETRY_NAME, (Object)pnt);
    }

    private void loadPolygonRow(DataRow row) {
        this.getByteBuffer().getDouble();
        this.getByteBuffer().getDouble();
        this.getByteBuffer().getDouble();
        this.getByteBuffer().getDouble();
        int numParts = this.getByteBuffer().getInt();
        int numPoints = this.getByteBuffer().getInt();
        Geometry multiPolygon = this.readMultiplePolygon(numParts, numPoints);
        row.set(GEOMETRY_NAME, (Object)multiPolygon);
    }

    private Geometry readMultiplePolygon(int numParts, int numPoints) {
        int[] partsIndexes = new int[numParts];
        for (int index = 0; index < numParts; ++index) {
            partsIndexes[index] = this.getByteBuffer().getInt();
        }
        Coordinate[] coordinates = new Coordinate[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            Coordinate coordinate;
            double x = this.getByteBuffer().getDouble();
            double y = this.getByteBuffer().getDouble();
            coordinates[i] = coordinate = new Coordinate(x, y);
        }
        ArrayList<Polygon> shells = new ArrayList<Polygon>();
        LinkedList<Polygon> holes = new LinkedList<Polygon>();
        for (int i = 0; i < partsIndexes.length; ++i) {
            int from = partsIndexes[i];
            int to = i < partsIndexes.length - 1 ? partsIndexes[i + 1] : coordinates.length;
            Coordinate[] array = Arrays.copyOfRange(coordinates, from, to);
            Polygon linearRing = this.geometryFactory.createPolygon(array);
            if (!Orientation.isCCW((Coordinate[])linearRing.getCoordinates())) {
                shells.add(linearRing);
                continue;
            }
            holes.add(linearRing);
        }
        MultiPolygon shellsMultiPolygon = this.geometryFactory.createMultiPolygon((Polygon[])shells.toArray(Polygon[]::new));
        MultiPolygon holesMultiPolygon = this.geometryFactory.createMultiPolygon((Polygon[])holes.toArray(Polygon[]::new));
        return shellsMultiPolygon.difference((Geometry)holesMultiPolygon);
    }

    private void loadPolylineRow(DataRow row) {
        this.getByteBuffer().getDouble();
        this.getByteBuffer().getDouble();
        this.getByteBuffer().getDouble();
        this.getByteBuffer().getDouble();
        int numParts = this.getByteBuffer().getInt();
        int numPoints = this.getByteBuffer().getInt();
        int[] numPartArr = new int[numParts + 1];
        for (int n = 0; n < numParts; ++n) {
            int idx;
            numPartArr[n] = idx = this.getByteBuffer().getInt();
        }
        numPartArr[numParts] = numPoints;
        CoordinateList coordinates = new CoordinateList();
        for (int m = 0; m < numParts; ++m) {
            double xpnt = this.getByteBuffer().getDouble();
            double ypnt = this.getByteBuffer().getDouble();
            coordinates.add((Object)new Coordinate(xpnt, ypnt));
            for (int j = numPartArr[m]; j < numPartArr[m + 1] - 1; ++j) {
                xpnt = this.getByteBuffer().getDouble();
                ypnt = this.getByteBuffer().getDouble();
                coordinates.add((Object)new Coordinate(xpnt, ypnt));
            }
        }
        row.set(GEOMETRY_NAME, (Object)this.geometryFactory.createLineString(coordinates.toCoordinateArray()));
    }
}

