/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid.j2d;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.apache.sis.coverage.grid.j2d.ColorsForRange;
import org.apache.sis.coverage.grid.j2d.ImageUtilities;
import org.apache.sis.coverage.grid.j2d.MultiBandsIndexColorModel;
import org.apache.sis.coverage.grid.j2d.ScaledColorModel;
import org.apache.sis.coverage.grid.j2d.ScaledColorSpace;
import org.apache.sis.image.DataType;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.internal.Strings;

public final class ColorModelFactory {
    public static final int DEFAULT_VISIBLE_BAND = 0;
    public static final Color TRANSPARENT = new Color(0, true);
    private static final WeakHashSet<ColorModel> CACHE = new WeakHashSet(ColorModel.class);
    private static final WeakValueHashMap<ColorModelFactory, ColorModel> PIECEWISES = new WeakValueHashMap(ColorModelFactory.class);
    private static final Comparator<ColorsForRange> RANGE_COMPARATOR = (r1, r2) -> Double.compare(r1.sampleRange.getMinDouble(true), r2.sampleRange.getMinDouble(true));
    private final int dataType;
    private final int numBands;
    private final int visibleBand;
    private final double minimum;
    private final double maximum;
    private final int[] pieceStarts;
    private final int[][] ARGB;

    private ColorModelFactory(int dataType, int numBands, int visibleBand, ColorsForRange[] colors) {
        this.dataType = dataType;
        this.numBands = numBands;
        this.visibleBand = visibleBand;
        Arrays.sort(colors, RANGE_COMPARATOR);
        int count = 0;
        int[] starts = new int[colors.length + 1];
        Object codes = new int[colors.length][];
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        for (ColorsForRange entry : colors) {
            int before;
            int upper;
            int lower;
            NumberRange<?> range = entry.sampleRange;
            double min = range.getMinDouble(true);
            double max = range.getMaxDouble(false);
            if (min < minimum) {
                minimum = min;
            }
            if (max > maximum) {
                maximum = max;
            }
            if ((lower = Math.round((float)min)) >= (upper = Math.round((float)max))) continue;
            if (lower < 0 || upper > 65536) {
                starts = ArraysExt.EMPTY_INT;
                codes = null;
                count = 0;
                continue;
            }
            if (codes == null) continue;
            if (count != 0 && (before = starts[count]) != lower && before <= lower) {
                codes = (int[][])Arrays.copyOf(codes, ((int[][])codes).length + 1);
                starts = Arrays.copyOf(starts, starts.length + 1);
                codes[count++] = ArraysExt.EMPTY_INT;
            }
            codes[count] = entry.toARGB(upper - lower);
            starts[count] = lower;
            starts[++count] = upper;
        }
        if (minimum >= maximum) {
            minimum = 0.0;
            maximum = 1.0;
        }
        if (starts.length != 0) {
            starts = ArraysExt.resize((int[])starts, (int)(count + 1));
        }
        this.minimum = minimum;
        this.maximum = maximum;
        this.pieceStarts = starts;
        this.ARGB = codes;
    }

    private ColorModelFactory(int dataType, int numBands, int visibleBand, ColorModelFactory colors) {
        this.dataType = dataType;
        this.numBands = numBands;
        this.visibleBand = visibleBand;
        this.minimum = colors.minimum;
        this.maximum = colors.maximum;
        this.pieceStarts = colors.pieceStarts;
        this.ARGB = colors.ARGB;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ColorModelFactory) {
            ColorModelFactory that = (ColorModelFactory)other;
            return this.dataType == that.dataType && this.numBands == that.numBands && this.visibleBand == that.visibleBand && this.minimum == that.minimum && this.maximum == that.maximum && Arrays.equals(this.pieceStarts, that.pieceStarts) && Arrays.deepEquals((Object[])this.ARGB, (Object[])that.ARGB);
        }
        return false;
    }

    public int hashCode() {
        int categoryCount = this.pieceStarts.length - 1;
        int code = 962745549 + (this.numBands * 31 + this.visibleBand) * 31 + categoryCount;
        for (int i = 0; i < categoryCount; ++i) {
            code += Arrays.hashCode(this.ARGB[i]);
        }
        return code;
    }

    public static ColorModelFactory piecewise(Collection<Map.Entry<NumberRange<?>, Color[]>> colors) {
        ColorsForRange[] ranges = ColorsForRange.list(colors, null);
        return (ColorModelFactory)PIECEWISES.intern((Object)new ColorModelFactory(0, 0, 0, ranges));
    }

    public ColorModel createColorModel(int dataType, int numBands, int visibleBand) {
        return new ColorModelFactory(dataType, numBands, visibleBand, this).getColorModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColorModel getColorModel() {
        WeakValueHashMap<ColorModelFactory, ColorModel> weakValueHashMap = PIECEWISES;
        synchronized (weakValueHashMap) {
            return (ColorModel)PIECEWISES.computeIfAbsent((Object)this, ColorModelFactory::createColorModel);
        }
    }

    private ColorModel createColorModel() {
        int[] colorMap;
        if (this.dataType != 0 && this.dataType != 1) {
            return ColorModelFactory.createGrayScale(this.dataType, this.numBands, this.visibleBand, this.minimum, this.maximum);
        }
        int categoryCount = this.pieceStarts.length - 1;
        if (this.numBands == 1 && categoryCount <= 0) {
            ColorSpace cs = ColorSpace.getInstance(1003);
            int[] nBits = new int[]{DataBuffer.getDataTypeSize(this.dataType)};
            return ColorModelFactory.unique(new ComponentColorModel(cs, nBits, false, true, 1, this.dataType));
        }
        int transparent = -1;
        if (categoryCount <= 0) {
            colorMap = ArraysExt.range((int)0, (int)256);
        } else {
            colorMap = new int[this.pieceStarts[categoryCount]];
            for (int i = 0; i < categoryCount; ++i) {
                int[] colors = this.ARGB[i];
                int lower = this.pieceStarts[i];
                int upper = this.pieceStarts[i + 1];
                if (transparent < 0 && colors.length == 0) {
                    transparent = lower;
                }
                ColorModelFactory.expand(colors, colorMap, lower, upper);
            }
        }
        return ColorModelFactory.createIndexColorModel(this.numBands, this.visibleBand, colorMap, true, transparent);
    }

    static ColorModel createPiecewise(int dataType, int numBands, int visibleBand, ColorsForRange[] colors) {
        return new ColorModelFactory(dataType, numBands, visibleBand, colors).getColorModel();
    }

    public static IndexColorModel createIndexColorModel(int numBands, int visibleBand, int[] ARGB, boolean hasAlpha, int transparent) {
        int length = ARGB.length;
        int bits = ColorModelFactory.getBitCount(length);
        int dataType = ColorModelFactory.getTransferType(length);
        IndexColorModel cm = numBands == 1 ? new IndexColorModel(bits, length, ARGB, 0, hasAlpha, transparent, dataType) : new MultiBandsIndexColorModel(bits, length, ARGB, 0, hasAlpha, transparent, dataType, numBands, visibleBand);
        return (IndexColorModel)CACHE.unique((Object)cm);
    }

    private static ColorModel unique(ColorModel cm) {
        return (ColorModel)CACHE.unique((Object)cm);
    }

    public static ColorModel createColorScale(int dataType, int numBands, int visibleBand, double lower, double upper, Color ... colors) {
        ArgumentChecks.ensureNonEmpty((String)"colors", (Object[])colors);
        return ColorModelFactory.createPiecewise(dataType, numBands, visibleBand, new ColorsForRange[]{new ColorsForRange(null, new NumberRange(Double.class, (Number)lower, true, (Number)upper, false), colors, true, null)});
    }

    public static ColorModel createGrayScale(int dataType, int numComponents, int visibleBand, double minimum, double maximum) {
        ComponentColorModel cm;
        if (numComponents == 1 && minimum > -1.0 && ColorModelFactory.isStandardRange(dataType, minimum, maximum)) {
            ColorSpace cs = ColorSpace.getInstance(1003);
            cm = new ComponentColorModel(cs, false, true, 1, dataType);
        } else {
            ScaledColorSpace cs = new ScaledColorSpace(numComponents, visibleBand, minimum, maximum);
            cm = new ScaledColorModel(cs, dataType);
        }
        return ColorModelFactory.unique(cm);
    }

    static boolean isStandardRange(int dataType, double minimum, double maximum) {
        double upper;
        boolean signed;
        switch (dataType) {
            case 0: 
            case 1: {
                signed = false;
                break;
            }
            case 2: 
            case 3: {
                signed = true;
                break;
            }
            default: {
                return false;
            }
        }
        int numBits = DataBuffer.getDataTypeSize(dataType);
        if (signed) {
            upper = 1L << numBits - 1;
            minimum += upper;
        } else {
            upper = 1L << numBits;
        }
        return Math.abs(minimum) < 1.0 && Math.abs(maximum - (upper - 0.5)) < 1.5;
    }

    public static ColorModel createGrayScale(SampleModel model, int visibleBand, NumberRange<?> range) {
        double maximum;
        double minimum;
        if (range != null) {
            minimum = range.getMinDouble();
            maximum = range.getMaxDouble();
        } else {
            minimum = 0.0;
            maximum = 1.0;
            if (ImageUtilities.isIntegerType(model)) {
                long max = Numerics.bitmask((int)model.getSampleSize(visibleBand)) - 1L;
                if (!ImageUtilities.isUnsignedType(model)) {
                    minimum = (max >>>= 1) ^ 0xFFFFFFFFFFFFFFFFL;
                }
                maximum = max;
            }
        }
        return ColorModelFactory.createGrayScale(model.getDataType(), model.getNumBands(), visibleBand, minimum, maximum);
    }

    public static ColorModel createRGB(SampleModel model) {
        int numBands = model.getNumBands();
        if (numBands >= 3 && numBands <= 4 && ImageUtilities.isIntegerType(model)) {
            int bitsPerSample = 0;
            for (int i = 0; i < numBands; ++i) {
                bitsPerSample = Math.max(bitsPerSample, model.getSampleSize(i));
            }
            if (bitsPerSample <= 8) {
                return ColorModelFactory.createRGB(bitsPerSample, model.getNumDataElements() == 1, numBands > 3);
            }
        }
        return null;
    }

    public static ColorModel createRGB(int bitsPerSample, boolean packed, boolean hasAlpha) {
        ColorModel cm;
        if (hasAlpha & packed && bitsPerSample == 8) {
            return ColorModel.getRGBdefault();
        }
        ArgumentChecks.ensureBetween((String)"bitsPerSample", (int)1, (int)8, (int)bitsPerSample);
        int mask = (1 << bitsPerSample) - 1;
        if (packed) {
            cm = new DirectColorModel((hasAlpha ? 4 : 3) * bitsPerSample, mask << bitsPerSample * 2, mask << bitsPerSample, mask, hasAlpha ? mask << bitsPerSample * 3 : 0);
        } else {
            int[] numBits = new int[hasAlpha ? 4 : 3];
            Arrays.fill(numBits, bitsPerSample);
            cm = new ComponentColorModel(ColorSpace.getInstance(1000), numBits, hasAlpha, false, hasAlpha ? 3 : 1, 0);
        }
        return ColorModelFactory.unique(cm);
    }

    public static ColorModel createSubset(ColorModel cm, int[] bands) {
        ColorSpace cs;
        assert (bands != null && bands.length > 0) : bands;
        int visibleBand = 0;
        if (cm instanceof MultiBandsIndexColorModel) {
            visibleBand = ((MultiBandsIndexColorModel)cm).visibleBand;
        } else if (cm != null && (cs = cm.getColorSpace()) instanceof ScaledColorSpace) {
            visibleBand = ((ScaledColorSpace)cs).visibleBand;
        }
        for (int i = 0; i < bands.length; ++i) {
            if (bands[i] != visibleBand) continue;
            visibleBand = i;
            break;
        }
        return ColorModelFactory.derive(cm, bands.length, visibleBand);
    }

    public static ColorModel derive(ColorModel cm, int numBands, int visibleBand) {
        ColorModel subset;
        if (cm == null) {
            return null;
        }
        if (cm instanceof MultiBandsIndexColorModel) {
            subset = ((MultiBandsIndexColorModel)cm).derive(numBands, visibleBand);
        } else if (cm instanceof ScaledColorModel) {
            subset = ((ScaledColorModel)cm).derive(numBands, visibleBand);
        } else if (numBands == 1 && cm instanceof ComponentColorModel) {
            int dataType = cm.getTransferType();
            if (dataType < 0 || dataType > 1) {
                return null;
            }
            ColorSpace cs = ColorSpace.getInstance(1003);
            subset = new ComponentColorModel(cs, false, true, 1, dataType);
        } else {
            return null;
        }
        return ColorModelFactory.unique(subset);
    }

    public static void formatDescription(ColorSpace cs, StringBuilder buffer) {
        if (cs != null) {
            if (cs instanceof ScaledColorSpace) {
                ((ScaledColorSpace)cs).formatRange(buffer.append("showing "));
            } else if (cs.getType() == 6) {
                buffer.append("grayscale");
            }
        }
    }

    private static int getTransferType(int mapSize) {
        return mapSize <= 256 ? 0 : 1;
    }

    public static int getBitCount(int mapSize) {
        int count = 32 - Integer.numberOfLeadingZeros(mapSize - 1);
        assert (1 << count >= mapSize) : mapSize;
        assert (1 << count - 1 < mapSize) : mapSize;
        return Math.max(1, count);
    }

    public static void expand(int[] colors, int[] ARGB, int lower, int upper) {
        switch (colors.length) {
            case 1: {
                Arrays.fill(ARGB, lower, upper, colors[0]);
            }
            case 0: {
                return;
            }
        }
        switch (upper - lower) {
            case 1: {
                ARGB[lower] = colors[0];
            }
            case 0: {
                return;
            }
        }
        if (upper - lower == colors.length) {
            System.arraycopy(colors, 0, ARGB, 0, colors.length);
            return;
        }
        double scale = (double)(colors.length - 1) / (double)(upper - lower - 1);
        int maxBase = colors.length - 2;
        float index = 0.0f;
        int base = 0;
        int i = lower;
        while (true) {
            int C0 = colors[base];
            int C1 = colors[base + 1];
            int A0 = C0 >>> 24 & 0xFF;
            int A1 = (C1 >>> 24 & 0xFF) - A0;
            int R0 = C0 >>> 16 & 0xFF;
            int R1 = (C1 >>> 16 & 0xFF) - R0;
            int G0 = C0 >>> 8 & 0xFF;
            int G1 = (C1 >>> 8 & 0xFF) - G0;
            int B0 = C0 & 0xFF;
            int B1 = (C1 & 0xFF) - B0;
            int oldBase = base;
            do {
                float delta = index - (float)base;
                ARGB[i] = ColorModelFactory.roundByte((float)A0 + delta * (float)A1) << 24 | ColorModelFactory.roundByte((float)R0 + delta * (float)R1) << 16 | ColorModelFactory.roundByte((float)G0 + delta * (float)G1) << 8 | ColorModelFactory.roundByte((float)B0 + delta * (float)B1);
                if (++i != upper) continue;
                return;
            } while ((base = Math.min(maxBase, (int)((index = (float)((double)(i - lower) * scale)) + Math.ulp(index)))) == oldBase);
        }
    }

    private static int roundByte(float value) {
        return Math.min(Math.max(Math.round(value), 0), 255);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(Strings.toString(this.getClass(), (Object[])new Object[]{"dataType", DataType.forDataBufferType(this.dataType), "numBands", this.numBands, "visibleBand", this.visibleBand, "range", NumberRange.create((double)this.minimum, (boolean)true, (double)this.maximum, (boolean)false)}));
        int n = this.pieceStarts != null ? this.pieceStarts.length : 0;
        for (int i = 0; i < n; ++i) {
            String start = Integer.toString(this.pieceStarts[i]);
            buffer.append(System.lineSeparator()).append(CharSequences.spaces((int)(9 - start.length()))).append(start);
            if (i >= this.ARGB.length) continue;
            buffer.append('\u2026');
            ColorsForRange.appendColorRange(buffer, this.ARGB[i]);
        }
        return buffer.toString();
    }
}

