/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.io.Serializable;
import java.util.Objects;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

public final class GridOrientation
implements Serializable {
    private static final long serialVersionUID = -1354776950822418237L;
    public static final GridOrientation HOMOTHETY = new GridOrientation(0L, null, false);
    public static final GridOrientation REFLECTION_Y = new GridOrientation(2L, null, false);
    public static final GridOrientation DISPLAY = new GridOrientation(2L, AxesConvention.DISPLAY_ORIENTED, false);
    final long flippedAxes;
    final AxesConvention crsVariant;
    final boolean canReorderGridAxis;

    private GridOrientation(long flippedAxes, AxesConvention crsVariant, boolean canReorderGridAxis) {
        this.flippedAxes = flippedAxes;
        this.crsVariant = crsVariant;
        this.canReorderGridAxis = canReorderGridAxis;
    }

    public GridOrientation flipGridAxis(int dimension) {
        ArgumentChecks.ensurePositive((String)"dimension", (int)dimension);
        if (dimension >= 64) {
            throw new ArithmeticException(Errors.format((short)37, (Object)(dimension + 1)));
        }
        return new GridOrientation(this.flippedAxes ^ 1L << dimension, this.crsVariant, this.canReorderGridAxis);
    }

    public GridOrientation useVariantOfCRS(AxesConvention variant) {
        if (variant == this.crsVariant) {
            return this;
        }
        if (variant == AxesConvention.NORMALIZED) {
            throw new IllegalArgumentException(Errors.format((short)170, (Object)variant));
        }
        return new GridOrientation(this.flippedAxes, variant, this.canReorderGridAxis);
    }

    public GridOrientation canReorderGridAxis(boolean enabled) {
        if (enabled == this.canReorderGridAxis) {
            return this;
        }
        return new GridOrientation(this.flippedAxes, this.crsVariant, enabled);
    }

    public boolean equals(Object other) {
        if (other instanceof GridOrientation) {
            GridOrientation that = (GridOrientation)other;
            return this.flippedAxes == that.flippedAxes && this.crsVariant == that.crsVariant && this.canReorderGridAxis == that.canReorderGridAxis;
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.flippedAxes) + Objects.hashCode(this.crsVariant) + Boolean.hashCode(this.canReorderGridAxis);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName()).append('[');
        String separator = "";
        if (this.flippedAxes != 0L) {
            long i;
            buffer.append("flip={");
            long f = this.flippedAxes;
            do {
                i = Long.numberOfTrailingZeros(f);
                buffer.append(separator).append(i);
                separator = ", ";
            } while ((f &= 1L << (int)i ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
            buffer.append('}');
        }
        if (this.crsVariant != null) {
            buffer.append(separator).append("crs=").append(this.crsVariant);
            if (this.canReorderGridAxis) {
                buffer.append(" with grid axis reordering");
            }
        }
        return buffer.append(']').toString();
    }
}

