/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.tiff;

import mil.nga.tiff.FieldTagType;
import mil.nga.tiff.FieldType;

public class FileDirectoryEntry
implements Comparable<FileDirectoryEntry> {
    private final FieldTagType fieldTag;
    private final FieldType fieldType;
    private final long typeCount;
    private final Object values;

    public FileDirectoryEntry(FieldTagType fieldTag, FieldType fieldType, long typeCount, Object values) {
        this.fieldTag = fieldTag;
        this.fieldType = fieldType;
        this.typeCount = typeCount;
        this.values = values;
    }

    public FieldTagType getFieldTag() {
        return this.fieldTag;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public long getTypeCount() {
        return this.typeCount;
    }

    public Object getValues() {
        return this.values;
    }

    public long sizeWithValues() {
        long size = 12L + this.sizeOfValues();
        return size;
    }

    public long sizeOfValues() {
        long size = 0L;
        long valueBytes = (long)this.fieldType.getBytes() * this.typeCount;
        if (valueBytes > 4L) {
            size = valueBytes;
        }
        return size;
    }

    @Override
    public int compareTo(FileDirectoryEntry other) {
        return this.fieldTag.getId() - other.getFieldTag().getId();
    }

    public int hashCode() {
        return this.fieldTag.getId();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileDirectoryEntry other = (FileDirectoryEntry)obj;
        return this.fieldTag == other.fieldTag;
    }
}

