/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.s3a.S3ClientFactory;
import org.apache.hadoop.fs.s3a.auth.SignerFactory;
import org.apache.hadoop.fs.s3a.impl.AWSClientConfig;
import org.apache.hadoop.fs.s3a.statistics.impl.AwsStatisticsCollector;
import org.apache.hadoop.fs.store.LogExactlyOnce;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.util.AwsHostNameUtils;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3BaseClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.multipart.MultipartConfiguration;
import software.amazon.awssdk.transfer.s3.S3TransferManager;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DefaultS3ClientFactory
extends Configured
implements S3ClientFactory {
    private static final String REQUESTER_PAYS_HEADER_VALUE = "requester";
    private static final String S3_SERVICE_NAME = "s3";
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultS3ClientFactory.class);
    private static final LogExactlyOnce WARN_OF_DEFAULT_REGION_CHAIN = new LogExactlyOnce(LOG);
    private static final String SDK_REGION_CHAIN_IN_USE = "S3A filesystem client is using the SDK region resolution chain.";
    private static final LogExactlyOnce IGNORE_CSE_WARN = new LogExactlyOnce(LOG);
    @VisibleForTesting
    public static final String ERROR_ENDPOINT_WITH_FIPS = "An endpoint cannot set when fs.s3a.endpoint.fips is true";

    @Override
    public S3Client createS3Client(URI uri, S3ClientFactory.S3ClientCreationParameters parameters) throws IOException {
        Configuration conf = this.getConf();
        String bucket = uri.getHost();
        ApacheHttpClient.Builder httpClientBuilder = AWSClientConfig.createHttpClientBuilder(conf).proxyConfiguration(AWSClientConfig.createProxyConfiguration(conf, bucket));
        return (S3Client)((S3ClientBuilder)this.configureClientBuilder(S3Client.builder(), parameters, conf, bucket).httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder)).build();
    }

    @Override
    public S3AsyncClient createS3AsyncClient(URI uri, S3ClientFactory.S3ClientCreationParameters parameters) throws IOException {
        Configuration conf = this.getConf();
        String bucket = uri.getHost();
        NettyNioAsyncHttpClient.Builder httpClientBuilder = AWSClientConfig.createAsyncHttpClientBuilder(conf).proxyConfiguration(AWSClientConfig.createAsyncProxyConfiguration(conf, bucket));
        MultipartConfiguration multipartConfiguration = (MultipartConfiguration)MultipartConfiguration.builder().minimumPartSizeInBytes(Long.valueOf(parameters.getMinimumPartSize())).thresholdInBytes(Long.valueOf(parameters.getMultiPartThreshold())).build();
        return (S3AsyncClient)((S3AsyncClientBuilder)this.configureClientBuilder(S3AsyncClient.builder(), parameters, conf, bucket).httpClientBuilder((SdkAsyncHttpClient.Builder)httpClientBuilder)).multipartConfiguration(multipartConfiguration).multipartEnabled(Boolean.valueOf(parameters.isMultipartCopy())).build();
    }

    @Override
    public S3TransferManager createS3TransferManager(S3AsyncClient s3AsyncClient) {
        return S3TransferManager.builder().s3Client(s3AsyncClient).build();
    }

    private <BuilderT extends S3BaseClientBuilder<BuilderT, ClientT>, ClientT> BuilderT configureClientBuilder(BuilderT builder, S3ClientFactory.S3ClientCreationParameters parameters, Configuration conf, String bucket) throws IOException {
        this.configureEndpointAndRegion(builder, parameters, conf);
        S3Configuration serviceConfiguration = (S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(Boolean.valueOf(parameters.isPathStyleAccess())).checksumValidationEnabled(Boolean.valueOf(parameters.isChecksumValidationEnabled())).build();
        ClientOverrideConfiguration.Builder override = this.createClientOverrideConfiguration(parameters, conf);
        S3BaseClientBuilder s3BaseClientBuilder = ((S3BaseClientBuilder)((S3BaseClientBuilder)builder.overrideConfiguration((ClientOverrideConfiguration)override.build())).credentialsProvider(parameters.getCredentialSet())).disableS3ExpressSessionAuth(Boolean.valueOf(!parameters.isExpressCreateSession())).serviceConfiguration(serviceConfiguration);
        if (conf.getBoolean("fs.s3a.http.signer.enabled", false)) {
            AuthScheme<AwsCredentialsIdentity> signer = SignerFactory.createHttpSigner(conf, "aws.auth#sigv4", "fs.s3a.http.signer.class");
            builder.putAuthScheme(signer);
        }
        return (BuilderT)s3BaseClientBuilder;
    }

    protected ClientOverrideConfiguration.Builder createClientOverrideConfiguration(S3ClientFactory.S3ClientCreationParameters parameters, Configuration conf) throws IOException {
        ClientOverrideConfiguration.Builder clientOverrideConfigBuilder = AWSClientConfig.createClientConfigBuilder(conf, "S3");
        parameters.getHeaders().forEach((h, v) -> clientOverrideConfigBuilder.putHeader(h, v));
        if (parameters.isRequesterPays()) {
            clientOverrideConfigBuilder.putHeader("x-amz-request-payer", REQUESTER_PAYS_HEADER_VALUE);
        }
        if (!StringUtils.isEmpty((CharSequence)parameters.getUserAgentSuffix())) {
            clientOverrideConfigBuilder.putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_SUFFIX, (Object)parameters.getUserAgentSuffix());
        }
        if (parameters.getExecutionInterceptors() != null) {
            for (ExecutionInterceptor interceptor : parameters.getExecutionInterceptors()) {
                clientOverrideConfigBuilder.addExecutionInterceptor(interceptor);
            }
        }
        if (parameters.getMetrics() != null) {
            clientOverrideConfigBuilder.addMetricPublisher((MetricPublisher)new AwsStatisticsCollector(parameters.getMetrics()));
        }
        RetryPolicy.Builder retryPolicyBuilder = AWSClientConfig.createRetryPolicyBuilder(conf);
        clientOverrideConfigBuilder.retryPolicy(retryPolicyBuilder.build());
        return clientOverrideConfigBuilder;
    }

    private <BuilderT extends S3BaseClientBuilder<BuilderT, ClientT>, ClientT> void configureEndpointAndRegion(BuilderT builder, S3ClientFactory.S3ClientCreationParameters parameters, Configuration conf) {
        boolean fipsEnabled;
        String endpointStr = parameters.getEndpoint();
        URI endpoint = DefaultS3ClientFactory.getS3Endpoint(endpointStr, conf);
        String configuredRegion = parameters.getRegion();
        Region region = null;
        String origin = "";
        if (configuredRegion != null && !configuredRegion.isEmpty()) {
            origin = "fs.s3a.endpoint.region";
            region = Region.of((String)configuredRegion);
        }
        if (fipsEnabled = parameters.isFipsEnabled()) {
            LOG.debug("Enabling FIPS mode");
        }
        builder.fipsEnabled(Boolean.valueOf(fipsEnabled));
        if (endpoint != null) {
            Preconditions.checkArgument((!fipsEnabled ? 1 : 0) != 0, (String)"%s : %s", (Object[])new Object[]{ERROR_ENDPOINT_WITH_FIPS, endpoint});
            boolean endpointEndsWithCentral = endpointStr.endsWith("s3.amazonaws.com");
            if (region == null && (region = DefaultS3ClientFactory.getS3RegionFromEndpoint(endpointStr, endpointEndsWithCentral)) != null) {
                origin = "endpoint";
            }
            if (!endpointEndsWithCentral) {
                builder.endpointOverride(endpoint);
                LOG.debug("Setting endpoint to {}", (Object)endpoint);
            } else {
                builder.crossRegionAccessEnabled(Boolean.valueOf(true));
                origin = "central endpoint with cross region access";
                LOG.debug("Enabling cross region access for endpoint {}", (Object)endpointStr);
            }
        }
        if (region != null) {
            builder.region(region);
        } else if (configuredRegion == null) {
            region = Region.of((String)"us-east-2");
            builder.crossRegionAccessEnabled(Boolean.valueOf(true));
            builder.region(region);
            origin = "cross region access fallback";
        } else if (configuredRegion.isEmpty()) {
            WARN_OF_DEFAULT_REGION_CHAIN.warn(SDK_REGION_CHAIN_IN_USE, new Object[0]);
            LOG.debug(SDK_REGION_CHAIN_IN_USE);
            origin = "SDK region chain";
        }
        LOG.debug("Setting region to {} from {}", (Object)region, (Object)origin);
    }

    private static URI getS3Endpoint(String endpoint, Configuration conf) {
        String protocol;
        boolean secureConnections = conf.getBoolean("fs.s3a.connection.ssl.enabled", true);
        String string = protocol = secureConnections ? "https" : "http";
        if (endpoint == null || endpoint.isEmpty()) {
            return null;
        }
        if (!endpoint.contains("://")) {
            endpoint = String.format("%s://%s", protocol, endpoint);
        }
        try {
            return new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Region getS3RegionFromEndpoint(String endpoint, boolean endpointEndsWithCentral) {
        if (!endpointEndsWithCentral) {
            LOG.debug("Endpoint {} is not the default; parsing", (Object)endpoint);
            return AwsHostNameUtils.parseSigningRegion((String)endpoint, (String)S3_SERVICE_NAME).orElse(null);
        }
        return Region.of((String)"us-east-2");
    }
}

