/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.StringJoiner;
import javax.sql.DataSource;
import org.apache.baremaps.database.collection.DataMap;
import org.apache.baremaps.openstreetmap.model.Node;
import org.apache.baremaps.openstreetmap.model.Relation;
import org.apache.baremaps.openstreetmap.model.Way;
import org.apache.baremaps.openstreetmap.pbf.PbfBlockReader;
import org.apache.baremaps.openstreetmap.pbf.PbfReader;
import org.apache.baremaps.openstreetmap.postgres.PostgresHeaderRepository;
import org.apache.baremaps.openstreetmap.postgres.PostgresNodeRepository;
import org.apache.baremaps.openstreetmap.postgres.PostgresRelationRepository;
import org.apache.baremaps.openstreetmap.postgres.PostgresWayRepository;
import org.apache.baremaps.openstreetmap.repository.BlockImporter;
import org.apache.baremaps.openstreetmap.repository.HeaderRepository;
import org.apache.baremaps.openstreetmap.repository.Repository;
import org.apache.baremaps.stream.StreamUtils;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.locationtech.jts.geom.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportOsmPbf
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(ImportOsmPbf.class);
    private Path file;
    private Object database;
    private Integer databaseSrid;
    private Boolean replaceExisting;

    public ImportOsmPbf() {
    }

    public ImportOsmPbf(Path file, Object database, Integer databaseSrid, Boolean replaceExisting) {
        this.file = file;
        this.database = database;
        this.databaseSrid = databaseSrid;
        this.replaceExisting = replaceExisting;
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        Path path = this.file.toAbsolutePath();
        DataSource datasource = context.getDataSource(this.database);
        PostgresHeaderRepository headerRepository = new PostgresHeaderRepository(datasource);
        PostgresNodeRepository nodeRepository = new PostgresNodeRepository(datasource);
        PostgresWayRepository wayRepository = new PostgresWayRepository(datasource);
        PostgresRelationRepository relationRepository = new PostgresRelationRepository(datasource);
        if (this.replaceExisting.booleanValue()) {
            headerRepository.drop();
            nodeRepository.drop();
            wayRepository.drop();
            relationRepository.drop();
            headerRepository.create();
            nodeRepository.create();
            wayRepository.create();
            relationRepository.create();
        }
        DataMap<Long, Coordinate> coordinateMap = context.getCoordinateMap();
        DataMap<Long, List<Long>> referenceMap = context.getReferenceMap();
        ImportOsmPbf.execute(path, coordinateMap, referenceMap, headerRepository, nodeRepository, wayRepository, relationRepository, this.databaseSrid);
    }

    public static void execute(Path path, DataMap<Long, Coordinate> coordinateMap, DataMap<Long, List<Long>> referenceMap, HeaderRepository headerRepository, Repository<Long, Node> nodeRepository, Repository<Long, Way> wayRepository, Repository<Long, Relation> relationRepository, Integer databaseSrid) throws IOException {
        PbfReader reader = ((PbfBlockReader)new PbfBlockReader().geometries(true).projection(databaseSrid).coordinateMap((DataMap)coordinateMap)).referenceMap((DataMap)referenceMap);
        BlockImporter importer = new BlockImporter(headerRepository, nodeRepository, wayRepository, relationRepository);
        try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
            StreamUtils.batch(((PbfBlockReader)reader).stream(input)).forEach(importer);
        }
    }

    public String toString() {
        return new StringJoiner(", ", ImportOsmPbf.class.getSimpleName() + "[", "]").add("file=" + this.file).add("database=" + this.database).add("databaseSrid=" + this.databaseSrid).add("replaceExisting=" + this.replaceExisting).toString();
    }
}

