/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.baremaps.database.collection.AppendOnlyBuffer;
import org.apache.baremaps.database.collection.DataMap;
import org.apache.baremaps.database.collection.MemoryAlignedDataList;
import org.apache.baremaps.database.collection.MemoryAlignedDataMap;
import org.apache.baremaps.database.collection.MonotonicDataMap;
import org.apache.baremaps.database.memory.MemoryMappedDirectory;
import org.apache.baremaps.database.type.DataType;
import org.apache.baremaps.database.type.FixedSizeDataType;
import org.apache.baremaps.database.type.LongDataType;
import org.apache.baremaps.database.type.LongListDataType;
import org.apache.baremaps.database.type.PairDataType;
import org.apache.baremaps.database.type.geometry.LonLatDataType;
import org.apache.baremaps.utils.FileUtils;
import org.apache.baremaps.utils.PostgresUtils;
import org.locationtech.jts.geom.Coordinate;

public class WorkflowContext {
    private final Path dataDir;
    private final Path cacheDir;
    private Map<Object, DataSource> dataSources = new ConcurrentHashMap<Object, DataSource>();

    public WorkflowContext() {
        this(Paths.get("./data", new String[0]), Paths.get("./cache", new String[0]));
    }

    public WorkflowContext(Path dataDir, Path cacheDir) {
        this.dataDir = dataDir;
        this.cacheDir = cacheDir;
    }

    public DataSource getDataSource(Object database) {
        return this.dataSources.computeIfAbsent(database, PostgresUtils::createDataSourceFromObject);
    }

    public DataMap<Long, Coordinate> getCoordinateMap() throws IOException {
        return this.getMemoryAlignedDataMap("coordinates", new LonLatDataType());
    }

    public DataMap<Long, List<Long>> getReferenceMap() throws IOException {
        return this.getMonotonicDataMap("references", new LongListDataType());
    }

    public <T> DataMap<Long, T> getMemoryAlignedDataMap(String name, FixedSizeDataType<T> dataType) throws IOException {
        Path coordinateDir = Files.createDirectories(this.cacheDir.resolve(name), new FileAttribute[0]);
        return new MemoryAlignedDataMap<T>(dataType, new MemoryMappedDirectory(coordinateDir));
    }

    public <T> DataMap<Long, T> getMonotonicDataMap(String name, DataType<T> dataType) throws IOException {
        Path mapDir = Files.createDirectories(this.cacheDir.resolve(name), new FileAttribute[0]);
        Path keysDir = Files.createDirectories(mapDir.resolve("keys"), new FileAttribute[0]);
        Path valuesDir = Files.createDirectories(mapDir.resolve("values"), new FileAttribute[0]);
        return new MonotonicDataMap<T>(new MemoryAlignedDataList<PairDataType.Pair<Long, Long>>(new PairDataType<Long, Long>(new LongDataType(), new LongDataType()), new MemoryMappedDirectory(keysDir)), new AppendOnlyBuffer<T>(dataType, new MemoryMappedDirectory(valuesDir)));
    }

    public void cleanCache() throws IOException {
        FileUtils.deleteRecursively(this.cacheDir);
    }

    public void cleanData() throws IOException {
        FileUtils.deleteRecursively(this.dataDir);
    }
}

